/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.fossil;

import de.hysky.skyblocker.skyblock.dwarven.fossil.FossilTypes;
import java.util.Arrays;

public class Structures {

    protected record permutation(FossilTypes type, TileGrid grid, int xOffset, int yOffset) {
        boolean isValid(TileGrid currentState, String percentage) {
            if (percentage != null && !percentage.equals(this.type.percentage)) {
                return false;
            }
            for (int x = 0; x < currentState.width(); ++x) {
                block6: for (int y = 0; y < currentState.height(); ++y) {
                    TileState knownState = currentState.getSlot(x, y);
                    switch (knownState.ordinal()) {
                        case 0: {
                            continue block6;
                        }
                        case 2: {
                            if (this.isFossilCollision(x, y)) continue block6;
                            return false;
                        }
                        case 1: {
                            if (this.isEmptyCollision(x, y)) continue block6;
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        private boolean isEmptyCollision(int positionX, int positionY) {
            try {
                return this.isState(positionX, positionY, TileState.EMPTY);
            }
            catch (IndexOutOfBoundsException f) {
                return true;
            }
        }

        boolean isFossilCollision(int positionX, int positionY) {
            try {
                return this.isState(positionX, positionY, TileState.FOSSIL);
            }
            catch (IndexOutOfBoundsException f) {
                return false;
            }
        }

        private boolean isState(int positionX, int positionY, TileState state) {
            int x = positionX - this.xOffset;
            int y = positionY - this.yOffset;
            if (x < 0 || x >= this.grid.width() || y < 0 || y >= this.grid.height()) {
                throw new IndexOutOfBoundsException("not in grid");
            }
            return this.grid.getSlot(x, y) == state;
        }
    }

    protected record TileGrid(TileState[][] state) {
        void updateSlot(int x, int y, TileState newState) {
            this.state[y][x] = newState;
        }

        TileState getSlot(int x, int y) {
            return this.state[y][x];
        }

        int width() {
            return this.state[0].length;
        }

        int height() {
            return this.state.length;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            TileState[][] state2;
            if (this == o) {
                return true;
            }
            if (!(o instanceof TileGrid)) return false;
            TileGrid tileGrid = (TileGrid)o;
            try {
                TileState[][] tileStateArray;
                state2 = tileStateArray = tileGrid.state();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return Arrays.deepEquals((Object[])this.state, (Object[])state2);
        }

        @Override
        public int hashCode() {
            return Arrays.deepHashCode((Object[])this.state);
        }
    }

    protected static enum TransformationOptions {
        ROTATED_0,
        ROTATED_90,
        ROTATED_180,
        ROTATED_270,
        FLIP_ROTATED_0,
        FLIP_ROTATED_90,
        FLIP_ROTATED_180,
        FLIP_ROTATED_270;

    }

    protected static enum TileState {
        UNKNOWN,
        EMPTY,
        FOSSIL;

    }
}

