/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.end;

import com.mojang.authlib.properties.PropertyMap;
import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.end.TheEnd;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.Location;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

@RegisterWidget
public class EndHudWidget
extends ComponentBasedWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"The End").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067});
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.THE_END);
    private static EndHudWidget instance = null;
    private static final class_1799 ENDERMAN_HEAD = (class_1799)class_156.method_654((Object)new class_1799((class_1935)class_1802.field_8575), stack -> stack.method_57379(class_9334.field_49617, (Object)new class_9296(Optional.of("MHF_Enderman"), Optional.empty(), new PropertyMap())));
    private static final class_1799 POPPY = (class_1799)class_156.method_654((Object)new class_1799((class_1935)class_1802.field_8880), stack -> stack.method_57379(class_9334.field_49641, (Object)true));

    public EndHudWidget() {
        super(TITLE, class_124.field_1064.method_532(), "hud_end");
        instance = this;
        this.update();
    }

    public static EndHudWidget getInstance() {
        return instance;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return location.equals((Object)Location.THE_END) && SkyblockerConfigManager.get().otherLocations.end.hudEnabled;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!location.equals((Object)Location.THE_END)) {
            return;
        }
        SkyblockerConfigManager.get().otherLocations.end.hudEnabled = enabled;
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public void updateContent() {
        if (SkyblockerConfigManager.get().otherLocations.end.zealotKillsEnabled) {
            TheEnd.EndStats endStats = TheEnd.PROFILES_STATS.computeIfAbsent(TheEnd.EndStats.EMPTY);
            assert (endStats != null);
            this.addComponent(Components.iconTextComponent(ENDERMAN_HEAD, (class_2561)class_2561.method_43470((String)"Zealots").method_27692(class_124.field_1067)));
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.zealotsSinceLastEye", (Object[])new Object[]{endStats.zealotsSinceLastEye()})));
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.zealotsTotalKills", (Object[])new Object[]{Formatters.INTEGER_NUMBERS.format(endStats.totalZealotKills())})));
            String avg = endStats.eyes() == 0 ? "???" : Formatters.DOUBLE_NUMBERS.format((float)endStats.totalZealotKills() / (float)endStats.eyes());
            this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.avgKillsPerEye", (Object[])new Object[]{avg})));
        }
        if (SkyblockerConfigManager.get().otherLocations.end.protectorLocationEnabled) {
            this.addComponent(Components.iconTextComponent(POPPY, (class_2561)class_2561.method_43470((String)"Endstone Protector").method_27692(class_124.field_1067)));
            if (TheEnd.stage == 5) {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.stage", (Object[])new Object[]{"IMMINENT"})));
            } else {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.stage", (Object[])new Object[]{String.valueOf(TheEnd.stage)})));
            }
            if (TheEnd.currentProtectorLocation == null) {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.location", (Object[])new Object[]{"?"})));
            } else {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43469((String)"skyblocker.end.hud.location", (Object[])new Object[]{TheEnd.currentProtectorLocation.name()})));
            }
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"End Hud");
    }
}

