/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.end;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.end.EndHudWidget;
import de.hysky.skyblocker.skyblock.end.TheEnd;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.apache.commons.lang3.math.NumberUtils;

public class EndStatsBestiaryUpdater
extends SimpleContainerSolver {
    private static final Pattern KILLS_PATTERN = Pattern.compile("Kills: ([0-9,]+)");
    private static final int ALL_ZEALOTS_INDEX = 4;
    private static final int SPECIAL_ZEALOT_INDEX = 22;

    public EndStatsBestiaryUpdater() {
        super("The End \u279c Zealot");
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        slots.int2ObjectEntrySet().stream().filter(entry -> entry.getIntKey() == 4 || entry.getIntKey() == 22).filter(entry -> ((class_1799)entry.getValue()).method_31574(class_1802.field_8466)).forEach(entry -> {
            Matcher matcher = ItemUtils.getLoreLineIfMatch((class_1799)entry.getValue(), KILLS_PATTERN);
            if (matcher == null) {
                return;
            }
            String killsStr = matcher.group(1).replace(",", "");
            if (!NumberUtils.isCreatable((String)killsStr)) {
                return;
            }
            int kills = NumberUtils.toInt((String)killsStr);
            TheEnd.EndStats stats = TheEnd.PROFILES_STATS.computeIfAbsent(TheEnd.EndStats.EMPTY);
            assert (stats != null);
            if (entry.getIntKey() == 4) {
                TheEnd.PROFILES_STATS.put(new TheEnd.EndStats(kills, stats.zealotsSinceLastEye(), stats.eyes()));
            } else if (entry.getIntKey() == 22) {
                TheEnd.PROFILES_STATS.put(new TheEnd.EndStats(stats.totalZealotKills(), stats.zealotsSinceLastEye(), kills));
            }
            EndHudWidget.getInstance().update();
        });
        return List.of();
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().otherLocations.end.zealotKillsEnabled;
    }
}

