/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.experiment;

import de.hysky.skyblocker.config.configs.HelperConfig;
import de.hysky.skyblocker.skyblock.experiment.ExperimentSolver;
import de.hysky.skyblocker.utils.container.ContainerSolverManager;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1707;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2504;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_476;
import org.jetbrains.annotations.Nullable;

public final class UltrasequencerSolver
extends ExperimentSolver {
    public static final UltrasequencerSolver INSTANCE = new UltrasequencerSolver();
    private static final int[] PANE_SLOTS = IntStream.rangeClosed(9, 44).toArray();
    private int ultrasequencerNextSlot;
    @Nullable
    private class_1767 lastColor;

    private UltrasequencerSolver() {
        super("^Ultrasequencer \\(\\w+\\)$");
    }

    @Override
    protected boolean isEnabled(HelperConfig.Experiments experimentsConfig) {
        return experimentsConfig.enableUltrasequencerSolver;
    }

    @Override
    protected void tick(class_476 screen) {
        switch (this.getState()) {
            case REMEMBER: {
                class_1263 inventory = ((class_1707)screen.method_17577()).method_7629();
                if (!inventory.method_5438(49).method_7964().getString().equals("Remember the pattern!")) break;
                for (int index = 9; index < 45; ++index) {
                    class_1799 itemStack = inventory.method_5438(index);
                    String name = itemStack.method_7964().getString();
                    if (!name.matches("\\d+")) continue;
                    if (name.equals("1")) {
                        this.ultrasequencerNextSlot = index;
                    }
                    this.getSlots().put(index, (Object)itemStack);
                }
                this.setState(ExperimentSolver.State.WAIT);
                break;
            }
            case WAIT: {
                if (!((class_1707)screen.method_17577()).method_7629().method_5438(49).method_7964().getString().startsWith("Timer: ")) break;
                this.setState(ExperimentSolver.State.SHOW);
                ContainerSolverManager.markHighlightsDirty();
                break;
            }
            case END: {
                String name = ((class_1707)screen.method_17577()).method_7629().method_5438(49).method_7964().getString();
                if (name.startsWith("Timer: ")) break;
                if (name.equals("Remember the pattern!")) {
                    this.getSlots().clear();
                    this.setState(ExperimentSolver.State.REMEMBER);
                    break;
                }
                this.reset();
            }
        }
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        return this.getState() == ExperimentSolver.State.SHOW && this.ultrasequencerNextSlot != 0 ? List.of(ColorHighlight.green(this.ultrasequencerNextSlot)) : List.of();
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (this.getState() == ExperimentSolver.State.SHOW) {
            if (slot == this.ultrasequencerNextSlot) {
                int count = ((class_1799)this.getSlots().get(this.ultrasequencerNextSlot)).method_7947() + 1;
                this.getSlots().int2ObjectEntrySet().stream().filter(entry -> ((class_1799)entry.getValue()).method_7947() == count).findAny().map(Int2ObjectMap.Entry::getIntKey).ifPresent(nextSlot -> {
                    this.ultrasequencerNextSlot = nextSlot;
                });
            } else {
                return this.shouldBlockIncorrectClicks();
            }
        }
        return super.onClickSlot(slot, stack, screenId, button);
    }

    @Override
    public void markDirty() {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof class_476) {
            class_476 genericContainerScreen = (class_476)class_4372;
            List slots = ((class_1707)genericContainerScreen.method_17577()).field_7761.subList(0, ((class_1707)genericContainerScreen.method_17577()).method_17388() * 9);
            Int2ObjectMap<class_1799> slotMap = ContainerSolverManager.slotMap(slots);
            for (int paneSlot : PANE_SLOTS) {
                class_2504 stainedGlassPaneBlock;
                class_1767 paneColor;
                class_1747 blockItem;
                class_1792 class_17922;
                class_1799 slotItem = (class_1799)slotMap.get(paneSlot);
                if (slotItem == null || slotItem.method_7960() || !((class_17922 = slotItem.method_7909()) instanceof class_1747) || !((class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2504) || (paneColor = (stainedGlassPaneBlock = (class_2504)class_17922).method_10622()) == class_1767.field_7963 || this.lastColor == paneColor) continue;
                if (this.lastColor != null) {
                    this.setState(ExperimentSolver.State.END);
                }
                this.lastColor = paneColor;
                return;
            }
        }
    }

    @Override
    public void reset() {
        this.ultrasequencerNextSlot = 0;
        this.lastColor = null;
        super.reset();
    }
}

