/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.garden;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.injected.RecipeBookHolder;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.gui.ItemButtonWidget;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_9017;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GardenPlotsWidget
extends class_9017 {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Garden Plots");
    private static final Path FOLDER = SkyblockerMod.CONFIG_DIR.resolve("garden_plots");
    public static final Int2IntMap GARDEN_PLOT_TO_SLOT = Int2IntMaps.unmodifiable((Int2IntMap)new Int2IntOpenHashMap(Map.ofEntries(Map.entry(1, 7), Map.entry(2, 11), Map.entry(3, 13), Map.entry(4, 17), Map.entry(5, 6), Map.entry(6, 8), Map.entry(7, 16), Map.entry(8, 18), Map.entry(9, 2), Map.entry(10, 10), Map.entry(11, 14), Map.entry(12, 22), Map.entry(13, 1), Map.entry(14, 3), Map.entry(15, 5), Map.entry(16, 9), Map.entry(17, 15), Map.entry(18, 19), Map.entry(19, 21), Map.entry(20, 23), Map.entry(21, 0), Map.entry(22, 4), Map.entry(23, 20), Map.entry(24, 24))));
    private static final GardenPlot[] gardenPlots = new GardenPlot[25];
    private static final class_2960 BACKGROUND_TEXTURE = SkyblockerMod.id("textures/gui/garden_plots.png");
    private static final class_5250 GROSS_PEST_TEXT = class_2561.method_43471((String)"skyblocker.gardenPlots.pests").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
    private static final class_5250 TP_TEXT = class_2561.method_43471((String)"skyblocker.gardenPlots.tp").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
    private final class_1799[] items;
    private int hoveredSlot = -1;
    private long updateFromTabTime = System.currentTimeMillis();
    private final IntList infectedPlots = new IntArrayList(8);
    private final ItemButtonWidget[] widgets;

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_476) {
                class_476 containerScreen = (class_476)screen;
                if (screen.method_25440().getString().trim().equals("Configure Plots")) {
                    ScreenEvents.remove((class_437)screen).register(ignored -> {
                        class_1707 screenHandler = (class_1707)containerScreen.method_17577();
                        for (int row = 0; row < 5; ++row) {
                            for (int i = row * 9 + 2; i < row * 9 + 7; ++i) {
                                class_1735 slot;
                                class_1799 stack;
                                if (i == 22 || (stack = (slot = (class_1735)screenHandler.field_7761.get(i)).method_7677()).method_7960() || stack.method_31574(class_1802.field_8879) || stack.method_31574(class_1802.field_8780) || stack.method_31574(class_1802.field_8157)) continue;
                                String name = class_124.method_539((String)stack.method_7964().getString());
                                String[] parts = name.split("-", 2);
                                if (parts.length < 2) {
                                    LOGGER.warn("Invalid plot name: {}", (Object)name);
                                    continue;
                                }
                                GardenPlotsWidget.gardenPlots[i / 9 * 5 + (i % 9 - 2)] = new GardenPlot(stack.method_7909(), parts[1].trim());
                            }
                        }
                    });
                    return;
                }
            }
            if (!(screen instanceof class_490)) return;
            class_490 inventoryScreen = (class_490)screen;
            if (!Utils.getLocation().equals((Object)Location.GARDEN)) return;
            if (!SkyblockerConfigManager.get().farming.garden.gardenPlotsWidget) return;
            GardenPlotsWidget widget = new GardenPlotsWidget(((HandledScreenAccessor)inventoryScreen).getX() + ((HandledScreenAccessor)inventoryScreen).getBackgroundWidth() + 4, ((HandledScreenAccessor)inventoryScreen).getY());
            Screens.getButtons((class_437)inventoryScreen).add(widget);
            ((RecipeBookHolder)inventoryScreen).registerRecipeBookToggleCallback(() -> widget.method_48229(((HandledScreenAccessor)inventoryScreen).getX() + ((HandledScreenAccessor)inventoryScreen).getBackgroundWidth() + 4, ((HandledScreenAccessor)inventoryScreen).getY()));
        });
        SkyblockEvents.PROFILE_CHANGE.register((prevProfileId, profileId) -> {
            if (!prevProfileId.isEmpty()) {
                CompletableFuture.runAsync(() -> GardenPlotsWidget.save(prevProfileId)).thenRun(() -> GardenPlotsWidget.load(profileId));
            } else {
                GardenPlotsWidget.load(profileId);
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client1 -> {
            String profileId = Utils.getProfileId();
            if (!profileId.isBlank()) {
                CompletableFuture.runAsync(() -> GardenPlotsWidget.save(profileId));
            }
        });
    }

    private static void save(String profileId) {
        try {
            Files.createDirectories(FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to create folder for garden plots!", (Throwable)e);
        }
        Path resolve = FOLDER.resolve(profileId + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(resolve, new OpenOption[0]);){
            JsonArray elements = new JsonArray();
            Arrays.stream(gardenPlots).map(gardenPlot -> {
                if (gardenPlot == null) {
                    return null;
                }
                JsonObject jsonObject = new JsonObject();
                jsonObject.add("icon", (JsonElement)class_1792.field_54952.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)gardenPlot.item.method_40131()).getOrThrow());
                jsonObject.addProperty("name", gardenPlot.name);
                return jsonObject;
            }).forEach(arg_0 -> ((JsonArray)elements).add(arg_0));
            SkyblockerMod.GSON.toJson((JsonElement)elements, (Appendable)writer);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to save Garden Plots data", (Throwable)e);
        }
    }

    private static void load(String profileId) {
        Path resolve = FOLDER.resolve(profileId + ".json");
        CompletableFuture.supplyAsync(() -> {
            block10: {
                GardenPlot[] gardenPlotArray;
                block9: {
                    BufferedReader reader2 = Files.newBufferedReader(resolve);
                    try {
                        gardenPlotArray = (GardenPlot[])((JsonArray)SkyblockerMod.GSON.fromJson((Reader)reader2, JsonArray.class)).asList().stream().map(jsonElement -> {
                            if (jsonElement == null || jsonElement.isJsonNull()) {
                                return null;
                            }
                            JsonObject jsonObject = jsonElement.getAsJsonObject();
                            return new GardenPlot((class_1792)((class_6880)((Pair)class_1792.field_54952.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.get("icon")).getOrThrow()).getFirst()).comp_349(), jsonObject.get("name").getAsString());
                        }).toArray(GardenPlot[]::new);
                        if (reader2 == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader2 != null) {
                                try {
                                    reader2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (NoSuchFileException reader2) {
                            break block10;
                        }
                        catch (Exception e) {
                            LOGGER.error("[Skyblocker] Failed to load Equipment data", (Throwable)e);
                        }
                    }
                    reader2.close();
                }
                return gardenPlotArray;
            }
            return new GardenPlot[25];
        }).thenAccept(newPlots -> class_310.method_1551().execute(() -> System.arraycopy(newPlots, 0, gardenPlots, 0, Math.min(((GardenPlot[])newPlots).length, 25))));
    }

    public GardenPlotsWidget(int x, int y) {
        super(x, y, 104, 132, (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots"));
        this.items = (class_1799[])Arrays.stream(gardenPlots).map(gardenPlot -> {
            if (gardenPlot == null) {
                return null;
            }
            class_1799 itemStack = new class_1799((class_1935)gardenPlot.item());
            itemStack.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)gardenPlot.name()).method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            return itemStack;
        }).toArray(class_1799[]::new);
        this.items[12] = new class_1799((class_1935)class_1802.field_23256);
        this.items[12].method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)"The Barn"));
        this.updateInfestedFromTab();
        ItemButtonWidget deskButton = new ItemButtonWidget(this.method_46426() + 7, this.method_55443() - 24, new class_1799((class_1935)class_1802.field_8529), (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots.openDesk"), button -> MessageScheduler.INSTANCE.sendMessageAfterCooldown("/desk", true));
        ItemButtonWidget spawnButton = new ItemButtonWidget(this.method_55442() - 7 - 40 - 2, this.method_55443() - 24, new class_1799((class_1935)class_1802.field_8449), (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots.spawn"), button -> MessageScheduler.INSTANCE.sendMessageAfterCooldown("/warp garden", true));
        ItemButtonWidget setSpawnButton = new ItemButtonWidget(this.method_55442() - 7 - 20, this.method_55443() - 24, new class_1799((class_1935)(Math.random() < 0.001 ? class_1802.field_8417 : class_1802.field_8789)), (class_2561)class_2561.method_43471((String)"skyblocker.gardenPlots.setSpawn"), button -> MessageScheduler.INSTANCE.sendMessageAfterCooldown("/setspawn", true));
        this.widgets = new ItemButtonWidget[]{deskButton, spawnButton, setSpawnButton};
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)this.method_46426(), (float)this.method_46427());
        context.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        context.method_51439(textRenderer, this.method_25369(), 8, 6, -12566464, false);
        this.hoveredSlot = -1;
        long timeMillis = System.currentTimeMillis();
        for (int i = 0; i < this.items.length; ++i) {
            boolean hovered;
            class_1799 item = this.items[i];
            if (item == null) continue;
            int slotX = 7 + i % 5 * 18;
            int slotY = 17 + i / 5 * 18;
            boolean bl = hovered = slotX + this.method_46426() <= mouseX && mouseX < slotX + this.method_46426() + 18 && slotY + this.method_46427() <= mouseY && mouseY < slotY + this.method_46427() + 18;
            if (hovered) {
                context.method_25294(slotX + 1, slotY + 1, slotX + 17, slotY + 17, -1426063361);
                matrices.pushMatrix();
                matrices.translate((float)slotX, (float)slotY);
                matrices.scale(1.125f, 1.125f);
                context.method_51427(item, 0, 0);
                matrices.popMatrix();
                this.hoveredSlot = i;
            } else {
                context.method_51427(item, slotX + 1, slotY + 1);
            }
            boolean infested = this.infectedPlots.contains(i);
            if (infested && (timeMillis & 0x200L) != 0L) {
                context.method_49601(slotX + 1, slotY + 1, 16, 16, -65536);
            }
            if (!hovered) continue;
            List<class_5250> tooltip = infested ? List.of(class_2561.method_43469((String)"skyblocker.gardenPlots.plot", (Object[])new Object[]{item.method_7964()}), GROSS_PEST_TEXT, class_2561.method_43473(), TP_TEXT) : (i == 12 ? List.of(item.method_7964(), class_2561.method_43473(), TP_TEXT) : List.of(class_2561.method_43469((String)"skyblocker.gardenPlots.plot", (Object[])new Object[]{item.method_7964()}), class_2561.method_43473(), TP_TEXT));
            context.method_51434(textRenderer, tooltip, mouseX, mouseY);
        }
        matrices.popMatrix();
        for (ItemButtonWidget widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, delta);
        }
        if (timeMillis - this.updateFromTabTime > 3000L) {
            this.updateFromTabTime = timeMillis;
            this.updateInfestedFromTab();
        }
    }

    private void updateInfestedFromTab() {
        this.infectedPlots.clear();
        for (int i = 0; i < PlayerListManager.getPlayerStringList().size(); ++i) {
            String[] split;
            String string = PlayerListManager.getPlayerStringList().get(i);
            if (!string.startsWith("Plots:")) continue;
            for (String s : split = string.split(":")[1].split(",")) {
                try {
                    this.infectedPlots.add(GARDEN_PLOT_TO_SLOT.getOrDefault(Integer.parseInt(s.strip()), -1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            break;
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        if (this.hoveredSlot == -1) {
            return;
        }
        if (SkyblockerConfigManager.get().farming.garden.closeScreenOnPlotClick && class_310.method_1551().field_1755 != null) {
            class_310.method_1551().field_1755.method_25419();
        }
        if (this.hoveredSlot == 12) {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/plottp barn", true);
        } else {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("/plottp " + GardenPlotsWidget.gardenPlots[this.hoveredSlot].name, true);
        }
    }

    protected boolean method_25351(int button) {
        return super.method_25351(button) && this.hoveredSlot != -1;
    }

    protected void method_47399(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return List.of(this.widgets);
    }

    protected int method_44395() {
        return this.method_25364();
    }

    protected double method_44393() {
        return 0.0;
    }

    public void method_46421(int x) {
        int prevX = this.method_46426();
        super.method_46421(x);
        int diff = x - prevX;
        for (ItemButtonWidget widget : this.widgets) {
            widget.method_46421(widget.method_46426() + diff);
        }
    }

    public void method_46419(int y) {
        int prevY = this.method_46427();
        super.method_46419(y);
        int diff = y - prevY;
        for (ItemButtonWidget widget : this.widgets) {
            widget.method_46419(widget.method_46427() + diff);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_25405(mouseX, mouseY) && this.method_25351(button)) {
            this.method_25348(mouseX, mouseY);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private record GardenPlot(class_1792 item, String name) {
    }
}

