/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import de.hysky.skyblocker.skyblock.museum.Donation;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class ItemFilter {
    private FilterMode currentFilterMode = FilterMode.ALL;
    private static final UnaryOperator<List<Donation>> FILTER_ALL = donations -> donations;
    private static final UnaryOperator<List<Donation>> FILTER_WEAPONS = donations -> donations.stream().filter(d -> "weapons".equals(d.getCategory())).collect(Collectors.toList());
    private static final UnaryOperator<List<Donation>> FILTER_ARMOR = donations -> donations.stream().filter(d -> "armor".equals(d.getCategory())).collect(Collectors.toList());
    private static final UnaryOperator<List<Donation>> FILTER_RARITIES = donations -> donations.stream().filter(d -> "rarities".equals(d.getCategory())).collect(Collectors.toList());

    public void cycleFilterMode(List<Donation> items, List<Donation> filteredList) {
        this.currentFilterMode = FilterMode.values()[(this.currentFilterMode.ordinal() + 1) % FilterMode.values().length];
        this.currentFilterMode.applyFilter(items, filteredList);
    }

    public void applyFilter(List<Donation> items, List<Donation> filteredList) {
        this.currentFilterMode.applyFilter(items, filteredList);
    }

    public class_1799 getCurrentFilterItem() {
        return this.currentFilterMode.getAssociatedItem();
    }

    public class_7919 getTooltip() {
        class_5250 tooltip = class_2561.method_43471((String)"skyblocker.museum.hud.filter").method_27693("\n\n").method_27692(class_124.field_1060).method_10852(this.getFilterText(FilterMode.ALL)).method_10852(this.getFilterText(FilterMode.WEAPONS)).method_10852(this.getFilterText(FilterMode.ARMOR)).method_10852(this.getFilterText(FilterMode.RARITIES)).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.filter.switch").method_27692(class_124.field_1054));
        return class_7919.method_47407((class_2561)tooltip);
    }

    private class_2561 getFilterText(FilterMode mode) {
        boolean isCurrent = mode == this.currentFilterMode;
        return class_2561.method_43470((String)(isCurrent ? "\u27a4 " : "  ")).method_10852(mode.getDisplayName()).method_27693("\n").method_27692(isCurrent ? class_124.field_1075 : class_124.field_1080);
    }

    public static enum FilterMode {
        ALL(new class_1799((class_1935)class_1802.field_8137), FILTER_ALL, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.filter.all")),
        WEAPONS(new class_1799((class_1935)class_1802.field_8802), FILTER_WEAPONS, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.filter.weapons")),
        ARMOR(new class_1799((class_1935)class_1802.field_8058), FILTER_ARMOR, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.filter.armor")),
        RARITIES(new class_1799((class_1935)class_1802.field_8687), FILTER_RARITIES, (class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.filter.rarities"));

        private final class_1799 associatedItem;
        private final UnaryOperator<List<Donation>> filterFunction;
        private final class_2561 displayName;

        private FilterMode(class_1799 item, UnaryOperator<List<Donation>> function, class_2561 displayName) {
            this.associatedItem = item;
            this.filterFunction = function;
            this.displayName = displayName;
        }

        public class_1799 getAssociatedItem() {
            return this.associatedItem;
        }

        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public void applyFilter(List<Donation> items, List<Donation> filteredList) {
            filteredList.clear();
            filteredList.addAll((Collection)this.filterFunction.apply(items));
        }
    }
}

