/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import de.hysky.skyblocker.skyblock.item.ItemPrice;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.museum.Donation;
import de.hysky.skyblocker.skyblock.museum.DonationButton;
import de.hysky.skyblocker.skyblock.museum.ItemFilter;
import de.hysky.skyblocker.skyblock.museum.ItemSorter;
import de.hysky.skyblocker.skyblock.museum.MuseumItemCache;
import de.hysky.skyblocker.skyblock.museum.PriceData;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.hoveredItem.HoveredItemStackProvider;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_361;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_513;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class MuseumManager
extends class_339
implements HoveredItemStackProvider {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_327 TEXT_RENDERER = MuseumManager.CLIENT.field_1772;
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60656((String)"textures/gui/recipe_book.png");
    public static final int BACKGROUND_WIDTH = 147;
    public static final int BACKGROUND_HEIGHT = 160;
    public static final int SPACING = 2;
    private static final int BUTTON_SIZE = 20;
    private static final int BUTTONS_PER_PAGE = 12;
    private static final ItemSorter ITEM_SORTER = new ItemSorter();
    private static final ItemFilter ITEM_FILTER = new ItemFilter();
    private static String searchQuery = "";
    private static int currentPage = 0;
    private static List<Donation> donations = new ArrayList<Donation>();
    private final class_361 nextPageButton;
    private final class_361 prevPageButton;
    private final class_342 searchField;
    private final List<Donation> filteredDonations = new ArrayList<Donation>();
    private final List<String> excludedDonationIds = new ArrayList<String>();
    private final List<DonationButton> donationButtons = Lists.newArrayListWithCapacity((int)12);
    private final class_4185 filterButton;
    private final class_4185 sortButton;
    private DonationButton hoveredDonationButton;
    private int pageCount = 0;

    public MuseumManager(class_437 screen, int x, int y, int backgroundWidth) {
        super(x + backgroundWidth + 2, y, 147, 160, (class_2561)class_2561.method_43473());
        this.searchField = new class_342(TEXT_RENDERER, this.method_46426() + 25, this.method_46427() + 11, 69, 20, (class_2561)class_2561.method_43473());
        this.searchField.method_1880(60);
        this.searchField.method_1862(true);
        this.searchField.method_1868(-1);
        this.searchField.method_1852(searchQuery);
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080));
        this.nextPageButton = new class_361(this.method_46426() + 93, this.method_46427() + 133, 12, 17, false);
        this.nextPageButton.method_1962(class_513.field_45552);
        this.prevPageButton = new class_361(this.method_46426() + 38, this.method_46427() + 133, 12, 17, true);
        this.prevPageButton.method_1962(class_513.field_45553);
        donations = MuseumItemCache.getDonations();
        for (int i = 0; i < 12; ++i) {
            DonationButton button2 = new DonationButton(this.method_46426() + 11 + 31 * (i % 4), this.method_46427() + 34 + 31 * (i / 4));
            this.donationButtons.add(button2);
        }
        this.sortButton = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> {
            ITEM_SORTER.cycleSortMode(this.filteredDonations);
            button.method_47400(ITEM_SORTER.getTooltip());
            currentPage = 0;
            this.updateButtons();
        }).method_46436(ITEM_SORTER.getTooltip()).method_46433(this.method_46426() + 95, this.method_46427() + 11).method_46437(20, 20).method_46431();
        this.filterButton = class_4185.method_46430((class_2561)class_2561.method_43473(), button -> {
            ITEM_FILTER.cycleFilterMode(donations, this.filteredDonations);
            ITEM_SORTER.applySort(this.filteredDonations);
            button.method_47400(ITEM_FILTER.getTooltip());
            currentPage = 0;
            this.updateButtons();
        }).method_46436(ITEM_FILTER.getTooltip()).method_46433(this.method_46426() + 116, this.method_46427() + 11).method_46437(20, 20).method_46431();
        ITEM_FILTER.applyFilter(donations, this.filteredDonations);
        ITEM_SORTER.applySort(this.filteredDonations);
        this.updateSearchResults(false);
        Screens.getButtons((class_437)screen).add(this);
        screen.method_25395((class_364)this);
    }

    protected static Donation getDonation(String id) {
        return donations.stream().filter(donation -> donation.getId().equals(id)).findFirst().orElse(null);
    }

    private void updateNavigationButtons() {
        this.prevPageButton.field_22763 = currentPage > 0;
        this.nextPageButton.field_22763 = currentPage < this.pageCount - 1;
    }

    private void updateButtons() {
        List<Donation> visibleDonations = this.filteredDonations.stream().filter(donation -> !this.excludedDonationIds.contains(donation.getId())).toList();
        int buttonsSize = visibleDonations.size();
        this.pageCount = (int)Math.ceil((double)buttonsSize / 12.0);
        for (int i = 0; i < this.donationButtons.size(); ++i) {
            int index = currentPage * this.donationButtons.size() + i;
            if (index < buttonsSize) {
                this.donationButtons.get(i).init(visibleDonations.get(index));
                continue;
            }
            this.donationButtons.get(i).resetButton();
        }
        this.updateNavigationButtons();
    }

    public void updateSearchResults(boolean resetPage) {
        searchQuery = this.searchField.method_1882();
        this.excludedDonationIds.clear();
        for (Donation item : donations) {
            StringBuilder searchableContent = new StringBuilder();
            class_1799 itemStack = ItemRepository.getItemStack(item.getId());
            if (itemStack != null) {
                searchableContent.append(itemStack.method_7964().getString()).append(ItemUtils.getConcatenatedLore(itemStack));
            }
            if (item.getSet() != null && !item.getSet().isEmpty()) {
                for (ObjectObjectMutablePair<String, PriceData> piece : item.getSet()) {
                    class_1799 pieceStack = ItemRepository.getItemStack((String)piece.left());
                    if (pieceStack == null) continue;
                    searchableContent.append(pieceStack.method_7964().getString()).append(ItemUtils.getConcatenatedLore(pieceStack));
                }
            }
            if (searchableContent.toString().toLowerCase(Locale.ENGLISH).contains(searchQuery.toLowerCase(Locale.ENGLISH))) continue;
            this.excludedDonationIds.add(item.getId());
        }
        if (resetPage) {
            currentPage = 0;
        }
        this.updateButtons();
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_1799 stack;
        int iconY;
        int iconX;
        context.method_25290(class_10799.field_56883, BACKGROUND_TEXTURE, this.method_46426(), this.method_46427(), 1.0f, 1.0f, this.method_25368(), this.method_25364(), 256, 246);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        if (this.sortButton.field_22763) {
            iconX = this.sortButton.method_46426() + (this.sortButton.method_25368() - 16) / 2;
            iconY = this.sortButton.method_46427() + (this.sortButton.method_25364() - 16) / 2;
            stack = ITEM_SORTER.getCurrentSortingItem();
            this.sortButton.method_25394(context, mouseX, mouseY, delta);
            context.method_51445(stack, iconX, iconY);
        }
        if (this.filterButton.field_22763) {
            iconX = this.filterButton.method_46426() + (this.filterButton.method_25368() - 16) / 2;
            iconY = this.filterButton.method_46427() + (this.filterButton.method_25364() - 16) / 2;
            stack = ITEM_FILTER.getCurrentFilterItem();
            this.filterButton.method_25394(context, mouseX, mouseY, delta);
            context.method_51445(stack, iconX, iconY);
        }
        if (ItemRepository.filesImported()) {
            if (this.pageCount > 1) {
                class_5250 text = class_2561.method_43469((String)"gui.recipebook.page", (Object[])new Object[]{currentPage + 1, this.pageCount});
                int width = TEXT_RENDERER.method_27525((class_5348)text);
                context.method_51439(TEXT_RENDERER, (class_2561)text, this.method_46426() - width / 2 + 73, this.method_46427() + 137, -1, false);
            }
            this.hoveredDonationButton = null;
            for (DonationButton resultButton : this.donationButtons) {
                resultButton.method_25394(context, mouseX, mouseY, delta);
                if (!resultButton.field_22764 || !resultButton.method_49606()) continue;
                this.hoveredDonationButton = resultButton;
            }
            if (this.prevPageButton.field_22763) {
                this.prevPageButton.method_25394(context, mouseX, mouseY, delta);
            }
            if (this.nextPageButton.field_22763) {
                this.nextPageButton.method_25394(context, mouseX, mouseY, delta);
            }
            this.drawTooltip(context, mouseX, mouseY);
        } else {
            context.method_25300(TEXT_RENDERER, "Loading...", this.method_46426() + 73, this.method_46427() + 80, -1);
        }
    }

    public void drawTooltip(class_332 context, int x, int y) {
        if (this.hoveredDonationButton != null) {
            context.method_64037(TEXT_RENDERER, this.hoveredDonationButton.getItemTooltip(), x, y, null);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.searchField.method_25402(mouseX, mouseY, button)) {
            this.searchField.method_25365(true);
            return true;
        }
        if (this.nextPageButton.method_25402(mouseX, mouseY, button)) {
            ++currentPage;
            this.updateButtons();
            return true;
        }
        if (this.prevPageButton.method_25402(mouseX, mouseY, button)) {
            --currentPage;
            this.updateButtons();
            return true;
        }
        if (this.filterButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (this.sortButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        this.searchField.method_25365(false);
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.searchField.method_25400(chr, modifiers)) {
            this.updateSearchResults(true);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchField.method_20315() && MuseumManager.CLIENT.field_1690.field_1822.method_1417(keyCode, scanCode) || this.searchField.method_25404(keyCode, scanCode, modifiers)) {
            this.updateSearchResults(true);
            return true;
        }
        if (this.hoveredDonationButton != null) {
            class_1799 hoveredStack = this.hoveredDonationButton.getDisplayStack();
            if (hoveredStack == null) {
                return false;
            }
            if (WikiLookupManager.handleWikiLookup((Either<class_1735, class_1799>)Either.right((Object)hoveredStack), (class_1657)MuseumManager.CLIENT.field_1724, keyCode, scanCode)) {
                return true;
            }
            if (ItemPrice.ITEM_PRICE_LOOKUP.method_1417(keyCode, scanCode)) {
                ItemPrice.itemPriceLookup(MuseumManager.CLIENT.field_1724, hoveredStack);
                return true;
            }
        }
        return false;
    }

    protected void method_47399(class_6382 builder) {
    }

    @Override
    @Nullable
    public class_1799 getFocusedItem() {
        if (this.hoveredDonationButton == null) {
            return null;
        }
        return this.hoveredDonationButton.getDisplayStack();
    }
}

