/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders;

import com.google.gson.JsonObject;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.skyblock.profileviewer.inventory.itemLoaders.ItemLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import net.minecraft.class_1799;

public class WardrobeInventoryItemLoader
extends ItemLoader {
    private final int activeSlot;
    private final JsonObject activeArmorSet;

    public WardrobeInventoryItemLoader(JsonObject inventory) {
        this.activeSlot = inventory.get("wardrobe_equipped_slot").getAsInt();
        this.activeArmorSet = inventory.get("inv_armor").getAsJsonObject();
    }

    @Override
    public List<class_1799> loadItems(JsonObject data) {
        ArrayList<class_1799> itemList = new ArrayList<class_1799>();
        try {
            itemList.addAll(super.loadItems(data));
            if (this.activeSlot != -1) {
                SequencedCollection activeArmour = super.loadItems(this.activeArmorSet).reversed();
                for (int i = 0; i < 4; ++i) {
                    int baseIndex = (this.activeSlot - 1) % 9;
                    int page = (this.activeSlot - 1) / 9;
                    int slotIndex = page * 36 + i * 9 + baseIndex;
                    itemList.set(slotIndex, (class_1799)activeArmour.get(i));
                }
            }
        }
        catch (Exception e) {
            ProfileViewerScreen.LOGGER.error("[Skyblocker Profile Viewer] Failed to load wardrobe items", (Throwable)e);
        }
        return itemList;
    }
}

