/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.shortcut;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.shortcut.ShortcutKeyBinding;
import de.hysky.skyblocker.skyblock.shortcut.ShortcutsConfigScreen;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.data.JsonData;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3675;
import net.minecraft.class_7157;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shortcuts {
    private static final Logger LOGGER = LoggerFactory.getLogger(Shortcuts.class);
    private static final Path SHORTCUTS_FILE = SkyblockerMod.CONFIG_DIR.resolve("shortcuts.json");
    public static final JsonData<ShortcutsRecord> shortcuts = new JsonData<ShortcutsRecord>(SHORTCUTS_FILE, ShortcutsRecord.CODEC, Shortcuts.getDefaultShortcuts());
    private static final List<class_3675.class_306> pressedKeys = new ArrayList<class_3675.class_306>();
    private static final long KEY_BINDING_COOLDOWN = 200L;
    private static long lastKeyBindingCommandTime;

    public static boolean isShortcutsLoaded() {
        return shortcuts.isLoaded();
    }

    @Init
    public static void init() {
        shortcuts.init();
        ClientCommandRegistrationCallback.EVENT.register(Shortcuts::registerCommands);
        ClientSendMessageEvents.MODIFY_COMMAND.register(Shortcuts::modifyCommand);
    }

    private static ShortcutsRecord getDefaultShortcuts() {
        Object2ObjectOpenHashMap commands = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap commandArgs = new Object2ObjectOpenHashMap();
        commands.put((Object)"/s", (Object)"/skyblock");
        commands.put((Object)"/i", (Object)"/is");
        commands.put((Object)"/h", (Object)"/hub");
        commands.put((Object)"/ga", (Object)"/warp garden");
        commands.put((Object)"/d", (Object)"/warp dungeon_hub");
        commands.put((Object)"/ca", (Object)"/chat all");
        commands.put((Object)"/cp", (Object)"/chat party");
        commands.put((Object)"/cg", (Object)"/chat guild");
        commands.put((Object)"/co", (Object)"/chat officer");
        commandArgs.put((Object)"/m", (Object)"/msg");
        commandArgs.put((Object)"/pa", (Object)"/p accept");
        commands.put((Object)"/pd", (Object)"/p disband");
        commandArgs.put((Object)"/v", (Object)"/visit");
        commands.put((Object)"/vp", (Object)"/visit portalhub");
        return new ShortcutsRecord((Object2ObjectMap<String, String>)commands, (Object2ObjectMap<String, String>)commandArgs, (Object2ObjectMap<ShortcutKeyBinding, String>)new Object2ObjectOpenHashMap());
    }

    private static ShortcutsRecord getMoreDefaultShortcuts() {
        Object2ObjectOpenHashMap commands = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap commandArgs = new Object2ObjectOpenHashMap();
        commands.put((Object)"/spider", (Object)"/warp spider");
        commands.put((Object)"/crimson", (Object)"/warp nether");
        commands.put((Object)"/end", (Object)"/warp end");
        commands.put((Object)"/gold", (Object)"/warp gold");
        commands.put((Object)"/cavern", (Object)"/warp deep");
        commands.put((Object)"/dwarven", (Object)"/warp mines");
        commands.put((Object)"/fo", (Object)"/warp forge");
        commands.put((Object)"/ch", (Object)"/warp crystals");
        commands.put((Object)"/park", (Object)"/warp park");
        commands.put((Object)"/barn", (Object)"/warp barn");
        commands.put((Object)"/desert", (Object)"/warp desert");
        commands.put((Object)"/ga", (Object)"/warp garden");
        commands.put((Object)"/castle", (Object)"/warp castle");
        commands.put((Object)"/museum", (Object)"/warp museum");
        commands.put((Object)"/da", (Object)"/warp da");
        commands.put((Object)"/crypt", (Object)"/warp crypt");
        commands.put((Object)"/nest", (Object)"/warp nest");
        commands.put((Object)"/magma", (Object)"/warp magma");
        commands.put((Object)"/void", (Object)"/warp void");
        commands.put((Object)"/drag", (Object)"/warp drag");
        commands.put((Object)"/jungle", (Object)"/warp jungle");
        commands.put((Object)"/howl", (Object)"/warp howl");
        return new ShortcutsRecord((Object2ObjectMap<String, String>)commands, (Object2ObjectMap<String, String>)commandArgs, (Object2ObjectMap<ShortcutKeyBinding, String>)new Object2ObjectOpenHashMap());
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"help").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            String status = SkyblockerConfigManager.get().general.shortcuts.enableShortcuts && SkyblockerConfigManager.get().general.shortcuts.enableCommandShortcuts ? "\u00a7a\u00a7l (Enabled)" : "\u00a7c\u00a7l (Disabled)";
            source.sendFeedback(class_2561.method_30163((String)("\u00a7e\u00a7lSkyblocker \u00a7fCommand Shortcuts" + status)));
            if (!Shortcuts.isShortcutsLoaded()) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"skyblocker.shortcuts.notLoaded"));
            } else {
                for (Object command : Shortcuts.shortcuts.getData().commands.entrySet()) {
                    source.sendFeedback(class_2561.method_30163((String)("\u00a77" + (String)command.getKey() + " \u00a7f\u2192 \u00a77" + (String)command.getValue())));
                }
            }
            status = SkyblockerConfigManager.get().general.shortcuts.enableShortcuts && SkyblockerConfigManager.get().general.shortcuts.enableCommandArgShortcuts ? "\u00a7a\u00a7l (Enabled)" : "\u00a7c\u00a7l (Disabled)";
            source.sendFeedback(class_2561.method_30163((String)("\u00a7e\u00a7lSkyblocker \u00a7fCommand Argument Shortcuts" + status)));
            if (!Shortcuts.isShortcutsLoaded()) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"skyblocker.shortcuts.notLoaded"));
            } else {
                for (Map.Entry commandArg : Shortcuts.shortcuts.getData().commandArgs.entrySet()) {
                    source.sendFeedback(class_2561.method_30163((String)("\u00a77" + (String)commandArg.getKey() + " \u00a7f\u2192 \u00a77" + (String)commandArg.getValue())));
                }
            }
            status = SkyblockerConfigManager.get().general.shortcuts.enableShortcuts && SkyblockerConfigManager.get().general.shortcuts.enableKeyBindingShortcuts ? "\u00a7a\u00a7l (Enabled)" : "\u00a7c\u00a7l (Disabled)";
            source.sendFeedback(class_2561.method_30163((String)("\u00a7e\u00a7lSkyblocker \u00a7fKey Binding Shortcuts" + status)));
            if (!Shortcuts.isShortcutsLoaded()) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"skyblocker.shortcuts.notLoaded"));
            } else {
                for (Map.Entry keyBinding : Shortcuts.shortcuts.getData().keyBindings.entrySet()) {
                    source.sendFeedback(class_2561.method_30163((String)("\u00a77" + ((ShortcutKeyBinding)keyBinding.getKey()).getBoundKeysText().getString() + " \u00a7f\u2192 \u00a77" + (String)keyBinding.getValue())));
                }
            }
            source.sendFeedback(class_2561.method_30163((String)"\u00a7e\u00a7lSkyblocker \u00a7fCommands"));
            for (Object command : dispatcher.getSmartUsage(dispatcher.getRoot().getChild("skyblocker"), (Object)source).values()) {
                source.sendFeedback(class_2561.method_30163((String)("\u00a77/skyblocker " + (String)command)));
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"shortcuts").executes(Scheduler.queueOpenScreenCommand(ShortcutsConfigScreen::new))));
        if (!SkyblockerConfigManager.get().general.shortcuts.enableShortcuts) {
            return;
        }
        if (!Shortcuts.isShortcutsLoaded()) {
            LOGGER.warn("[Skyblocker Shortcuts] Shortcuts not loaded yet, skipping command registration");
            return;
        }
        for (String key : Shortcuts.shortcuts.getData().commands.keySet()) {
            if (!key.startsWith("/")) continue;
            dispatcher.register(ClientCommandManager.literal((String)key.substring(1)));
        }
        for (Map.Entry set : Shortcuts.shortcuts.getData().commandArgs.entrySet()) {
            String word;
            if (!((String)set.getKey()).startsWith("/")) continue;
            RootCommandNode redirectLocation = dispatcher.getRoot();
            String[] stringArray = ((String)set.getValue()).substring(1).split(" ");
            int n = stringArray.length;
            for (int i = 0; i < n && (redirectLocation = redirectLocation.getChild(word = stringArray[i])) != null; ++i) {
            }
            if (redirectLocation == null) {
                dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)((String)set.getKey()).substring(1)).then((ArgumentBuilder)ClientCommandManager.argument((String)"args", (ArgumentType)StringArgumentType.greedyString())));
                continue;
            }
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)((String)set.getKey()).substring(1)).redirect((CommandNode)redirectLocation));
        }
    }

    private static String modifyCommand(String command) {
        if (!SkyblockerConfigManager.get().general.shortcuts.enableShortcuts) {
            return command;
        }
        if (!Shortcuts.isShortcutsLoaded()) {
            LOGGER.warn("[Skyblocker Shortcuts] Shortcuts not loaded yet, skipping shortcut for command: {}", command);
            return command;
        }
        command = "/" + (String)command;
        if (SkyblockerConfigManager.get().general.shortcuts.enableCommandShortcuts) {
            command = (String)Shortcuts.shortcuts.getData().commands.getOrDefault(command, command);
        }
        if (SkyblockerConfigManager.get().general.shortcuts.enableCommandArgShortcuts) {
            CharSequence[] messageArgs = ((String)command).split(" ");
            for (int i = 0; i < messageArgs.length; ++i) {
                messageArgs[i] = (String)Shortcuts.shortcuts.getData().commandArgs.getOrDefault((Object)messageArgs[i], (Object)messageArgs[i]);
            }
            command = String.join((CharSequence)" ", messageArgs);
        }
        return ((String)command).substring(1);
    }

    public static void onKeyPressed(class_3675.class_306 key) {
        if (!SkyblockerConfigManager.get().general.shortcuts.enableShortcuts || !SkyblockerConfigManager.get().general.shortcuts.enableKeyBindingShortcuts) {
            return;
        }
        if (!Shortcuts.isShortcutsLoaded()) {
            LOGGER.warn("[Skyblocker Shortcuts] Shortcuts not loaded yet, skipping key binding check for key: {}", (Object)key);
            return;
        }
        String command = (String)Shortcuts.shortcuts.getData().keyBindings.get((Object)new ShortcutKeyBinding(List.of(key)));
        if (command == null) {
            if (pressedKeys.isEmpty() || !pressedKeys.getLast().equals((Object)key)) {
                Shortcuts.setKeyPressed(key, true);
                LOGGER.warn("[Skyblocker Shortcuts] Key {} was not in the pressed keys list when it should be. Check if `setKeyPressed` is always called before `onKeyPressed`.", (Object)key);
            }
            command = (String)Shortcuts.shortcuts.getData().keyBindings.get((Object)new ShortcutKeyBinding(pressedKeys));
        }
        if (command == null || lastKeyBindingCommandTime + 200L > System.currentTimeMillis()) {
            return;
        }
        MessageScheduler.INSTANCE.sendMessageAfterCooldown(command, true);
        lastKeyBindingCommandTime = System.currentTimeMillis();
    }

    public static void setKeyPressed(class_3675.class_306 key, boolean pressed) {
        if (!SkyblockerConfigManager.get().general.shortcuts.enableShortcuts || !SkyblockerConfigManager.get().general.shortcuts.enableKeyBindingShortcuts) {
            return;
        }
        if (pressed) {
            if (pressedKeys.isEmpty() || !pressedKeys.getLast().equals((Object)key)) {
                pressedKeys.add(key);
            }
        } else {
            pressedKeys.remove(key);
        }
    }

    public record ShortcutsRecord(Object2ObjectMap<String, String> commands, Object2ObjectMap<String, String> commandArgs, Object2ObjectMap<ShortcutKeyBinding, String> keyBindings) {
        @VisibleForTesting
        static final Codec<ShortcutsRecord> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.object2ObjectMapCodec(Codec.STRING, Codec.STRING).fieldOf("commands").forGetter(ShortcutsRecord::commands), (App)CodecUtils.object2ObjectMapCodec(Codec.STRING, Codec.STRING).fieldOf("commandArgs").forGetter(ShortcutsRecord::commandArgs), (App)CodecUtils.mutableOptional(CodecUtils.object2ObjectMapCodec(ShortcutKeyBinding.CODEC, Codec.STRING).optionalFieldOf("keyBindings", (Object)Object2ObjectMaps.emptyMap()), Object2ObjectOpenHashMap::new).forGetter(ShortcutsRecord::keyBindings)).apply((Applicative)instance, ShortcutsRecord::new));

        public int size() {
            return this.commands.size() + this.commandArgs.size() + this.keyBindings.size();
        }

        public void clear() {
            this.commands.clear();
            this.commandArgs.clear();
            this.keyBindings.clear();
        }
    }
}

