/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.config.preview;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.mixins.accessors.InGameHudInvoker;
import de.hysky.skyblocker.skyblock.tabhud.config.preview.PreviewTab;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.ScreenBuilder;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.WidgetManager;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.PositionRule;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import net.minecraft.class_8029;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PreviewWidget
extends class_339 {
    private final PreviewTab tab;
    float ratio = 1.0f;
    private float scaledRatio = 1.0f;
    private float scaledScreenWidth;
    private float scaledScreenHeight;
    @Nullable
    private HudWidget hoveredWidget = null;
    @Nullable
    HudWidget selectedWidget = null;
    @Nullable
    private class_8029 selectedOriginalPos = null;
    protected boolean pickParent = false;
    private double bufferedDeltaX = 0.0;
    private double bufferedDeltaY = 0.0;

    public PreviewWidget(PreviewTab tab) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43470((String)"Preview widget"));
        this.tab = tab;
        this.scaledScreenWidth = tab.parent.field_22789;
        this.scaledScreenHeight = tab.parent.field_22790;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.hoveredWidget = null;
        float scale = (float)SkyblockerConfigManager.get().uiAndVisuals.tabHud.tabHudScale / 100.0f;
        this.scaledRatio = this.ratio * scale;
        this.scaledScreenWidth = (float)this.tab.parent.field_22789 / scale;
        this.scaledScreenHeight = (float)this.tab.parent.field_22790 / scale;
        ScreenBuilder screenBuilder = WidgetManager.getScreenBuilder(this.tab.getCurrentLocation());
        context.method_49601(this.method_46426() - 1, this.method_46427() - 1, this.method_25368() + 2, this.method_25364() + 2, -1);
        context.method_44379(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443());
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)this.method_46426(), (float)this.method_46427());
        matrices.scale(this.scaledRatio, this.scaledRatio);
        screenBuilder.renderWidgets(context, this.tab.getCurrentScreenLayer());
        float localMouseX = (float)(mouseX - this.method_46426()) / this.scaledRatio;
        float localMouseY = (float)(mouseY - this.method_46427()) / this.scaledRatio;
        if (this.selectedWidget != null && this.selectedWidget.method_25405(localMouseX, localMouseY)) {
            this.hoveredWidget = this.selectedWidget;
        } else {
            for (HudWidget hudWidget : screenBuilder.getHudWidgets(this.tab.getCurrentScreenLayer())) {
                if (!hudWidget.method_25405(localMouseX, localMouseY)) continue;
                this.hoveredWidget = hudWidget;
                break;
            }
        }
        if (this.hoveredWidget != null && !this.hoveredWidget.equals(this.selectedWidget)) {
            context.method_49601(this.hoveredWidget.method_46426() - 1, this.hoveredWidget.method_46427() - 1, this.hoveredWidget.method_25368() + 2, this.hoveredWidget.method_25364() + 2, -171);
        }
        if (this.selectedWidget != null) {
            context.method_49601(this.selectedWidget.method_46426() - 1, this.selectedWidget.method_46427() - 1, this.selectedWidget.method_25368() + 2, this.selectedWidget.method_25364() + 2, class_124.field_1060.method_532() | 0xFF000000);
            PositionRule rule = screenBuilder.getPositionRule(this.selectedWidget.getInternalID());
            if (rule != null) {
                int deltaX = 0;
                int deltaY = 0;
                if (this.selectedOriginalPos != null) {
                    deltaX = this.selectedWidget.method_46426() - this.selectedOriginalPos.comp_1193();
                    deltaY = this.selectedWidget.method_46427() - this.selectedOriginalPos.comp_1194();
                }
                int thisAnchorX = (int)((float)this.selectedWidget.method_46426() + rule.thisPoint().horizontalPoint().getPercentage() * (float)this.selectedWidget.method_25368());
                int thisAnchorY = (int)((float)this.selectedWidget.method_46427() + rule.thisPoint().verticalPoint().getPercentage() * (float)this.selectedWidget.method_25364());
                int translatedX = Math.min(thisAnchorX - rule.relativeX() - deltaX, (int)this.scaledScreenWidth - 2);
                int translatedY = Math.min(thisAnchorY - rule.relativeY() - deltaY, (int)this.scaledScreenHeight - 2);
                this.renderUnits(context, rule, deltaX, deltaY, thisAnchorX, thisAnchorY, translatedX, translatedY);
                context.method_51738(translatedX, thisAnchorX, thisAnchorY + 1, -1431699456);
                context.method_51742(translatedX + 1, translatedY, thisAnchorY, -1431699456);
                context.method_51738(translatedX, thisAnchorX, thisAnchorY, -65536);
                context.method_51742(translatedX, translatedY, thisAnchorY, -65536);
            }
        }
        matrices.popMatrix();
        matrices.pushMatrix();
        matrices.translate((float)this.method_46426(), (float)this.method_46427());
        matrices.scale(this.ratio, this.ratio);
        ((InGameHudInvoker)class_310.method_1551().field_1705).skyblocker$renderSidebar(context, this.tab.placeHolderObjective);
        matrices.popMatrix();
        context.method_44380();
    }

    private void renderUnits(class_332 context, PositionRule rule, int deltaX, int deltaY, int thisAnchorX, int thisAnchorY, int translatedX, int translatedY) {
        boolean yUnitOnRight;
        boolean xUnitOnTop;
        boolean bl = xUnitOnTop = rule.relativeY() > 0;
        if (xUnitOnTop && thisAnchorY < 10) {
            xUnitOnTop = false;
        }
        if (!xUnitOnTop && (float)thisAnchorY > this.scaledScreenHeight - 10.0f) {
            xUnitOnTop = true;
        }
        int xUnit = rule.relativeX() + deltaX;
        int yUnit = rule.relativeY() + deltaY;
        String xUnitText = String.valueOf(xUnit);
        String yUnitText = String.valueOf(yUnit);
        int yUnitTextWidth = this.tab.client.field_1772.method_1727(yUnitText);
        boolean bl2 = yUnitOnRight = rule.relativeX() > 0;
        if (yUnitOnRight && (float)(translatedX + 2 + yUnitTextWidth) >= this.scaledScreenWidth) {
            yUnitOnRight = false;
        }
        if (!yUnitOnRight && translatedX - 2 - yUnitTextWidth <= 0) {
            yUnitOnRight = true;
        }
        if (Math.abs(xUnit) < 15 || Math.abs(yUnit) < 15) {
            String text = "x: " + xUnitText + " y: " + yUnitText;
            int textX = (float)thisAnchorX < this.scaledScreenWidth / 2.0f ? (int)(this.scaledScreenWidth - (float)this.tab.client.field_1772.method_1727(text) - 5.0f) : 5;
            context.method_25303(this.tab.client.field_1772, text, textX, 2, -65536);
        }
        context.method_25300(this.tab.client.field_1772, xUnitText, thisAnchorX - xUnit / 2, xUnitOnTop ? thisAnchorY - 9 : thisAnchorY + 2, -2142128);
        context.method_51433(this.tab.client.field_1772, yUnitText, yUnitOnRight ? translatedX + 2 : translatedX - 1 - yUnitTextWidth, thisAnchorY - (yUnit - 9) / 2, -2142128, true);
    }

    protected void method_47399(class_6382 builder) {
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        double localDeltaX = deltaX / (double)this.scaledRatio + this.bufferedDeltaX;
        double localDeltaY = deltaY / (double)this.scaledRatio + this.bufferedDeltaY;
        this.bufferedDeltaX = localDeltaX - (double)((int)localDeltaX);
        this.bufferedDeltaY = localDeltaY - (double)((int)localDeltaY);
        if (this.selectedWidget != null && this.selectedOriginalPos != null) {
            this.selectedWidget.method_46421(this.selectedWidget.method_46426() + (int)localDeltaX);
            this.selectedWidget.method_46419(this.selectedWidget.method_46427() + (int)localDeltaY);
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        if (this.pickParent) {
            this.pickParent = false;
            return;
        }
        if (!Objects.equals(this.hoveredWidget, this.selectedWidget)) {
            this.tab.onHudWidgetSelected(this.hoveredWidget);
        }
        if (this.selectedWidget != null && this.selectedOriginalPos != null) {
            ScreenBuilder screenBuilder = WidgetManager.getScreenBuilder(this.tab.getCurrentLocation());
            PositionRule oldRule = screenBuilder.getPositionRule(this.selectedWidget.getInternalID());
            if (oldRule == null) {
                oldRule = PositionRule.DEFAULT;
            }
            int relativeX = this.selectedWidget.method_46426() - this.selectedOriginalPos.comp_1193();
            int relativeY = this.selectedWidget.method_46427() - this.selectedOriginalPos.comp_1194();
            screenBuilder.setPositionRule(this.selectedWidget.getInternalID(), new PositionRule(oldRule.parent(), oldRule.parentPoint(), oldRule.thisPoint(), oldRule.relativeX() + relativeX, oldRule.relativeY() + relativeY, oldRule.screenLayer()));
            this.tab.updateWidgets();
        }
        this.selectedWidget = this.hoveredWidget;
        this.selectedOriginalPos = null;
        super.method_25357(mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!(this.field_22763 && this.field_22764 && this.method_25405(mouseX, mouseY))) {
            return false;
        }
        double localMouseX = (mouseX - (double)this.method_46426()) / (double)this.scaledRatio;
        double localMouseY = (mouseY - (double)this.method_46427()) / (double)this.scaledRatio;
        if (button == 1) {
            ArrayList<HudWidget> hoveredThingies = new ArrayList<HudWidget>();
            for (HudWidget hudWidget : WidgetManager.getScreenBuilder(this.tab.getCurrentLocation()).getHudWidgets(this.tab.getCurrentScreenLayer())) {
                if (!hudWidget.method_25405(localMouseX, localMouseY)) continue;
                hoveredThingies.add(hudWidget);
            }
            if (hoveredThingies.size() == 1) {
                this.selectedWidget = (HudWidget)hoveredThingies.getFirst();
            } else if (!hoveredThingies.isEmpty()) {
                for (int i = 0; i < hoveredThingies.size(); ++i) {
                    if (!((HudWidget)hoveredThingies.get(i)).equals(this.hoveredWidget)) continue;
                    this.selectedWidget = (HudWidget)hoveredThingies.get((i + 1) % hoveredThingies.size());
                }
            }
            return true;
        }
        ScreenBuilder screenBuilder = WidgetManager.getScreenBuilder(this.tab.getCurrentLocation());
        if (this.pickParent && this.selectedWidget != null) {
            if (this.selectedWidget.equals(this.hoveredWidget)) {
                this.tab.onHudWidgetSelected(this.selectedWidget);
                return true;
            }
            PositionRule oldRule = screenBuilder.getPositionRule(this.selectedWidget.getInternalID());
            if (oldRule == null) {
                oldRule = PositionRule.DEFAULT;
            }
            int thisAnchorX = (int)((float)this.selectedWidget.method_46426() + oldRule.thisPoint().horizontalPoint().getPercentage() * (float)this.selectedWidget.method_25368());
            int thisAnchorY = (int)((float)this.selectedWidget.method_46427() + oldRule.thisPoint().verticalPoint().getPercentage() * (float)this.selectedWidget.method_25364());
            int otherAnchorX = this.hoveredWidget == null ? 0 : this.hoveredWidget.method_46426();
            int otherAnchorY = this.hoveredWidget == null ? 0 : this.hoveredWidget.method_46427();
            PositionRule newRule = new PositionRule(this.hoveredWidget == null ? "screen" : this.hoveredWidget.getInternalID(), PositionRule.Point.DEFAULT, oldRule.thisPoint(), thisAnchorX - otherAnchorX, thisAnchorY - otherAnchorY, oldRule.screenLayer());
            screenBuilder.setPositionRule(this.selectedWidget.getInternalID(), newRule);
            this.tab.updateWidgets();
            this.tab.onHudWidgetSelected(this.selectedWidget);
            return true;
        }
        if (this.selectedWidget != null && this.selectedWidget.method_25405(localMouseX, localMouseY) && screenBuilder.getPositionRule(this.selectedWidget.getInternalID()) != null) {
            this.selectedOriginalPos = new class_8029(this.selectedWidget.method_46426(), this.selectedWidget.method_46427());
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.hoveredWidget != null && this.hoveredWidget.equals(this.selectedWidget)) {
            int multiplier = (modifiers & 2) != 0 ? 5 : 1;
            int x = 0;
            int y = 0;
            switch (keyCode) {
                case 265: {
                    y = -multiplier;
                    break;
                }
                case 264: {
                    y = multiplier;
                    break;
                }
                case 263: {
                    x = -multiplier;
                    break;
                }
                case 262: {
                    x = multiplier;
                }
            }
            ScreenBuilder screenBuilder = WidgetManager.getScreenBuilder(this.tab.getCurrentLocation());
            PositionRule oldRule = screenBuilder.getPositionRuleOrDefault(this.selectedWidget.getInternalID());
            screenBuilder.setPositionRule(this.selectedWidget.getInternalID(), new PositionRule(oldRule.parent(), oldRule.parentPoint(), oldRule.thisPoint(), oldRule.relativeX() + x, oldRule.relativeY() + y, oldRule.screenLayer()));
            this.tab.updateWidgets();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }
}

