/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.screenbuilder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.ItemPickupWidget;
import de.hysky.skyblocker.skyblock.dungeon.DungeonSplitsWidget;
import de.hysky.skyblocker.skyblock.dwarven.CrystalsHudWidget;
import de.hysky.skyblocker.skyblock.dwarven.profittrackers.PowderMiningWidget;
import de.hysky.skyblocker.skyblock.end.EndHudWidget;
import de.hysky.skyblocker.skyblock.fishing.FishingHudWidget;
import de.hysky.skyblocker.skyblock.galatea.SweepDetailsHudWidget;
import de.hysky.skyblocker.skyblock.galatea.TreeBreakProgressHud;
import de.hysky.skyblocker.skyblock.garden.FarmingHudWidget;
import de.hysky.skyblocker.skyblock.hunting.LassoHud;
import de.hysky.skyblocker.skyblock.slayers.hud.SlayerHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.TabHud;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.ScreenBuilder;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.pipeline.PositionRule;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.tabhud.widget.CommsWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComposterWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonBuffWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonDeathWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonDownedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonPlayerWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonPuzzleWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonSecretWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.DungeonServerWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.EffectWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.ElectionWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.EssenceWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.EventWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.FireSaleWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.ForgeWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.HudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.JacobsContestWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.MinionWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.PetWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.PlayerListWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.PowderWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.ProfileWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.ServerWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.SkillsWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.VisitorsWidget;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3542;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;

public class WidgetManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 FANCY_TAB_HUD = SkyblockerMod.id("fancy_tab_hud");
    private static final class_2960 FANCY_TAB = SkyblockerMod.id("fancy_tab");
    private static final int VERSION = 2;
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("hud_widgets.json");
    private static final Map<Location, ScreenBuilder> BUILDER_MAP = new EnumMap(Arrays.stream(Location.values()).collect(Collectors.toMap(Function.identity(), ScreenBuilder::new)));
    public static final Map<String, HudWidget> widgetInstances = new HashMap<String, HudWidget>();

    public static ScreenBuilder getScreenBuilder(Location location) {
        return BUILDER_MAP.get((Object)location);
    }

    @Init(priority=-1)
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            WidgetManager.instantiateWidgets();
            for (int i = 1; i < 6; ++i) {
                DungeonPlayerWidget widget = new DungeonPlayerWidget(i);
                WidgetManager.addWidgetInstance(widget);
            }
            WidgetManager.loadConfig();
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> WidgetManager.saveConfig());
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.DEMO_TIMER, (class_2960)FANCY_TAB_HUD, (context, tickCounter) -> WidgetManager.render(context, true));
        HudElementRegistry.attachElementBefore((class_2960)VanillaHudElements.PLAYER_LIST, (class_2960)FANCY_TAB, (context, tickCounter) -> WidgetManager.render(context, false));
    }

    private static void render(class_332 context, boolean hud) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1755 instanceof WidgetsConfigurationScreen) {
            return;
        }
        class_1041 window = client.method_22683();
        float scale = (float)SkyblockerConfigManager.get().uiAndVisuals.tabHud.tabHudScale / 100.0f;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.scale(scale, scale);
        WidgetManager.render(context, (int)((float)window.method_4486() / scale), (int)((float)window.method_4502() / scale), hud);
        matrices.popMatrix();
    }

    private static void render(class_332 context, int w, int h, boolean hud) {
        class_310 client = class_310.method_1551();
        ScreenBuilder screenBuilder = WidgetManager.getScreenBuilder(Utils.getLocation());
        if (client.field_1690.field_1907.method_1434()) {
            if (hud || TabHud.shouldRenderVanilla()) {
                return;
            }
            if (TabHud.toggleSecondary.method_1434()) {
                screenBuilder.run(context, w, h, ScreenLayer.SECONDARY_TAB);
            } else {
                screenBuilder.run(context, w, h, ScreenLayer.MAIN_TAB);
            }
        } else if (hud) {
            screenBuilder.run(context, w, h, ScreenLayer.HUD);
        }
    }

    public static void loadConfig() {
        try (BufferedReader reader = Files.newBufferedReader(FILE);){
            JsonObject object = (JsonObject)SkyblockerMod.GSON.fromJson((Reader)reader, JsonObject.class);
            JsonObject positions = object.getAsJsonObject("positions");
            for (Map.Entry<Location, ScreenBuilder> builderEntry : BUILDER_MAP.entrySet()) {
                Location location = builderEntry.getKey();
                ScreenBuilder screenBuilder = builderEntry.getValue();
                if (!positions.has(location.id())) continue;
                JsonObject locationObject = positions.getAsJsonObject(location.id());
                for (Map.Entry entry : locationObject.entrySet()) {
                    PositionRule.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).ifSuccess(pair -> screenBuilder.setPositionRule((String)entry.getKey(), (PositionRule)pair.getFirst())).ifError(pairError -> LOGGER.error("[Skyblocker] Failed to parse position rule: {}", pairError.messageSupplier().get()));
                }
            }
        }
        catch (NoSuchFileException e) {
            LOGGER.warn("[Skyblocker] No hud widget config file found, using defaults");
            WidgetManager.fillDefaultConfig();
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to load hud widgets config", (Throwable)e);
        }
    }

    public static void saveConfig() {
        JsonObject output = new JsonObject();
        JsonObject positions = new JsonObject();
        for (Map.Entry<Location, ScreenBuilder> builderEntry : BUILDER_MAP.entrySet()) {
            Location location = builderEntry.getKey();
            ScreenBuilder screenBuilder = builderEntry.getValue();
            JsonObject locationObject = new JsonObject();
            screenBuilder.forEachPositionRuleEntry((s, positionRule) -> locationObject.add(s, (JsonElement)PositionRule.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, positionRule).getOrThrow()));
            if (locationObject.isEmpty()) continue;
            positions.add(location.id(), (JsonElement)locationObject);
        }
        output.add("positions", (JsonElement)positions);
        try (BufferedWriter writer = Files.newBufferedWriter(FILE, new OpenOption[0]);){
            SkyblockerMod.GSON.toJson((JsonElement)output, (Appendable)writer);
            LOGGER.info("[Skyblocker] Saved hud widget config");
        }
        catch (IOException e) {
            LOGGER.error("[Skyblocker] Failed to save hud widget config", (Throwable)e);
        }
    }

    private static void fillDefaultConfig() {
        ScreenBuilder screenBuilder = WidgetManager.getScreenBuilder(Location.THE_END);
        screenBuilder.setPositionRule("hud_end", new PositionRule("screen", PositionRule.Point.DEFAULT, PositionRule.Point.DEFAULT, SkyblockerConfigManager.get().otherLocations.end.x, SkyblockerConfigManager.get().otherLocations.end.y, ScreenLayer.HUD));
        screenBuilder = WidgetManager.getScreenBuilder(Location.GARDEN);
        screenBuilder.setPositionRule("hud_farming", new PositionRule("screen", PositionRule.Point.DEFAULT, PositionRule.Point.DEFAULT, SkyblockerConfigManager.get().farming.garden.farmingHud.x, SkyblockerConfigManager.get().farming.garden.farmingHud.y, ScreenLayer.HUD));
        for (Location loc : new Location[]{Location.CRYSTAL_HOLLOWS, Location.DWARVEN_MINES}) {
            screenBuilder = WidgetManager.getScreenBuilder(loc);
            screenBuilder.setPositionRule("commissions", new PositionRule("screen", PositionRule.Point.DEFAULT, PositionRule.Point.DEFAULT, 5, 5, ScreenLayer.HUD));
            screenBuilder.setPositionRule("powders", new PositionRule("commissions", new PositionRule.Point(PositionRule.VerticalPoint.BOTTOM, PositionRule.HorizontalPoint.LEFT), PositionRule.Point.DEFAULT, 0, 2, ScreenLayer.HUD));
        }
        screenBuilder = WidgetManager.getScreenBuilder(Location.DUNGEON);
        screenBuilder.setPositionRule("Dungeon Splits", new PositionRule("screen", new PositionRule.Point(PositionRule.VerticalPoint.CENTER, PositionRule.HorizontalPoint.LEFT), new PositionRule.Point(PositionRule.VerticalPoint.CENTER, PositionRule.HorizontalPoint.LEFT), 5, 0, ScreenLayer.HUD));
    }

    private static void instantiateWidgets() {
        WidgetManager.addWidgetInstance(new PowderWidget());
        WidgetManager.addWidgetInstance(new CommsWidget());
        WidgetManager.addWidgetInstance(new VisitorsWidget());
        WidgetManager.addWidgetInstance(new EffectWidget());
        WidgetManager.addWidgetInstance(new DungeonBuffWidget());
        WidgetManager.addWidgetInstance(new FireSaleWidget());
        WidgetManager.addWidgetInstance(new FishingHudWidget());
        WidgetManager.addWidgetInstance(new DungeonDeathWidget());
        WidgetManager.addWidgetInstance(new JacobsContestWidget());
        WidgetManager.addWidgetInstance(new EssenceWidget());
        WidgetManager.addWidgetInstance(new ForgeWidget());
        WidgetManager.addWidgetInstance(new TreeBreakProgressHud());
        WidgetManager.addWidgetInstance(new PetWidget());
        WidgetManager.addWidgetInstance(new LassoHud());
        WidgetManager.addWidgetInstance(new ProfileWidget());
        WidgetManager.addWidgetInstance(new MinionWidget());
        WidgetManager.addWidgetInstance(new FarmingHudWidget());
        WidgetManager.addWidgetInstance(new DungeonPuzzleWidget());
        WidgetManager.addWidgetInstance(new EndHudWidget());
        WidgetManager.addWidgetInstance(new PlayerListWidget());
        WidgetManager.addWidgetInstance(new SlayerHudWidget());
        WidgetManager.addWidgetInstance(new SweepDetailsHudWidget());
        WidgetManager.addWidgetInstance(new CrystalsHudWidget());
        WidgetManager.addWidgetInstance(new DungeonSplitsWidget());
        WidgetManager.addWidgetInstance(new EventWidget());
        WidgetManager.addWidgetInstance(new SkillsWidget());
        WidgetManager.addWidgetInstance(new DungeonServerWidget());
        WidgetManager.addWidgetInstance(new DungeonDownedWidget());
        WidgetManager.addWidgetInstance(new ElectionWidget());
        WidgetManager.addWidgetInstance(new DungeonSecretWidget());
        WidgetManager.addWidgetInstance(new ServerWidget());
        WidgetManager.addWidgetInstance(new PowderMiningWidget());
        WidgetManager.addWidgetInstance(new ItemPickupWidget());
        WidgetManager.addWidgetInstance(new ComposterWidget());
    }

    public static void addWidgetInstance(HudWidget widget) {
        HudWidget put = widgetInstances.put(widget.getInternalID(), widget);
        if (widget instanceof TabHudWidget) {
            TabHudWidget tabHudWidget = (TabHudWidget)widget;
            PlayerListManager.tabWidgetInstances.put(tabHudWidget.getHypixelWidgetName(), tabHudWidget);
        }
        if (put != null) {
            LOGGER.warn("[Skyblocker] Duplicate hud widget found: {}", (Object)widget);
        }
    }

    public static enum ScreenLayer implements class_3542
    {
        MAIN_TAB,
        SECONDARY_TAB,
        HUD,
        DEFAULT;

        public static final Codec<ScreenLayer> CODEC;

        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Main Tab";
                case 1 -> "Secondary Tab";
                case 2 -> "HUD";
                case 3 -> "Default";
            };
        }

        public String method_15434() {
            return this.name();
        }

        static {
            CODEC = class_3542.method_28140(ScreenLayer::values);
        }
    }
}

