/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.hysky.skyblocker.skyblock.waypoint.WaypointsListWidget;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.gui.DropdownWidget;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.WaypointGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7852;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8666;
import net.minecraft.class_9017;
import net.minecraft.class_9848;

public abstract class AbstractWaypointsScreen<T extends class_437>
extends class_437 {
    protected final T parent;
    protected final Multimap<Location, WaypointGroup> waypoints;
    protected Location island;
    protected WaypointsListWidget waypointsListWidget;
    protected DropdownWidget<Location> islandWidget;
    protected final class_8132 layout = new class_8132((class_437)this);
    private final PopupContainer popupContainer = new PopupContainer();

    public AbstractWaypointsScreen(class_2561 title, T parent) {
        this(title, parent, (Multimap<Location, WaypointGroup>)MultimapBuilder.enumKeys(Location.class).arrayListValues().build());
    }

    public AbstractWaypointsScreen(class_2561 title, T parent, Multimap<Location, WaypointGroup> waypoints) {
        this(title, parent, waypoints, Utils.getLocation());
    }

    public AbstractWaypointsScreen(class_2561 title, T parent, Multimap<Location, WaypointGroup> waypoints, Location island) {
        super(title);
        this.parent = parent;
        this.waypoints = waypoints;
        this.island = island;
        this.layout.method_48995(32);
    }

    protected void method_25426() {
        super.method_25426();
        this.layout.method_48992((class_8021)new class_7842(this.field_22785, this.field_22793));
        this.method_25429((class_364)this.popupContainer);
        this.waypointsListWidget = (WaypointsListWidget)this.method_37063((class_364)new WaypointsListWidget(this.field_22787, this, this.field_22789, this.field_22790 - 120, 32, 24));
    }

    protected final void lateInit() {
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.islandWidget = (DropdownWidget)this.method_37063((class_364)new DropdownWidget<Location>(this.field_22787, this.field_22789 - 160, 8, 150, this.field_22790 - 8, Arrays.asList(Location.values()), this::islandChanged, this.island, isOpen -> {}));
        this.method_37060((class_4068)this.popupContainer);
        this.method_48640();
    }

    protected void setPopup(class_8021 w, int x, int y) {
        if (w == null) {
            this.popupContainer.field_22764 = false;
        } else {
            this.popupContainer.field_22764 = true;
            this.popupContainer.setWidget(w);
            this.popupContainer.method_48229(Math.clamp((long)x, 0, this.field_22789 - this.popupContainer.method_25368()), Math.clamp((long)y, 0, this.field_22790 - this.popupContainer.method_25364()));
        }
    }

    protected void method_48640() {
        this.layout.method_48222();
        this.waypointsListWidget.method_57712(this.field_22789, this.layout);
        this.waypointsListWidget.updateEntries();
        this.islandWidget.method_46421(this.field_22789 - this.islandWidget.method_25368() - 10);
        class_7843.method_46440((int)0, (int)this.layout.method_48998(), (int)19, this.islandWidget::method_46419, (float)0.5f);
        this.islandWidget.setMaxHeight(Math.max(this.field_22790 - this.islandWidget.method_46427() - 8, 20));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.islandWidget.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        boolean mouseClicked = super.method_25402(mouseX, mouseY, button);
        this.updateButtons();
        return mouseClicked;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.islandWidget.method_25405(mouseX, mouseY) && this.islandWidget.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void islandChanged(Location location) {
        this.island = location;
        this.waypointsListWidget.setIsland(this.island);
    }

    protected boolean isEnabled(NamedWaypoint waypoint) {
        return waypoint.isEnabled();
    }

    protected void enabledChanged(NamedWaypoint waypoint, boolean enabled) {
        waypoint.setEnabled(enabled);
    }

    protected void updateButtons() {
        this.waypointsListWidget.updateButtons();
    }

    private static class PopupContainer
    extends class_9017 {
        private static final int BORDER_SIZE = 4;
        private class_8021 widget = class_7852.method_46512((int)0);
        private final List<class_339> children = new ArrayList<class_339>(4);
        private final class_4264 closeButton = new class_344(14, 14, new class_8666(class_2960.method_60656((String)"widget/cross_button"), class_2960.method_60656((String)"widget/cross_button_highlighted")), b -> {
            this.field_22764 = false;
        }, (class_2561)class_2561.method_43473());

        PopupContainer() {
            super(0, 0, 0, 0, (class_2561)class_2561.method_43473());
        }

        public int method_25368() {
            return this.widget.method_25368() + 8;
        }

        public int method_25364() {
            return this.widget.method_25364() + 8 + this.closeButton.method_25364() + 2;
        }

        public void method_46421(int x) {
            super.method_46421(x);
            this.closeButton.method_46421(this.method_55442() - 4 - this.closeButton.method_25368());
            this.widget.method_46421(this.method_46426() + 4);
        }

        public void method_46419(int y) {
            super.method_46419(y);
            this.closeButton.method_46419(this.method_46427() + 4);
            this.widget.method_46419(this.closeButton.method_55443() + 2);
        }

        public List<? extends class_364> method_25396() {
            return this.field_22764 ? this.children : List.of();
        }

        public void setWidget(class_8021 widget) {
            this.widget = widget;
            this.children.clear();
            this.children.add((class_339)this.closeButton);
            widget.method_48206(this.children::add);
            this.closeButton.method_46421(this.method_55442() - 4 - this.closeButton.method_25368());
        }

        protected int method_44395() {
            return 0;
        }

        protected double method_44393() {
            return 0.0;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), class_9848.method_71346((float)0.6f, (int)0));
            context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -1);
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, deltaTicks);
            }
            if (!(this.method_25370() || mouseX > this.method_46426() - 50 && mouseX < this.method_55442() + 50 && mouseY > this.method_46427() - 50 && mouseY < this.method_55443() + 50)) {
                this.field_22764 = false;
            }
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

