/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientBlockPosArgumentType;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientPosArgument;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MythologicalRitual {
    private static final Pattern GRIFFIN_BURROW_DUG = Pattern.compile("(?<message>You dug out a Griffin Burrow!|You finished the Griffin burrow chain!) \\((?<index>\\d+)/(?<length>\\d+)\\)");
    private static final float[] ORANGE_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7946);
    private static final float[] RED_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7964);
    private static final Set<String> SPADES = Set.of("ANCESTRAL_SPADE", "ARCHAIC_SPADE", "DEIFIC_SPADE");
    private static long lastEchoTime;
    private static final Map<class_2338, GriffinBurrow> griffinBurrows;
    @Nullable
    private static class_2338 lastDugBurrowPos;
    private static GriffinBurrow previousBurrow;

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(MythologicalRitual::extractRendering);
        AttackBlockCallback.EVENT.register(MythologicalRitual::onAttackBlock);
        UseBlockCallback.EVENT.register(MythologicalRitual::onUseBlock);
        UseItemCallback.EVENT.register(MythologicalRitual::onUseItem);
        ClientReceiveMessageEvents.ALLOW_GAME.register(MythologicalRitual::onChatMessage);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> MythologicalRitual.reset());
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"diana").then(ClientCommandManager.literal((String)"clearGriffinBurrows").executes(context -> {
            MythologicalRitual.reset();
            return 1;
        }))).then(ClientCommandManager.literal((String)"clearGriffinBurrow").then(ClientCommandManager.argument((String)"position", (ArgumentType)ClientBlockPosArgumentType.blockPos()).executes(context -> {
            griffinBurrows.remove(((ClientPosArgument)context.getArgument("position", ClientPosArgument.class)).toAbsoluteBlockPos((FabricClientCommandSource)context.getSource()));
            return 1;
        }))))));
        ParticleEvents.FROM_SERVER.register(MythologicalRitual::onParticle);
        MythologicalRitual.previousBurrow.confirmed = TriState.DEFAULT;
        griffinBurrows.put(class_2338.field_10980, previousBurrow);
    }

    private static void onParticle(class_2675 packet) {
        if (MythologicalRitual.isActive()) {
            class_2396 class_23962 = packet.method_11551().method_10295();
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2396.class, class_2396.class, class_2396.class}, (Object)class_23962, n)) {
                    case 0: {
                        class_2396 type = class_23962;
                        if (!class_2398.field_11205.equals(type) && !class_2398.field_11215.equals(type)) {
                            n = 1;
                            continue block5;
                        }
                        MythologicalRitual.handleBurrowParticle(packet);
                        break block5;
                    }
                    case 1: {
                        class_2396 type = class_23962;
                        if (!class_2398.field_11212.equals(type)) {
                            n = 2;
                            continue block5;
                        }
                        MythologicalRitual.handleNextBurrowParticle(packet);
                        break block5;
                    }
                    case 2: {
                        class_2396 type = class_23962;
                        if (!class_2398.field_11223.equals(type) || packet.method_11545() != 2) {
                            n = 3;
                            continue block5;
                        }
                        MythologicalRitual.handleEchoBurrowParticle(packet);
                        break block5;
                    }
                }
                break;
            }
        }
    }

    private static void handleBurrowParticle(class_2675 packet) {
        class_2338 pos = class_2338.method_49637((double)packet.method_11544(), (double)packet.method_11547(), (double)packet.method_11546()).method_10074();
        if (class_310.method_1551().field_1687 == null || !class_310.method_1551().field_1687.method_8320(pos).method_27852(class_2246.field_10219)) {
            return;
        }
        GriffinBurrow burrow = griffinBurrows.computeIfAbsent(pos, GriffinBurrow::new);
        if (class_2398.field_11205.equals(packet.method_11551().method_10295())) {
            ++burrow.critParticle;
        }
        if (class_2398.field_11215.equals(packet.method_11551().method_10295())) {
            ++burrow.enchantParticle;
        }
        if (burrow.critParticle >= 5 && burrow.enchantParticle >= 5 && burrow.confirmed == TriState.FALSE) {
            griffinBurrows.get(pos).init();
        }
    }

    private static void handleNextBurrowParticle(class_2675 packet) {
        class_2338 pos = class_2338.method_49637((double)packet.method_11544(), (double)packet.method_11547(), (double)packet.method_11546());
        GriffinBurrow burrow = griffinBurrows.get(pos.method_10087(2));
        if (burrow == null) {
            return;
        }
        burrow.regression.addData(packet.method_11544(), packet.method_11546());
        double slope = burrow.regression.getSlope();
        if (Double.isNaN(slope)) {
            return;
        }
        class_243 nextBurrowDirection = new class_243(100.0, 0.0, slope * 100.0).method_1029();
        Vector2D pos2D = new Vector2D((double)pos.method_10263() + 0.5, (double)pos.method_10260() + 0.5);
        burrow.nextBurrowLineEstimation = new Line(pos2D, pos2D.add((Vector)new Vector2D(nextBurrowDirection.field_1352, nextBurrowDirection.field_1350)), 1.0E-4);
        MythologicalRitual.estimateNextBurrow(burrow);
        if (burrow.nextBurrowLine == null) {
            burrow.nextBurrowLine = new class_243[1001];
        }
        MythologicalRitual.fillLine(burrow.nextBurrowLine, class_243.method_24953((class_2382)pos.method_10084()), nextBurrowDirection);
    }

    private static void handleEchoBurrowParticle(class_2675 packet) {
        if (System.currentTimeMillis() > lastEchoTime + 10000L) {
            return;
        }
        if (MythologicalRitual.previousBurrow.echoBurrowDirection == null) {
            MythologicalRitual.previousBurrow.echoBurrowDirection = new class_243[2];
        }
        MythologicalRitual.previousBurrow.echoBurrowDirection[0] = MythologicalRitual.previousBurrow.echoBurrowDirection[1];
        MythologicalRitual.previousBurrow.echoBurrowDirection[1] = new class_243(packet.method_11544(), packet.method_11547(), packet.method_11546());
        if (MythologicalRitual.previousBurrow.echoBurrowDirection[0] == null || MythologicalRitual.previousBurrow.echoBurrowDirection[1] == null) {
            return;
        }
        Vector2D pos1 = new Vector2D(MythologicalRitual.previousBurrow.echoBurrowDirection[0].field_1352, MythologicalRitual.previousBurrow.echoBurrowDirection[0].field_1350);
        Vector2D pos2 = new Vector2D(MythologicalRitual.previousBurrow.echoBurrowDirection[1].field_1352, MythologicalRitual.previousBurrow.echoBurrowDirection[1].field_1350);
        MythologicalRitual.previousBurrow.echoBurrowLineEstimation = new Line(pos1, pos2, 1.0E-4);
        MythologicalRitual.estimateNextBurrow(previousBurrow);
        class_243 echoBurrowDirection = MythologicalRitual.previousBurrow.echoBurrowDirection[1].method_1020(MythologicalRitual.previousBurrow.echoBurrowDirection[0]).method_1029();
        if (MythologicalRitual.previousBurrow.echoBurrowLine == null) {
            MythologicalRitual.previousBurrow.echoBurrowLine = new class_243[1001];
        }
        MythologicalRitual.fillLine(MythologicalRitual.previousBurrow.echoBurrowLine, MythologicalRitual.previousBurrow.echoBurrowDirection[0], echoBurrowDirection);
    }

    private static void estimateNextBurrow(GriffinBurrow burrow) {
        if (burrow.nextBurrowLineEstimation == null || burrow.echoBurrowLineEstimation == null) {
            return;
        }
        Vector2D intersection = burrow.nextBurrowLineEstimation.intersection(burrow.echoBurrowLineEstimation);
        if (intersection == null) {
            return;
        }
        burrow.nextBurrowEstimatedPos = class_2338.method_49637((double)intersection.getX(), (double)5.0, (double)intersection.getY());
    }

    static void fillLine(class_243[] line, class_243 start, class_243 direction) {
        assert (line.length % 2 == 1);
        int middle = line.length / 2;
        line[middle] = start;
        for (int i = 0; i < middle; ++i) {
            line[middle + 1 + i] = line[middle + i].method_1019(direction);
            line[middle - 1 - i] = line[middle - i].method_1020(direction);
        }
    }

    public static void extractRendering(PrimitiveCollector collector) {
        if (MythologicalRitual.isActive()) {
            for (GriffinBurrow burrow : griffinBurrows.values()) {
                if (burrow.shouldRender()) {
                    burrow.extractRendering(collector);
                }
                if (burrow.confirmed == TriState.FALSE) continue;
                if (burrow.nextBurrowLine != null) {
                    collector.submitLinesFromPoints(burrow.nextBurrowLine, ORANGE_COLOR_COMPONENTS, 0.5f, 5.0f, false);
                }
                if (burrow.echoBurrowLine != null) {
                    collector.submitLinesFromPoints(burrow.echoBurrowLine, ORANGE_COLOR_COMPONENTS, 0.5f, 5.0f, false);
                }
                if (burrow.nextBurrowEstimatedPos == null || burrow.confirmed != TriState.DEFAULT) continue;
                collector.submitFilledBoxWithBeaconBeam(burrow.nextBurrowEstimatedPos, RED_COLOR_COMPONENTS, 0.5f, true);
            }
        }
    }

    public static class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        return MythologicalRitual.onInteractBlock(pos);
    }

    public static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        return MythologicalRitual.onInteractBlock(hitResult.method_17777());
    }

    @NotNull
    private static class_1269 onInteractBlock(class_2338 pos) {
        if (MythologicalRitual.isActive() && griffinBurrows.containsKey(pos)) {
            lastDugBurrowPos = pos;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onUseItem(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (MythologicalRitual.isActive() && SPADES.contains(stack.getSkyblockId())) {
            lastEchoTime = System.currentTimeMillis();
        }
        return class_1269.field_5811;
    }

    public static boolean onChatMessage(class_2561 message, boolean overlay) {
        if (MythologicalRitual.isActive() && GRIFFIN_BURROW_DUG.matcher(message.getString()).matches()) {
            MythologicalRitual.previousBurrow.confirmed = TriState.FALSE;
            if (lastDugBurrowPos == null) {
                return true;
            }
            previousBurrow = griffinBurrows.get(lastDugBurrowPos);
            MythologicalRitual.previousBurrow.confirmed = TriState.DEFAULT;
        }
        return true;
    }

    private static boolean isActive() {
        return SkyblockerConfigManager.get().helpers.mythologicalRitual.enableMythologicalRitualHelper && Utils.getLocation() == Location.HUB;
    }

    private static void reset() {
        griffinBurrows.clear();
        lastDugBurrowPos = null;
        previousBurrow = new GriffinBurrow(class_2338.field_10980);
        MythologicalRitual.previousBurrow.confirmed = TriState.DEFAULT;
        griffinBurrows.put(class_2338.field_10980, previousBurrow);
    }

    static {
        griffinBurrows = new HashMap<class_2338, GriffinBurrow>();
        previousBurrow = new GriffinBurrow(class_2338.field_10980);
    }

    private static class GriffinBurrow
    extends Waypoint {
        private int critParticle;
        private int enchantParticle;
        private TriState confirmed = TriState.FALSE;
        private final SimpleRegression regression = new SimpleRegression();
        @Nullable
        private class_243[] nextBurrowLine;
        @Nullable
        private class_243[] echoBurrowDirection;
        @Nullable
        private class_243[] echoBurrowLine;
        @Nullable
        private class_2338 nextBurrowEstimatedPos;
        @Nullable
        private Line nextBurrowLineEstimation;
        @Nullable
        private Line echoBurrowLineEstimation;

        private GriffinBurrow(class_2338 pos) {
            super(pos, Waypoint.Type.WAYPOINT, ORANGE_COLOR_COMPONENTS, 0.25f);
        }

        private void init() {
            this.confirmed = TriState.TRUE;
            this.regression.clear();
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() && this.confirmed == TriState.TRUE;
        }
    }
}

