/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.render.Renderer;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollectorImpl;
import de.hysky.skyblocker.utils.render.state.CameraRenderState;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10209;
import net.minecraft.class_11231;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RenderHelper {
    private static final class_310 CLIENT = class_310.method_1551();
    private static PrimitiveCollectorImpl collector;

    @Init
    public static void init() {
        WorldRenderEvents.AFTER_SETUP.register(RenderHelper::startFrame);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(RenderHelper::executeDraws);
    }

    private static void startFrame(WorldRenderContext context) {
        collector = new PrimitiveCollectorImpl();
        ((WorldRenderExtractionCallback)WorldRenderExtractionCallback.EVENT.invoker()).onExtract(collector);
        collector.endCollection();
    }

    private static void executeDraws(WorldRenderContext context) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("skyblockerSubmitPrimitives");
        CameraRenderState cameraState = new CameraRenderState();
        cameraState.pos = context.camera().method_19326();
        cameraState.rotation = new Quaternionf((Quaternionfc)context.camera().method_23767());
        cameraState.pitch = context.camera().method_19329();
        cameraState.yaw = context.camera().method_19330();
        collector.dispatchPrimitivesToRenderers(cameraState);
        collector = null;
        profiler.method_15407();
        profiler.method_15396("skyblockerExecuteDraws");
        Renderer.executeDraws();
        profiler.method_15407();
    }

    public static void runOnRenderThread(Runnable runnable) {
        if (RenderSystem.isOnRenderThread()) {
            runnable.run();
        } else {
            CLIENT.execute(runnable);
        }
    }

    public static class_9779 getTickCounter() {
        return CLIENT.method_61966();
    }

    public static class_4184 getCamera() {
        return RenderHelper.CLIENT.field_1773.method_19418();
    }

    @Nullable
    public static class_238 getBlockBoundingBox(class_638 world, class_2338 pos) {
        return RenderHelper.getBlockBoundingBox(world, world.method_8320(pos), pos);
    }

    @Nullable
    public static class_238 getBlockBoundingBox(class_638 world, class_2680 state, class_2338 pos) {
        class_265 shape = state.method_26218((class_1922)world, pos).method_52620();
        return shape.method_1110() ? null : shape.method_1107().method_996(pos);
    }

    public static class_11231 singleTexture(GpuTextureView texture) {
        return class_11231.method_70900((GpuTextureView)texture);
    }

    public static class_11231 textureWithLightmap(GpuTextureView texture) {
        return class_11231.method_70902((GpuTextureView)texture);
    }
}

