/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.waypoint;

import com.google.common.primitives.Floats;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.waypoint.OrderedNamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_8824;
import net.minecraft.class_9848;

public class NamedWaypoint
extends Waypoint {
    public static final Codec<NamedWaypoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(waypoint -> waypoint.pos), (App)class_8824.field_46597.fieldOf("name").forGetter(waypoint -> waypoint.name), (App)Codec.floatRange((float)0.0f, (float)1.0f).listOf().comapFlatMap(colorComponentsList -> colorComponentsList.size() == 3 ? DataResult.success((Object)Floats.toArray((Collection)colorComponentsList)) : DataResult.error(() -> "Expected 3 color components, got " + colorComponentsList.size() + " instead"), Floats::asList).fieldOf("colorComponents").forGetter(waypoint -> waypoint.colorComponents), (App)Codec.FLOAT.fieldOf("alpha").forGetter(waypoint -> Float.valueOf(waypoint.alpha)), (App)Codec.BOOL.fieldOf("shouldRender").forGetter(Waypoint::isEnabled)).apply((Applicative)instance, NamedWaypoint::new));
    public static final Codec<NamedWaypoint> SKYTILS_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(waypoint -> waypoint.pos.method_10263()), (App)Codec.INT.fieldOf("y").forGetter(waypoint -> waypoint.pos.method_10264()), (App)Codec.INT.fieldOf("z").forGetter(waypoint -> waypoint.pos.method_10260()), (App)Codec.either((Codec)Codec.STRING, (Codec)Codec.INT).xmap(either -> (String)either.map(Function.identity(), Object::toString), Either::left).fieldOf("name").forGetter(waypoint -> waypoint.name.getString()), (App)Codec.INT.optionalFieldOf("color", (Object)class_9848.method_61324((int)128, (int)0, (int)255, (int)0)).forGetter(waypoint -> (int)(waypoint.alpha * 255.0f) << 24 | (int)(waypoint.colorComponents[0] * 255.0f) << 16 | (int)(waypoint.colorComponents[1] * 255.0f) << 8 | (int)(waypoint.colorComponents[2] * 255.0f)), (App)Codec.BOOL.fieldOf("enabled").forGetter(Waypoint::isEnabled)).apply((Applicative)instance, NamedWaypoint::fromSkytils));
    static final Codec<NamedWaypoint> COLEWEIGHT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(waypoint -> waypoint.pos.method_10263()), (App)Codec.INT.fieldOf("y").forGetter(waypoint -> waypoint.pos.method_10264()), (App)Codec.INT.fieldOf("z").forGetter(waypoint -> waypoint.pos.method_10260()), (App)CodecUtils.optionalDouble((MapCodec<Optional<Double>>)Codec.DOUBLE.optionalFieldOf("r")).forGetter(waypoint -> OptionalDouble.of(waypoint.colorComponents[0])), (App)CodecUtils.optionalDouble((MapCodec<Optional<Double>>)Codec.DOUBLE.optionalFieldOf("g")).forGetter(waypoint -> OptionalDouble.of(waypoint.colorComponents[1])), (App)CodecUtils.optionalDouble((MapCodec<Optional<Double>>)Codec.DOUBLE.optionalFieldOf("b")).forGetter(waypoint -> OptionalDouble.of(waypoint.colorComponents[2])), (App)ColeweightOptions.CODEC.optionalFieldOf("options").forGetter(waypoint -> Optional.of(new ColeweightOptions(Optional.of(waypoint.name.getString()))))).apply((Applicative)instance, NamedWaypoint::fromColeweight));
    static final Codec<NamedWaypoint> SKYBLOCKER_LEGACY_ORDERED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(waypoint -> waypoint.pos), (App)Codec.floatRange((float)0.0f, (float)1.0f).listOf().xmap(Floats::toArray, FloatArrayList::new).optionalFieldOf("colorComponents", (Object)new float[0]).forGetter(waypoint -> waypoint.colorComponents)).apply((Applicative)instance, (pos, colorComponents) -> new OrderedNamedWaypoint((class_2338)pos, "", new float[]{0.0f, 1.0f, 0.0f})));
    public static final Comparator<NamedWaypoint> NAME_COMPARATOR = new NameComparator();
    public final class_2561 name;
    public final class_243 centerPos;

    public NamedWaypoint(NamedWaypoint namedWaypoint) {
        this(namedWaypoint.pos, namedWaypoint.name, namedWaypoint.typeSupplier, namedWaypoint.colorComponents, namedWaypoint.alpha, namedWaypoint.isEnabled(), namedWaypoint.throughWalls);
    }

    public NamedWaypoint(class_2338 pos, String name, float[] colorComponents) {
        this(pos, name, colorComponents, true);
    }

    public NamedWaypoint(class_2338 pos, String name, float[] colorComponents, boolean enabled) {
        this(pos, name, colorComponents, 0.5f, enabled);
    }

    public NamedWaypoint(class_2338 pos, String name, float[] colorComponents, float alpha, boolean enabled) {
        this(pos, class_2561.method_30163((String)name), colorComponents, alpha, enabled);
    }

    public NamedWaypoint(class_2338 pos, class_2561 name, float[] colorComponents, boolean enabled) {
        this(pos, name, () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType, colorComponents, 0.5f, enabled);
    }

    public NamedWaypoint(class_2338 pos, class_2561 name, float[] colorComponents, float alpha, boolean enabled) {
        this(pos, name, () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType, colorComponents, alpha, enabled);
    }

    public NamedWaypoint(class_2338 pos, class_2561 name, Supplier<Waypoint.Type> typeSupplier, float[] colorComponents) {
        this(pos, name, typeSupplier, colorComponents, 0.5f, true);
    }

    public NamedWaypoint(class_2338 pos, class_2561 name, Supplier<Waypoint.Type> typeSupplier, float[] colorComponents, float alpha, boolean enabled) {
        this(pos, name, typeSupplier, colorComponents, alpha, enabled, true);
    }

    public NamedWaypoint(class_2338 pos, class_2561 name, Supplier<Waypoint.Type> typeSupplier, float[] colorComponents, float alpha, boolean enabled, boolean throughWalls) {
        super(pos, typeSupplier, colorComponents, alpha, 5.0f, throughWalls, enabled);
        this.name = name;
        this.centerPos = pos.method_46558();
    }

    public static NamedWaypoint fromSkytils(int x, int y, int z, String name, int color, boolean enabled) {
        float alpha = (float)((color & 0xFF000000) >>> 24) / 255.0f;
        if (alpha == 0.0f) {
            alpha = 0.5f;
        }
        return new NamedWaypoint(new class_2338(x, y, z), name, ColorUtils.getFloatComponents(color), alpha, enabled);
    }

    public static NamedWaypoint fromColeweight(int x, int y, int z, OptionalDouble r, OptionalDouble g, OptionalDouble b, Optional<ColeweightOptions> options) {
        return new NamedWaypoint(new class_2338(x, y, z), options.flatMap(ColeweightOptions::name).orElse("New Waypoint"), new float[]{(float)r.orElse(0.0), (float)g.orElse(1.0), (float)b.orElse(0.0)}, 0.5f, true);
    }

    public NamedWaypoint copy() {
        return new NamedWaypoint(this);
    }

    @Override
    public NamedWaypoint withX(int x) {
        return new NamedWaypoint(new class_2338(x, this.pos.method_10264(), this.pos.method_10260()), this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public NamedWaypoint withY(int y) {
        return new NamedWaypoint(this.pos.method_33096(y), this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public NamedWaypoint withZ(int z) {
        return new NamedWaypoint(new class_2338(this.pos.method_10263(), this.pos.method_10264(), z), this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public NamedWaypoint withColor(float[] colorComponents, float alpha) {
        return new NamedWaypoint(this.pos, this.name, this.typeSupplier, colorComponents, alpha, this.isEnabled(), this.throughWalls);
    }

    @Override
    public NamedWaypoint withThroughWalls(boolean throughWalls) {
        return new NamedWaypoint(this.pos, this.name, this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), throughWalls);
    }

    @Override
    public NamedWaypoint withTypeSupplier(Supplier<Waypoint.Type> typeSupplier) {
        return new NamedWaypoint(this.pos, this.name, typeSupplier, this.colorComponents, this.alpha, this.isEnabled(), this.throughWalls);
    }

    public class_2561 getName() {
        return this.name;
    }

    public NamedWaypoint withName(String name) {
        return new NamedWaypoint(this.pos, (class_2561)class_2561.method_43470((String)name), this.typeSupplier, this.colorComponents, this.alpha, this.isEnabled());
    }

    protected boolean shouldRenderName() {
        return this.shouldRender();
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        super.extractRendering(collector);
        if (this.shouldRenderName()) {
            float scale = Math.max((float)RenderHelper.getCamera().method_19326().method_1022(this.centerPos) / 10.0f, 1.0f);
            collector.submitText(this.name, this.centerPos.method_1031(0.0, 1.0, 0.0), scale, true);
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!super.equals(obj)) return false;
        if (!(obj instanceof NamedWaypoint)) return false;
        NamedWaypoint waypoint = (NamedWaypoint)obj;
        if (!this.name.equals((Object)waypoint.name)) return false;
        return true;
    }

    private record ColeweightOptions(Optional<String> name) {
        public static final Codec<ColeweightOptions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either((Codec)Codec.STRING, (Codec)Codec.INT).xmap(either -> (String)either.map(Function.identity(), Object::toString), Either::left).optionalFieldOf("name").forGetter(ColeweightOptions::name)).apply((Applicative)instance, ColeweightOptions::new));
    }

    private static class NameComparator
    implements Comparator<NamedWaypoint> {
        private NameComparator() {
        }

        @Override
        public int compare(NamedWaypoint o1, NamedWaypoint o2) {
            String prefix2;
            String string1 = o1.getName().getString();
            String string2 = o2.getName().getString();
            String prefix1 = string1.replaceFirst("\\d+$", "");
            int i = prefix1.compareTo(prefix2 = string2.replaceFirst("\\d+$", ""));
            if (i != 0) {
                return i;
            }
            String num1 = string1.substring(prefix1.length());
            String num2 = string2.substring(prefix2.length());
            if (num1.isEmpty() || num2.isEmpty()) {
                return string1.compareTo(string2);
            }
            try {
                int i1 = Integer.parseInt(num1);
                int i2 = Integer.parseInt(num2);
                return Integer.compare(i1, i2);
            }
            catch (NumberFormatException e) {
                return string1.compareTo(string2);
            }
        }
    }
}

