/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility;

import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;

public class ModernUICompatibility {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean MODERNUI_ENABLED = FabricLoader.getInstance().isModLoaded("modernui");
    private static final boolean IS_TEXT_ENGINE_ENABLED = ModernUICompatibility.isTextEngineEnabled();

    private static boolean isTextEngineEnabled() {
        Class<?> clazz;
        if (!MODERNUI_ENABLED) {
            return false;
        }
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        try {
            clazz = Class.forName("icyllis.modernui.mc.ModernUIMod");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("[Skyblocker ModernUI Compat] Could not find icyllis.modernui.mc.ModernUIMod", (Throwable)e);
            return true;
        }
        try {
            MethodHandle methodHandle = lookup.findStatic(clazz, "isTextEngineEnabled", MethodType.methodType(Boolean.TYPE));
            return Boolean.TRUE.equals(methodHandle.invoke());
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            LOGGER.error("[Skyblocker ModernUI Compat] Could not find isTextEngineEnabled method", (Throwable)e);
            return true;
        }
        catch (Throwable e) {
            LOGGER.error("[Skyblocker ModernUI Compat] Could not invoke isTextEngineEnabled", e);
            return true;
        }
    }

    public static boolean drawOutlinedText(class_332 context, class_2561 text, int x, int y, int color, int outlineColor) {
        if (!IS_TEXT_ENGINE_ENABLED) {
            return false;
        }
        float offset = 0.5f;
        class_327 textRenderer = class_310.method_1551().field_1772;
        class_5481 outlineText = class_2561.method_43470((String)text.getString()).method_30937();
        Matrix3x2fStack pose = context.method_51448();
        pose.pushMatrix().translate(0.5f, 0.0f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(0.5f, 0.5f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(0.5f, -0.5f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(-0.5f, 0.0f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(-0.5f, 0.5f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(-0.5f, -0.5f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(0.0f, 0.5f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        pose.pushMatrix().translate(0.0f, -0.5f);
        context.method_51430(textRenderer, outlineText, x, y, outlineColor, false);
        pose.popMatrix();
        context.method_51430(textRenderer, text.method_30937(), x, y, color, false);
        return true;
    }
}

