/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chocolatefactory;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.PosUtils;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.command.argumenttypes.EggTypeArgumentType;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientBlockPosArgumentType;
import de.hysky.skyblocker.utils.command.argumenttypes.blockpos.ClientPosArgument;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.waypoint.SeenWaypoint;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_7157;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EggFinder {
    private static final Pattern eggFoundPattern = Pattern.compile("^(?:HOPPITY'S HUNT You found a Chocolate|You have already collected this Chocolate) (Breakfast|Lunch|Dinner)");
    private static final Pattern newEggPattern = Pattern.compile("^HOPPITY'S HUNT A Chocolate (Breakfast|Lunch|Dinner) Egg has appeared!$");
    private static final Logger logger = LoggerFactory.getLogger((String)"Skyblocker Egg Finder");
    private static final LinkedList<class_1531> armorStandQueue = new LinkedList();
    private static final Location[] possibleLocations = new Location[]{Location.CRIMSON_ISLE, Location.CRYSTAL_HOLLOWS, Location.DUNGEON_HUB, Location.DWARVEN_MINES, Location.HUB, Location.THE_END, Location.THE_PARK, Location.GOLD_MINE, Location.DEEP_CAVERNS, Location.SPIDERS_DEN, Location.THE_FARMING_ISLAND};
    private static boolean isLocationCorrect = false;

    private EggFinder() {
    }

    @Init
    public static void init() {
    }

    private static void handleLocationChange(Location location) {
        for (Location possibleLocation : possibleLocations) {
            if (location != possibleLocation) continue;
            isLocationCorrect = true;
            break;
        }
        if (!isLocationCorrect) {
            armorStandQueue.clear();
            return;
        }
        while (!armorStandQueue.isEmpty()) {
            EggFinder.handleArmorStand(armorStandQueue.poll());
        }
    }

    public static void checkIfEgg(class_1297 entity) {
    }

    public static void checkIfEgg(class_1531 armorStand) {
    }

    private static void handleArmorStand(class_1531 armorStand) {
        for (class_1799 itemStack : ItemUtils.getArmor((class_1309)armorStand)) {
            ItemUtils.getHeadTextureOptional(itemStack).ifPresent(texture -> {
                for (EggType type : EggType.entries) {
                    if (!texture.equals(type.texture) || type.egg != null && type.egg.entity.method_24515().equals((Object)armorStand.method_24515())) continue;
                    type.egg = new Egg(armorStand, armorStand.method_24515().method_10086(2), SkyblockerConfigManager.get().helpers.chocolateFactory.waypointType, ColorUtils.getFloatComponents(type.color));
                    return;
                }
            });
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().helpers.chocolateFactory.enableEggFinder) {
            return;
        }
        for (EggType type : EggType.entries) {
            Egg egg = type.egg;
            if (egg == null) continue;
            egg.extractRendering(collector);
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (overlay || !SkyblockerConfigManager.get().helpers.chocolateFactory.enableEggFinder) {
            return true;
        }
        Matcher matcher = eggFoundPattern.matcher(text.getString());
        if (matcher.find()) {
            try {
                EggType eggType = EggType.valueOf(matcher.group(1).toUpperCase(Locale.ENGLISH));
                eggType.collected = true;
                Egg egg = eggType.egg;
                if (egg != null) {
                    egg.setFound();
                }
            }
            catch (IllegalArgumentException e) {
                logger.error("[Skyblocker Egg Finder] Failed to find egg type for egg found message. Tried to match against: {}", (Object)matcher.group(0), (Object)e);
            }
        }
        matcher.usePattern(newEggPattern);
        if (matcher.find()) {
            try {
                EggType.valueOf(matcher.group(1).toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                logger.error("[Skyblocker Egg Finder] Failed to find egg type for egg spawn message. Tried to match against: {}", (Object)matcher.group(0), (Object)e);
            }
        }
        return true;
    }

    private static /* synthetic */ void lambda$init$4(CommandDispatcher dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"eggFinder").then(ClientCommandManager.literal((String)"shareLocation").then(ClientCommandManager.argument((String)"blockPos", (ArgumentType)ClientBlockPosArgumentType.blockPos()).then(ClientCommandManager.argument((String)"eggType", (ArgumentType)EggTypeArgumentType.eggType()).executes(context -> {
            MessageScheduler.INSTANCE.sendMessageAfterCooldown("[Skyblocker] Chocolate " + String.valueOf(context.getArgument("eggType", EggType.class)) + " Egg found at " + ((ClientPosArgument)context.getArgument("blockPos", ClientPosArgument.class)).toAbsoluteBlockPos((FabricClientCommandSource)context.getSource()).method_23854() + "!", false);
            return 1;
        }))))));
    }

    private static /* synthetic */ void lambda$init$2(int hour) {
        for (EggType type : EggType.entries) {
            if (hour != type.resetHour) continue;
            type.collected = false;
        }
    }

    private static /* synthetic */ void lambda$init$1(class_310 client) {
        if (!SkyblockerConfigManager.get().helpers.chocolateFactory.enableEggFinder || client.field_1724 == null) {
            return;
        }
        if (!isLocationCorrect || SkyblockTime.skyblockSeason.get() != SkyblockTime.Season.SPRING) {
            return;
        }
        for (EggType type : EggType.entries) {
            Egg egg = type.egg;
            if (egg == null || egg.isSeen()) continue;
            egg.tick(client);
            if (!egg.isSeen()) continue;
            type.setSeen();
        }
    }

    private static /* synthetic */ void lambda$init$0(class_634 ignored, PacketSender ignored2, class_310 ignored3) {
        isLocationCorrect = false;
        for (EggType type : EggType.entries) {
            type.collected = false;
            type.egg = null;
        }
    }

    public static enum EggType {
        LUNCH(class_124.field_1078.method_532(), 14, "ewogICJ0aW1lc3RhbXAiIDogMTcxMTQ2MjU2ODExMiwKICAicHJvZmlsZUlkIiA6ICI3NzUwYzFhNTM5M2Q0ZWQ0Yjc2NmQ4ZGUwOWY4MjU0NiIsCiAgInByb2ZpbGVOYW1lIiA6ICJSZWVkcmVsIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzdhZTZkMmQzMWQ4MTY3YmNhZjk1MjkzYjY4YTRhY2Q4NzJkNjZlNzUxZGI1YTM0ZjJjYmM2NzY2YTAzNTZkMGEiCiAgICB9CiAgfQp9"),
        DINNER(class_124.field_1060.method_532(), 21, "ewogICJ0aW1lc3RhbXAiIDogMTcxMTQ2MjY0OTcwMSwKICAicHJvZmlsZUlkIiA6ICI3NGEwMzQxNWY1OTI0ZTA4YjMyMGM2MmU1NGE3ZjJhYiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNZXp6aXIiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTVlMzYxNjU4MTlmZDI4NTBmOTg1NTJlZGNkNzYzZmY5ODYzMTMxMTkyODNjMTI2YWNlMGM0Y2M0OTVlNzZhOCIKICAgIH0KICB9Cn0"),
        BREAKFAST(class_124.field_1065.method_532(), 7, "ewogICJ0aW1lc3RhbXAiIDogMTcxMTQ2MjY3MzE0OSwKICAicHJvZmlsZUlkIiA6ICJiN2I4ZTlhZjEwZGE0NjFmOTY2YTQxM2RmOWJiM2U4OCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbmFiYW5hbmFZZzciLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTQ5MzMzZDg1YjhhMzE1ZDAzMzZlYjJkZjM3ZDhhNzE0Y2EyNGM1MWI4YzYwNzRmMWI1YjkyN2RlYjUxNmMyNCIKICAgIH0KICB9Cn0");

        public static final ObjectImmutableList<EggType> entries;
        public final int color;
        public final String texture;
        public final int resetHour;
        boolean collected = false;
        private Egg egg = null;
        private long messageLastSent = 0L;

        private EggType(int color, int resetHour, String texture) {
            this.color = color;
            this.resetHour = resetHour;
            this.texture = texture;
        }

        public void setSeen() {
            if (!SkyblockerConfigManager.get().helpers.chocolateFactory.sendEggFoundMessages || System.currentTimeMillis() - this.messageLastSent < 1000L) {
                return;
            }
            if (this.collected) {
                this.egg.setFound();
                return;
            }
            this.messageLastSent = System.currentTimeMillis();
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_27693("Found a ").method_10852((class_2561)class_2561.method_43470((String)("Chocolate " + String.valueOf((Object)this) + " Egg")).method_54663(this.color)).method_27693(" at " + this.egg.entity.method_24515().method_10086(2).method_23854() + "!").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker eggFinder shareLocation " + PosUtils.toSpaceSeparatedString(this.egg.pos) + " " + String.valueOf((Object)this))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Click to share the location in chat!").method_27692(class_124.field_1060)))), false);
        }

        public String toString() {
            return WordUtils.capitalizeFully((String)this.name());
        }

        static {
            entries = ObjectImmutableList.of((Object[])EggType.values());
        }
    }

    static class Egg
    extends SeenWaypoint {
        private final class_1531 entity;

        Egg(class_1531 entity, class_2338 pos, Waypoint.Type type, float[] colorComponents) {
            super(pos, type, colorComponents);
            this.entity = entity;
        }
    }
}

