/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.utils.Utils;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.hud.VanillaHudElements;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class DungeonScoreHUD {
    private static final class_2960 DUNGEON_SCORE = class_2960.method_60655((String)"skyblocker", (String)"dungeon_score");
    private static final class_2561 extraSpace = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43470((String)" ").method_27692(class_124.field_1067));

    private DungeonScoreHUD() {
    }

    @Init
    public static void init() {
        HudElementRegistry.attachElementAfter((class_2960)VanillaHudElements.OVERLAY_MESSAGE, (class_2960)DUNGEON_SCORE, (context, tickCounter) -> DungeonScoreHUD.render(context));
    }

    private static void render(class_332 context) {
        if (Utils.isInDungeons() && DungeonScore.isDungeonStarted() && SkyblockerConfigManager.get().dungeons.dungeonScore.enableScoreHUD) {
            int x = SkyblockerConfigManager.get().dungeons.dungeonScore.scoreX;
            int y = SkyblockerConfigManager.get().dungeons.dungeonScore.scoreY;
            DungeonScoreHUD.render(context, x, y);
        }
    }

    public static void render(class_332 context, int x, int y) {
        float scale = SkyblockerConfigManager.get().dungeons.dungeonScore.scoreScaling;
        Matrix3x2fStack matrixStack = context.method_51448();
        matrixStack.pushMatrix();
        matrixStack.scale(scale, scale);
        context.method_27535(class_310.method_1551().field_1772, DungeonScoreHUD.getFormattedScoreText(), (int)((float)x / scale), (int)((float)y / scale), -1);
        matrixStack.popMatrix();
    }

    public static class_2561 getFormattedScoreText() {
        return class_2561.method_43469((String)"skyblocker.dungeons.dungeonScore.scoreText", (Object[])new Object[]{DungeonScoreHUD.formatScore(DungeonScore.getScore())});
    }

    private static class_2561 formatScore(int score) {
        if (score < 100) {
            return class_2561.method_43470((String)String.format("%03d", score)).method_54663(14424602).method_10852((class_2561)class_2561.method_43470((String)" (D)").method_27692(class_124.field_1080)).method_10852(extraSpace);
        }
        if (score < 160) {
            return class_2561.method_43470((String)String.format("%03d", score)).method_54663(0x4141FF).method_10852((class_2561)class_2561.method_43470((String)" (C)").method_27692(class_124.field_1080)).method_10852(extraSpace);
        }
        if (score < 230) {
            return class_2561.method_43470((String)String.format("%03d", score)).method_54663(8375321).method_10852((class_2561)class_2561.method_43470((String)" (B)").method_27692(class_124.field_1080)).method_10852(extraSpace);
        }
        if (score < 270) {
            return class_2561.method_43470((String)String.format("%03d", score)).method_54663(8339378).method_10852((class_2561)class_2561.method_43470((String)" (A)").method_27692(class_124.field_1080)).method_10852(extraSpace);
        }
        if (score < 300) {
            return class_2561.method_43470((String)String.format("%03d", score)).method_54663(15852114).method_10852((class_2561)class_2561.method_43470((String)" (S)").method_27692(class_124.field_1080)).method_10852(extraSpace);
        }
        return class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)String.format("%03d", score)).method_54663(15852114).method_27692(class_124.field_1067)).method_10852((class_2561)class_2561.method_43470((String)" (S+)").method_27692(class_124.field_1080));
    }
}

