/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.device;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.skyblock.dungeon.DungeonBoss;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Objects;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class SimonSays {
    private static final class_238 BOARD_AREA = class_238.method_54784((class_2338)new class_2338(111, 123, 92), (class_2338)new class_2338(111, 120, 95));
    private static final class_238 BUTTONS_AREA = class_238.method_54784((class_2338)new class_2338(110, 123, 92), (class_2338)new class_2338(110, 120, 95));
    private static final class_2338 START_BUTTON = new class_2338(110, 121, 91);
    private static final float[] GREEN = ColorUtils.getFloatComponents(class_1767.field_7961);
    private static final float[] YELLOW = ColorUtils.getFloatComponents(class_1767.field_7947);
    private static final ObjectSet<class_2338> CLICKED_BUTTONS = new ObjectOpenHashSet();
    private static final ObjectList<class_2338> SIMON_PATTERN = new ObjectArrayList();

    @Init
    public static void init() {
        UseBlockCallback.EVENT.register(SimonSays::onBlockInteract);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> SimonSays.reset());
        WorldRenderExtractionCallback.EVENT.register(SimonSays::extractRendering);
        WorldEvents.BLOCK_STATE_UPDATE.register(SimonSays::onBlockUpdate);
    }

    private static class_1269 onBlockInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        class_2338 pos;
        class_2248 block;
        if (SimonSays.shouldProcess() && (block = world.method_8320(pos = hitResult.method_17777()).method_26204()).equals(class_2246.field_10494)) {
            if (BUTTONS_AREA.method_1006(class_243.method_24954((class_2382)pos))) {
                CLICKED_BUTTONS.add((Object)new class_2338((class_2382)pos));
            } else if (pos.equals((Object)START_BUTTON)) {
                SimonSays.reset();
            }
        }
        return class_1269.field_5811;
    }

    private static void onBlockUpdate(class_2338 pos, @Nullable class_2680 oldState, class_2680 newState) {
        if (SimonSays.shouldProcess()) {
            class_243 posVec = class_243.method_24954((class_2382)pos);
            class_2248 newBlock = newState.method_26204();
            if (BOARD_AREA.method_1006(posVec) && newBlock.equals(class_2246.field_10540) && oldState != null && oldState.method_26204().equals(class_2246.field_10174)) {
                SIMON_PATTERN.add((Object)pos.method_10062());
            } else if (BUTTONS_AREA.method_1006(posVec) && newBlock.equals(class_2246.field_10124)) {
                SimonSays.reset();
            }
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (SimonSays.shouldProcess()) {
            int buttonsRendered = 0;
            for (class_2338 pos : SIMON_PATTERN) {
                class_238 outline;
                class_2338 buttonPos = pos.method_10067();
                class_638 world = Objects.requireNonNull(class_310.method_1551().field_1687);
                class_2680 state = world.method_8320(buttonPos);
                if (CLICKED_BUTTONS.contains((Object)buttonPos) || !state.method_26204().equals(class_2246.field_10494) || (outline = RenderHelper.getBlockBoundingBox(world, state, buttonPos)) == null) continue;
                float[] colour = buttonsRendered == 0 ? GREEN : YELLOW;
                collector.submitFilledBox(outline, colour, 0.5f, true);
                collector.submitOutlinedBox(outline, colour, 5.0f, true);
                if (++buttonsRendered != 2) continue;
                return;
            }
        }
    }

    private static boolean shouldProcess() {
        return SkyblockerConfigManager.get().dungeons.devices.solveSimonSays && Utils.isInDungeons() && DungeonManager.isInBoss() && DungeonManager.getBoss() == DungeonBoss.MAXOR;
    }

    private static void reset() {
        CLICKED_BUTTONS.clear();
        SIMON_PATTERN.clear();
    }
}

