/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.partyfinder;

import com.google.gson.JsonObject;
import com.mojang.authlib.properties.PropertyMap;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.dungeon.partyfinder.FinderSettingsContainer;
import de.hysky.skyblocker.skyblock.dungeon.partyfinder.PartyEntry;
import de.hysky.skyblocker.skyblock.dungeon.partyfinder.PartyEntryListWidget;
import de.hysky.skyblocker.utils.ItemUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2877;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_634;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartyFinderScreen
extends class_437 {
    protected static final Logger LOGGER = LoggerFactory.getLogger(PartyFinderScreen.class);
    protected static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60656((String)"social_interactions/background");
    protected static final class_2960 SEARCH_ICON_TEXTURE = class_2960.method_60656((String)"icon/search");
    protected static final class_2561 SEARCH_TEXT = class_2561.method_43471((String)"gui.socialInteractions.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
    public static boolean isInKuudraPartyFinder = false;
    public static boolean DEBUG = false;
    public static final List<String> possibleInventoryNames = List.of("party finder", "search settings", "select floor", "select type", "class level range", "dungeon level range", "sort");
    private class_2561 name;
    private class_1707 handler;
    private final class_1661 inventory;
    private Page currentPage;
    public PartyEntryListWidget partyEntryListWidget;
    private FinderSettingsContainer settingsContainer;
    private int refreshSlotId = -1;
    private class_342 searchField;
    private class_4185 refreshButton;
    private class_4185 previousPageButton;
    private int prevPageSlotId = -1;
    private class_4185 nextPageButton;
    private int nextPageSlotId = -1;
    protected class_4185 partyFinderButton;
    protected int partyButtonSlotId = -1;
    private class_4185 settingsButton;
    private int settingsButtonSlotId = -1;
    private class_4185 createPartyButton;
    private int createPartyButtonSlotId = -1;
    private boolean dirty = false;
    private long dirtiedTime;
    private boolean waitingForServer = false;
    public static Map<String, PropertyMap> floorIconsNormal = null;
    public static Map<String, PropertyMap> floorIconsMaster = null;
    private boolean signFront = true;
    @Nullable
    private class_2625 sign = null;
    private boolean aborted = false;

    public class_1707 getHandler() {
        return this.handler;
    }

    public FinderSettingsContainer getSettingsContainer() {
        return this.settingsContainer;
    }

    public void markDirty() {
        if (this.sign != null) {
            return;
        }
        this.dirtiedTime = System.currentTimeMillis();
        this.dirty = true;
    }

    @Init
    public static void initClass() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> CompletableFuture.runAsync(() -> {
            floorIconsNormal = new HashMap<String, PropertyMap>();
            floorIconsMaster = new HashMap<String, PropertyMap>();
            try (BufferedReader skullTextureReader = client.method_1478().openAsReader(SkyblockerMod.id("dungeons/catacombs/floorskulls.json"));){
                JsonObject json = (JsonObject)SkyblockerMod.GSON.fromJson((Reader)skullTextureReader, JsonObject.class);
                json.getAsJsonObject("normal").asMap().forEach((s, tex) -> floorIconsNormal.put((String)s, ItemUtils.propertyMapWithTexture(tex.getAsString())));
                json.getAsJsonObject("master").asMap().forEach((s, tex) -> floorIconsMaster.put((String)s, ItemUtils.propertyMapWithTexture(tex.getAsString())));
                LOGGER.debug("[Skyblocker] Dungeons floor skull textures json loaded");
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Failed to load dungeons floor skull textures json", (Throwable)e);
            }
        }));
    }

    public PartyFinderScreen(class_1707 handler, class_1661 inventory, class_2561 title) {
        super(title);
        this.handler = handler;
        this.inventory = inventory;
        this.name = title;
    }

    protected void method_25426() {
        super.method_25426();
        int topRowButtonsHeight = 20;
        int widget_height = (int)((double)this.field_22790 * 0.8);
        int entryListTopY = Math.max(43, (int)((double)this.field_22790 * 0.1));
        this.partyEntryListWidget = new PartyEntryListWidget(this.field_22787, this.field_22789, widget_height, entryListTopY, 68);
        this.searchField = new class_342(this.field_22793, this.partyEntryListWidget.method_25342() + 12, entryListTopY - 12, this.partyEntryListWidget.method_25322() - 36 - 6, 12, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchField.method_47404(SEARCH_TEXT);
        this.searchField.method_1863(s -> this.partyEntryListWidget.setSearch((String)s));
        this.refreshButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u27f3").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)), a -> {
            if (this.refreshSlotId != -1) {
                this.clickAndWaitForServer(this.refreshSlotId);
            }
        }).method_46433(this.searchField.method_46426() + this.searchField.method_25368() + 24, this.searchField.method_46427()).method_46437(12, 12).method_46431();
        this.refreshButton.field_22763 = false;
        this.previousPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), a -> {
            if (this.prevPageSlotId != -1) {
                this.clickAndWaitForServer(this.prevPageSlotId);
            }
        }).method_46433(this.searchField.method_46426() + this.searchField.method_25368(), this.searchField.method_46427()).method_46437(12, 12).method_46431();
        this.previousPageButton.field_22763 = false;
        this.nextPageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2192"), a -> {
            if (this.nextPageSlotId != -1) {
                this.clickAndWaitForServer(this.nextPageSlotId);
            }
        }).method_46433(this.searchField.method_46426() + this.searchField.method_25368() + 12, this.searchField.method_46427()).method_46437(12, 12).method_46431();
        this.nextPageButton.field_22763 = false;
        if (this.settingsContainer == null) {
            this.settingsContainer = new FinderSettingsContainer(this.partyEntryListWidget.method_25342(), entryListTopY - 12, widget_height + 12);
        } else {
            this.settingsContainer.method_55444(this.partyEntryListWidget.method_25322() - 2, widget_height + 12, this.partyEntryListWidget.method_25342(), entryListTopY - 12);
        }
        int searchButtonMargin = 2;
        int searchButtonWidth = (this.partyEntryListWidget.method_25322() + 6) / 3 - 2 * searchButtonMargin;
        this.partyFinderButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.partyFinder.tabs.partyFinder"), a -> {
            if (this.partyButtonSlotId != -1) {
                this.setCurrentPage(Page.FINDER);
                this.clickAndWaitForServer(this.partyButtonSlotId);
            }
        }).method_46433(this.partyEntryListWidget.method_25342(), entryListTopY - 39).method_46437(searchButtonWidth + searchButtonMargin, topRowButtonsHeight).method_46431();
        this.settingsButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.partyFinder.tabs.searchSettings"), a -> {
            if (this.settingsButtonSlotId != -1) {
                this.setCurrentPage(Page.SETTINGS);
                this.clickAndWaitForServer(this.settingsButtonSlotId);
            }
        }).method_46433(this.partyEntryListWidget.method_25342() + searchButtonWidth + 3 * searchButtonMargin, entryListTopY - 39).method_46437(searchButtonWidth, topRowButtonsHeight).method_46431();
        this.createPartyButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.partyFinder.tabs.createParty"), a -> {
            if (this.createPartyButtonSlotId != -1) {
                this.clickAndWaitForServer(this.createPartyButtonSlotId);
            }
        }).method_46433(this.partyEntryListWidget.method_25342() + searchButtonWidth * 2 + 5 * searchButtonMargin, entryListTopY - 39).method_46437(searchButtonWidth, topRowButtonsHeight).method_46431();
        this.createPartyButton.field_22763 = false;
        this.method_37063((class_364)this.partyEntryListWidget);
        this.method_37063((class_364)this.searchField);
        this.method_37063((class_364)this.refreshButton);
        this.method_37063((class_364)this.previousPageButton);
        this.method_37063((class_364)this.nextPageButton);
        this.method_37063((class_364)this.partyFinderButton);
        this.method_37063((class_364)this.settingsButton);
        this.method_37063((class_364)this.createPartyButton);
        this.method_37063((class_364)this.settingsContainer);
        if (Debug.debugEnabled()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_30163((String)"DEBUG"), a -> {
                DEBUG = !DEBUG;
            }).method_46434(this.field_22789 - 40, 0, 40, 20).method_46431());
        }
        this.dirtiedTime = System.currentTimeMillis();
        this.setCurrentPage(this.currentPage);
        if (this.currentPage != Page.SIGN) {
            this.update();
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (!this.settingsContainer.canInteract(null)) {
            context.method_25294(0, 0, this.field_22789, this.field_22790, 0x40000000);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.searchField.field_22764) {
            context.method_52706(class_10799.field_56883, SEARCH_ICON_TEXTURE, this.partyEntryListWidget.method_25342() + 1, this.searchField.method_46427() + 1, 10, 10);
        }
        if (DEBUG) {
            context.method_51433(this.field_22793, this.currentPage.toString(), 0, 0, -1, true);
            context.method_51433(this.field_22793, "Truly a party finder", 20, 20, -1, true);
            if (this.sign != null) {
                context.method_51433(this.field_22793, "You are in a sign btw", 20, 30, -1, true);
            } else {
                context.method_51433(this.field_22793, String.valueOf(this.refreshSlotId), this.field_22789 - 25, 30, -1, true);
                context.method_51433(this.field_22793, String.valueOf(this.prevPageSlotId), this.field_22789 - 25, 40, -1, true);
                context.method_51433(this.field_22793, String.valueOf(this.nextPageSlotId), this.field_22789 - 25, 50, -1, true);
                for (int i = 0; i < this.handler.field_7761.size(); ++i) {
                    context.method_51427(((class_1735)this.handler.field_7761.get(i)).method_7677(), i % 9 * 16, i / 9 * 16);
                }
            }
        }
        if (this.isWaitingForServer()) {
            String s = "Waiting for server...";
            int n = this.field_22789 - this.field_22793.method_1727(s) - 5;
            Objects.requireNonNull(this.field_22793);
            context.method_51433(this.field_22793, s, n, this.field_22790 - 9 - 2, -1, true);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_52752(context);
        int i = this.partyEntryListWidget.method_25322() + 16 + 6;
        context.method_52706(class_10799.field_56883, BACKGROUND_TEXTURE, this.partyEntryListWidget.method_25342() - 8, this.partyEntryListWidget.method_46427() - 12 - 8, i, this.partyEntryListWidget.method_55443() - this.partyEntryListWidget.method_46427() + 16 + 12);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1724 != null);
        if (this.currentPage != Page.SIGN) {
            this.field_22787.field_1724.method_7346();
        } else {
            class_634 networkHandler = this.field_22787.method_1562();
            if (networkHandler != null && this.sign != null) {
                List<String> originalText = Arrays.stream(this.sign.method_49843(this.signFront).method_49877(true)).map(class_2561::getString).toList();
                networkHandler.method_52787((class_2596)new class_2877(this.sign.method_11016(), this.signFront, originalText.getFirst(), originalText.get(1), originalText.get(2), originalText.get(3)));
            }
        }
        super.method_25419();
    }

    public void setCurrentPage(Page page) {
        this.currentPage = page;
        if (page == Page.FINDER) {
            this.partyEntryListWidget.field_22764 = true;
            this.partyFinderButton.field_22763 = false;
            this.partyFinderButton.method_25355((class_2561)this.partyFinderButton.method_25369().method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true))));
            this.settingsButton.field_22763 = true;
            this.settingsButton.method_25355((class_2561)this.settingsButton.method_25369().method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(false))));
            this.createPartyButton.field_22763 = true;
            this.searchField.field_22763 = true;
            this.searchField.field_22764 = true;
            this.settingsContainer.setVisible(false);
            this.refreshButton.field_22764 = true;
            this.previousPageButton.field_22764 = true;
            this.nextPageButton.field_22764 = true;
        } else if (page == Page.SETTINGS || page == Page.SIGN) {
            this.partyEntryListWidget.field_22764 = false;
            this.partyFinderButton.field_22763 = page != Page.SIGN;
            this.partyFinderButton.method_25355((class_2561)this.partyFinderButton.method_25369().method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(false))));
            this.settingsButton.field_22763 = false;
            this.settingsButton.method_25355((class_2561)this.settingsButton.method_25369().method_27661().method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true))));
            this.createPartyButton.field_22763 = false;
            this.searchField.field_22763 = false;
            this.searchField.field_22764 = false;
            this.settingsContainer.setVisible(true);
            this.refreshButton.field_22764 = false;
            this.previousPageButton.field_22764 = false;
            this.nextPageButton.field_22764 = false;
        }
    }

    public void updateHandler(class_1707 handler, class_2561 name) {
        this.handler = handler;
        this.name = name;
        this.closedSign();
        this.markDirty();
    }

    public boolean isSignFront() {
        return this.signFront;
    }

    @Nullable
    public class_2625 getSign() {
        return this.sign;
    }

    public void updateSign(class_2625 sign, boolean front) {
        this.setCurrentPage(Page.SIGN);
        this.signFront = front;
        this.sign = sign;
        this.waitingForServer = false;
        if (!this.settingsContainer.handleSign(sign, front)) {
            this.abort();
        }
    }

    public void closedSign() {
        this.sign = null;
    }

    public void update() {
        this.dirty = false;
        this.waitingForServer = false;
        String titleText = this.name.getString();
        if (titleText.contains("Party Finder")) {
            this.updatePartyFinderPage();
        } else {
            if (this.currentPage != Page.SETTINGS) {
                this.setCurrentPage(Page.SETTINGS);
            }
            if (!this.settingsContainer.handle(this, titleText)) {
                this.abort();
            }
        }
    }

    private void updatePartyFinderPage() {
        this.previousPageButton.field_22763 = false;
        this.nextPageButton.field_22763 = false;
        ArrayList<PartyEntry> parties = new ArrayList<PartyEntry>();
        if (this.currentPage != Page.FINDER) {
            this.setCurrentPage(Page.FINDER);
        }
        if (this.handler.field_7761.stream().anyMatch(slot -> slot.method_7681() && slot.method_7677().method_31574(class_1802.field_8542))) {
            parties.add(new PartyEntry.NoParties());
        } else {
            for (class_1735 slot2 : this.handler.field_7761) {
                if (slot2.field_7874 > (this.handler.method_17388() - 1) * 9 - 1 || !slot2.method_7681()) continue;
                class_1799 stack = slot2.method_7677();
                if (stack.method_31574(class_1802.field_8575)) {
                    assert (this.field_22787 != null);
                    parties.add(new PartyEntry(stack.method_7964(), ItemUtils.getLore(stack), this, slot2.field_7874));
                    continue;
                }
                if (stack.method_31574(class_1802.field_8107) && stack.method_7964().getString().toLowerCase(Locale.ENGLISH).contains("previous")) {
                    this.prevPageSlotId = slot2.field_7874;
                    this.previousPageButton.field_22763 = true;
                    continue;
                }
                if (!stack.method_31574(class_1802.field_8107) || !stack.method_7964().getString().toLowerCase(Locale.ENGLISH).contains("next")) continue;
                this.nextPageSlotId = slot2.field_7874;
                this.nextPageButton.field_22763 = true;
            }
        }
        class_1799 yourPartyStack = null;
        int deListSlotId = -1;
        for (int i = (this.handler.method_17388() - 1) * 9; i < this.handler.method_17388() * 9; ++i) {
            class_1735 slot3 = (class_1735)this.handler.field_7761.get(i);
            if (!slot3.method_7681()) continue;
            if (slot3.method_7677().method_31574(class_1802.field_8733)) {
                this.refreshSlotId = slot3.field_7874;
                this.refreshButton.field_22763 = true;
                continue;
            }
            if (slot3.method_7677().method_31574(class_1802.field_8793)) {
                this.createPartyButtonSlotId = slot3.field_7874;
                this.createPartyButton.field_22763 = true;
                continue;
            }
            if (slot3.method_7677().method_31574(class_1802.field_8137)) {
                this.settingsButtonSlotId = slot3.field_7874;
                if (!DEBUG) continue;
                this.settingsButton.method_25355((class_2561)this.settingsButton.method_25369().method_27661().method_10852(class_2561.method_30163((String)(" " + this.settingsButtonSlotId))));
                continue;
            }
            if (slot3.method_7677().method_31574(class_1802.field_8536)) {
                deListSlotId = slot3.field_7874;
                continue;
            }
            if (!slot3.method_7677().method_31574(class_1802.field_8575)) continue;
            assert (this.field_22787 != null);
            yourPartyStack = slot3.method_7677();
        }
        assert (this.field_22787 != null);
        String playerName = this.field_22787.method_1548().method_1676();
        if (yourPartyStack == null && deListSlotId != -1) {
            yourPartyStack = parties.stream().filter(party -> party.partyLeader != null && party.partyLeader.name.getString().equals(playerName)).findFirst().map(party -> party.slotID).map(slotId -> (class_1735)this.handler.field_7761.get(slotId.intValue())).map(class_1735::method_7677).orElse(null);
        }
        if (yourPartyStack != null) {
            class_2561 title = yourPartyStack.method_7964();
            if (deListSlotId != -1) {
                title = class_2561.method_43470((String)(playerName + "'s party"));
            }
            parties.removeIf(party -> party.partyLeader != null && party.partyLeader.name.getString().equals(playerName));
            parties.add(new PartyEntry.YourParty(title, ItemUtils.getLore(yourPartyStack), this, deListSlotId));
        }
        this.partyEntryListWidget.setEntries(parties);
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void abort() {
        assert (this.field_22787 != null);
        if (this.currentPage == Page.SIGN) {
            assert (this.field_22787.field_1724 != null);
            this.field_22787.field_1724.method_7311(this.sign, this.signFront);
        } else {
            this.field_22787.method_1507((class_437)new class_476(this.handler, this.inventory, this.field_22785));
        }
        this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"skyblocker.partyFinder.error.name"), (class_2561)class_2561.method_43471((String)"skyblocker.partyFinder.error.message")));
        this.aborted = true;
    }

    public void method_25432() {
        assert (this.field_22787 != null);
        if (this.field_22787.field_1724 == null || this.aborted || this.currentPage == Page.SIGN) {
            return;
        }
        this.handler.method_7595((class_1657)this.field_22787.field_1724);
    }

    public final void method_25393() {
        super.method_25393();
        if (this.dirty && System.currentTimeMillis() - this.dirtiedTime > 60L) {
            this.update();
        }
        assert (this.field_22787 != null && this.field_22787.field_1724 != null);
        if (!this.field_22787.field_1724.method_5805() || this.field_22787.field_1724.method_31481() && this.currentPage != Page.SIGN) {
            this.field_22787.field_1724.method_7346();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.settingsContainer != null && this.settingsContainer.hasOpenOption()) {
            return this.settingsContainer.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void clickAndWaitForServer(int slotID) {
        assert (this.field_22787 != null);
        assert (this.field_22787.field_1761 != null);
        this.field_22787.field_1761.method_2906(this.handler.field_7763, slotID, 0, class_1713.field_7790, (class_1657)this.field_22787.field_1724);
        this.waitingForServer = true;
    }

    public boolean isWaitingForServer() {
        return this.waitingForServer;
    }

    @NotNull
    public class_310 getClient() {
        assert (this.field_22787 != null);
        return this.field_22787;
    }

    public static enum Page {
        FINDER,
        SETTINGS,
        SIGN;

    }
}

