/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.tictactoe.BoardIndex;
import de.hysky.skyblocker.utils.tictactoe.TicTacToeUtils;
import java.util.List;
import net.minecraft.class_1533;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TicTacToe
extends DungeonPuzzle {
    private static final Logger LOGGER = LoggerFactory.getLogger(TicTacToe.class);
    private static final float[] RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};
    private static final float[] GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
    private static final TicTacToe INSTANCE = new TicTacToe();
    private static class_238 nextBestMoveToMake = null;

    private TicTacToe() {
        super("tic-tac-toe", "tic-tac-toe-1");
    }

    @Init
    public static void init() {
    }

    @Override
    public void tick(class_310 client) {
        if (!this.shouldSolve()) {
            return;
        }
        nextBestMoveToMake = null;
        if (client.field_1687 == null || client.field_1724 == null || !Utils.isInDungeons()) {
            return;
        }
        class_238 searchBox = new class_238(client.field_1724.method_23317() - 21.0, client.field_1724.method_23318() - 21.0, client.field_1724.method_23321() - 21.0, client.field_1724.method_23317() + 21.0, client.field_1724.method_23318() + 21.0, client.field_1724.method_23321() + 21.0);
        List itemFramesThatHoldMaps = client.field_1687.method_8390(class_1533.class, searchBox, class_1533::method_43273);
        try {
            if (itemFramesThatHoldMaps.size() != 9 && (itemFramesThatHoldMaps.size() & 1) == 1) {
                char[][] board = new char[3][3];
                for (class_1533 itemFrame : itemFramesThatHoldMaps) {
                    int column;
                    class_22 mapState = client.field_1687.method_17891(itemFrame.method_43272(itemFrame.method_6940()));
                    if (mapState == null) continue;
                    class_2338 relative = DungeonManager.getCurrentRoom().actualToRelative(itemFrame.method_24515());
                    int y = relative.method_10264();
                    int row = switch (y) {
                        case 72 -> 0;
                        case 71 -> 1;
                        case 70 -> 2;
                        default -> -1;
                    };
                    int z = relative.method_10260();
                    switch (z) {
                        case 17: {
                            int n = 0;
                            break;
                        }
                        case 16: {
                            int n = 1;
                            break;
                        }
                        case 15: {
                            int n = 2;
                            break;
                        }
                        default: {
                            int n = column = -1;
                        }
                    }
                    if (row == -1 || column == -1) continue;
                    int middleColor = mapState.field_122[8256] & 0xFF;
                    if (middleColor == 114) {
                        board[row][column] = 88;
                        continue;
                    }
                    if (middleColor != 33) continue;
                    board[row][column] = 79;
                }
                BoardIndex bestMove = TicTacToeUtils.getBestMove(board);
                double nextX = 8.0;
                double nextY = 72 - bestMove.row();
                double nextZ = 17 - bestMove.column();
                class_2338 nextPos = DungeonManager.getCurrentRoom().relativeToActual(class_2338.method_49637((double)nextX, (double)nextY, (double)nextZ));
                nextBestMoveToMake = RenderHelper.getBlockBoundingBox(client.field_1687, nextPos);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Tic Tac Toe] Encountered an exception while determining a tic tac toe solution!", (Throwable)e);
        }
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        try {
            if (SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveTicTacToe && nextBestMoveToMake != null) {
                collector.submitFilledBox(nextBestMoveToMake, GREEN_COLOR_COMPONENTS, 0.5f, false);
                collector.submitOutlinedBox(nextBestMoveToMake, GREEN_COLOR_COMPONENTS, 5.0f, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Tic Tac Toe] Encountered an exception while rendering the tic tac toe solution!", (Throwable)e);
        }
    }
}

