/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder;

import de.hysky.skyblocker.skyblock.dungeon.puzzle.boulder.BoulderObject;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class BoulderBoard {
    private final int height;
    private final int width;
    private final BoulderObject[][] grid;

    public BoulderBoard(int height, int width, BoulderObject target) {
        this.height = height;
        this.width = width;
        this.grid = new BoulderObject[height][width];
        int offsetX = target.x() - 23;
        int y = 65;
        for (int z = 0; z < width; ++z) {
            this.grid[0][z] = z == width / 2 ? target : new BoulderObject(offsetX, y, z, "B");
            this.grid[height - 1][z] = new BoulderObject(24 - 3 * z, y, 6, "P");
        }
    }

    public BoulderObject getObjectAtPosition(int x, int y) {
        return this.isValidPosition(x, y) ? this.grid[x][y] : null;
    }

    public class_2338 getObject3DPosition(int x, int y) {
        BoulderObject object = this.getObjectAtPosition(x, y);
        return object != null ? object.get3DPosition().method_30513(class_2350.class_2351.field_11052, -1) : null;
    }

    public void placeObject(int x, int y, BoulderObject object) {
        this.grid[x][y] = object;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    private boolean isValidPosition(int x, int y) {
        return x >= 0 && y >= 0 && x < this.height && y < this.width;
    }

    public char[][] getBoardCharArray() {
        char[][] boardCharArray = new char[this.height][this.width];
        for (int x = 0; x < this.height; ++x) {
            for (int y = 0; y < this.width; ++y) {
                BoulderObject boulderObject = this.grid[x][y];
                boardCharArray[x][y] = boulderObject != null ? (int)boulderObject.type().charAt(0) : 46;
            }
        }
        return boardCharArray;
    }

    public String boardToString() {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < this.height; ++x) {
            for (int y = 0; y < this.width; ++y) {
                BoulderObject boulderObject = this.grid[x][y];
                String displayChar = boulderObject != null ? boulderObject.type() : ".";
                sb.append(displayChar);
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

