/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.terminal;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.terminal.TerminalSolver;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public final class OrderTerminal
extends SimpleContainerSolver
implements TerminalSolver {
    private static final int PANES_NUM = 14;
    private int[] orderedSlots;
    private int currentNum = Integer.MAX_VALUE;

    public OrderTerminal() {
        super("^Click in order!$");
    }

    @Override
    public boolean isEnabled() {
        this.orderedSlots = null;
        this.currentNum = 0;
        return SkyblockerConfigManager.get().dungeons.terminals.solveOrder;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        if (this.orderedSlots == null && !this.orderSlots(slots)) {
            return Collections.emptyList();
        }
        while (this.currentNum < 14 && slots.containsKey(this.orderedSlots[this.currentNum]) && class_1802.field_8581.equals(((class_1799)slots.get(this.orderedSlots[this.currentNum])).method_7909())) {
            ++this.currentNum;
        }
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>(3);
        int last = Integer.min(3, 14 - this.currentNum);
        for (int i = 0; i < last; ++i) {
            highlights.add(new ColorHighlight(this.orderedSlots[this.currentNum + i], 224 - 64 * i << 24 | 0x400000 | 0x6000 | 0xFF));
        }
        return highlights;
    }

    public boolean orderSlots(Int2ObjectMap<class_1799> slots) {
        ContainerSolver.trimEdges(slots, 4);
        this.orderedSlots = new int[14];
        for (Int2ObjectMap.Entry slot : slots.int2ObjectEntrySet()) {
            if (class_1802.field_8162.equals(((class_1799)slot.getValue()).method_7909())) {
                this.orderedSlots = null;
                return false;
            }
            this.orderedSlots[((class_1799)slot.getValue()).method_7947() - 1] = slot.getIntKey();
        }
        this.currentNum = 0;
        return true;
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (!stack.method_31574(class_1802.field_8879) || stack.method_7947() != this.currentNum + 1) {
            return this.shouldBlockIncorrectClicks();
        }
        return false;
    }
}

