/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dwarven.fossil;

import de.hysky.skyblocker.skyblock.dwarven.fossil.FossilTypes;
import de.hysky.skyblocker.skyblock.dwarven.fossil.Structures;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class FossilCalculations {
    protected static final List<Structures.permutation> POSSIBLE_STATES = FossilCalculations.getAllPossibleStates();
    private static final int EXCAVATOR_WIDTH = 9;
    private static final int EXCAVATOR_HEIGHT = 6;
    protected static int permutations = -1;
    protected static int minimumTiles;
    protected static String fossilName;

    protected static double[] getFossilChance(Structures.TileGrid tiles, String percentage) {
        int[] total = new int[54];
        minimumTiles = 54;
        AtomicInteger fossilCount = new AtomicInteger();
        Arrays.stream(tiles.state()).forEach(row -> Arrays.stream(row).forEach(tile -> {
            if (tile.equals((Object)Structures.TileState.FOSSIL)) {
                fossilCount.getAndIncrement();
            }
        }));
        ArrayList<Structures.permutation> validStates = new ArrayList<Structures.permutation>();
        for (Structures.permutation state : POSSIBLE_STATES) {
            if (!state.isValid(tiles, percentage)) continue;
            validStates.add(state);
            int min = state.type().tileCount - fossilCount.get();
            if (min >= minimumTiles) continue;
            minimumTiles = min;
        }
        permutations = validStates.size();
        if (validStates.isEmpty()) {
            fossilName = null;
        } else {
            fossilName = ((Structures.permutation)validStates.getFirst()).type().name;
            for (Structures.permutation fossil : validStates) {
                if (fossil.type().name.equals(fossilName)) continue;
                fossilName = null;
                break;
            }
        }
        int index = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                if (tiles.getSlot(x2, y) == Structures.TileState.UNKNOWN) {
                    for (Structures.permutation state : validStates) {
                        if (!state.isFossilCollision(x2, y)) continue;
                        int n = index;
                        total[n] = total[n] + 1;
                    }
                }
                ++index;
            }
        }
        return Arrays.stream(total).mapToDouble(x -> (double)x / (double)validStates.size()).toArray();
    }

    protected static Structures.TileGrid convertItemsToTiles(Int2ObjectMap<class_1799> currentState) {
        Structures.TileGrid output = new Structures.TileGrid(new Structures.TileState[6][9]);
        int index = 0;
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 9; ++x) {
                class_1792 item = ((class_1799)currentState.get(index)).method_7909();
                if (item == class_1802.field_8736) {
                    output.updateSlot(x, y, Structures.TileState.FOSSIL);
                } else if (item == class_1802.field_8501) {
                    output.updateSlot(x, y, Structures.TileState.UNKNOWN);
                } else {
                    output.updateSlot(x, y, Structures.TileState.EMPTY);
                }
                ++index;
            }
        }
        return output;
    }

    protected static List<Structures.permutation> getAllPossibleStates() {
        ArrayList<Structures.permutation> output = new ArrayList<Structures.permutation>();
        for (FossilTypes fossil : FossilTypes.values()) {
            for (Structures.TransformationOptions rotation : fossil.rotations) {
                Structures.TileGrid grid = FossilCalculations.transformGrid(new Structures.TileGrid(fossil.grid), rotation);
                int maxXOffset = 9 - grid.width();
                int maxYOffset = 6 - grid.height();
                for (int x = 0; x <= maxXOffset; ++x) {
                    for (int y = 0; y <= maxYOffset; ++y) {
                        output.add(new Structures.permutation(fossil, grid, x, y));
                    }
                }
            }
        }
        return output;
    }

    private static Structures.TileGrid transformGrid(Structures.TileGrid grid, Structures.TransformationOptions transformation) {
        switch (transformation) {
            case ROTATED_90: {
                return FossilCalculations.rotateGrid(grid, 90);
            }
            case ROTATED_180: {
                return FossilCalculations.rotateGrid(grid, 180);
            }
            case ROTATED_270: {
                return FossilCalculations.rotateGrid(grid, 270);
            }
            case FLIP_ROTATED_0: {
                return FossilCalculations.flipGrid(grid);
            }
            case FLIP_ROTATED_90: {
                return FossilCalculations.rotateGrid(FossilCalculations.flipGrid(grid), 90);
            }
            case FLIP_ROTATED_180: {
                return FossilCalculations.rotateGrid(FossilCalculations.flipGrid(grid), 180);
            }
            case FLIP_ROTATED_270: {
                return FossilCalculations.rotateGrid(FossilCalculations.flipGrid(grid), 270);
            }
        }
        return grid;
    }

    protected static Structures.TileGrid flipGrid(Structures.TileGrid grid) {
        Structures.TileGrid output = new Structures.TileGrid(new Structures.TileState[grid.height()][grid.width()]);
        for (int x = 0; x < grid.width(); ++x) {
            for (int y = 0; y < grid.height(); ++y) {
                output.updateSlot(x, y, grid.getSlot(x, grid.height() - 1 - y));
            }
        }
        return output;
    }

    protected static Structures.TileGrid rotateGrid(Structures.TileGrid grid, int rotation) {
        int startingWidth = grid.width() - 1;
        int startingHeight = grid.height() - 1;
        switch (rotation) {
            case 90: {
                Structures.TileGrid output = new Structures.TileGrid(new Structures.TileState[grid.width()][grid.height()]);
                for (int originalX = 0; originalX < grid.width(); ++originalX) {
                    for (int originalY = 0; originalY < grid.height(); ++originalY) {
                        output.updateSlot(startingHeight - originalY, originalX, grid.getSlot(originalX, originalY));
                    }
                }
                return output;
            }
            case 180: {
                Structures.TileGrid output = new Structures.TileGrid(new Structures.TileState[grid.height()][grid.width()]);
                for (int x = 0; x < grid.width(); ++x) {
                    for (int y = 0; y < grid.height(); ++y) {
                        output.updateSlot(startingWidth - x, startingHeight - y, grid.getSlot(x, y));
                    }
                }
                return output;
            }
            case 270: {
                Structures.TileGrid output = new Structures.TileGrid(new Structures.TileState[grid.width()][grid.height()]);
                for (int originalX = 0; originalX < grid.width(); ++originalX) {
                    for (int originalY = 0; originalY < grid.height(); ++originalY) {
                        output.updateSlot(originalY, startingWidth - originalX, grid.getSlot(originalX, originalY));
                    }
                }
                return output;
            }
        }
        return grid;
    }
}

