/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.end;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.SeenWaypoint;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class EnderNodes {
    private static final class_310 client = class_310.method_1551();
    private static final Map<class_2338, EnderNode> enderNodes = new HashMap<class_2338, EnderNode>();

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(EnderNodes::update, 20);
        WorldRenderExtractionCallback.EVENT.register(EnderNodes::extractRendering);
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            enderNodes.remove(pos);
            return class_1269.field_5811;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> EnderNodes.reset());
        ParticleEvents.FROM_SERVER.register(EnderNodes::onParticle);
    }

    private static void onParticle(class_2675 packet) {
        class_2350 direction;
        class_2338 pos;
        if (!EnderNodes.shouldProcess()) {
            return;
        }
        class_2396 particleType = packet.method_11551().method_10295();
        if (!class_2398.field_11214.method_29140().equals(particleType) && !class_2398.field_11249.method_29140().equals(particleType)) {
            return;
        }
        double x = packet.method_11544();
        double y = packet.method_11547();
        double z = packet.method_11546();
        double xFrac = class_3532.method_15367((double)x, (double)1.0);
        double yFrac = class_3532.method_15367((double)y, (double)1.0);
        double zFrac = class_3532.method_15367((double)z, (double)1.0);
        if (yFrac == 0.25) {
            pos = class_2338.method_49637((double)x, (double)(y - 1.0), (double)z);
            direction = class_2350.field_11036;
        } else if (yFrac == 0.75) {
            pos = class_2338.method_49637((double)x, (double)(y + 1.0), (double)z);
            direction = class_2350.field_11033;
        } else if (xFrac == 0.25) {
            pos = class_2338.method_49637((double)(x - 1.0), (double)y, (double)z);
            direction = class_2350.field_11034;
        } else if (xFrac == 0.75) {
            pos = class_2338.method_49637((double)(x + 1.0), (double)y, (double)z);
            direction = class_2350.field_11039;
        } else if (zFrac == 0.25) {
            pos = class_2338.method_49637((double)x, (double)y, (double)(z - 1.0));
            direction = class_2350.field_11035;
        } else if (zFrac == 0.75) {
            pos = class_2338.method_49637((double)x, (double)y, (double)(z + 1.0));
            direction = class_2350.field_11043;
        } else {
            return;
        }
        EnderNode enderNode = enderNodes.computeIfAbsent(pos, EnderNode::new);
        IntIntPair particles = enderNode.particles.get(direction);
        if (class_2398.field_11214.method_29140().equals(particleType)) {
            particles.left(particles.leftInt() + 1);
        } else if (class_2398.field_11249.method_29140().equals(particleType)) {
            particles.right(particles.rightInt() + 1);
        }
    }

    private static void update() {
        if (EnderNodes.shouldProcess()) {
            for (EnderNode enderNode : enderNodes.values()) {
                enderNode.updateWaypoint();
            }
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (EnderNodes.shouldProcess()) {
            for (EnderNode enderNode : enderNodes.values()) {
                if (!enderNode.shouldRender()) continue;
                enderNode.extractRendering(collector);
            }
        }
    }

    private static boolean shouldProcess() {
        return SkyblockerConfigManager.get().otherLocations.end.enableEnderNodeHelper && Utils.isInTheEnd();
    }

    private static void reset() {
        enderNodes.clear();
    }

    public static class EnderNode
    extends SeenWaypoint {
        private final Map<class_2350, IntIntPair> particles = Map.of(class_2350.field_11036, new IntIntMutablePair(0, 0), class_2350.field_11033, new IntIntMutablePair(0, 0), class_2350.field_11034, new IntIntMutablePair(0, 0), class_2350.field_11039, new IntIntMutablePair(0, 0), class_2350.field_11035, new IntIntMutablePair(0, 0), class_2350.field_11043, new IntIntMutablePair(0, 0));
        private long lastConfirmed;

        private EnderNode(class_2338 pos) {
            super(pos, () -> SkyblockerConfigManager.get().otherLocations.end.enderNodeWaypointType, ColorUtils.getFloatComponents(class_1767.field_7955));
        }

        private void updateWaypoint() {
            this.tick(client);
            long currentTimeMillis = System.currentTimeMillis();
            if (this.lastConfirmed + 2000L > currentTimeMillis || EnderNodes.client.field_1687 == null || !this.particles.entrySet().stream().allMatch(entry -> ((IntIntPair)entry.getValue()).leftInt() >= 5 && ((IntIntPair)entry.getValue()).rightInt() >= 5 || !EnderNodes.client.field_1687.method_8320(this.pos.method_10093((class_2350)entry.getKey())).method_26215())) {
                return;
            }
            this.lastConfirmed = currentTimeMillis;
            for (Map.Entry<class_2350, IntIntPair> entry2 : this.particles.entrySet()) {
                entry2.getValue().left(0);
                entry2.getValue().right(0);
            }
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() && this.lastConfirmed + 5000L > System.currentTimeMillis();
        }
    }
}

