/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.experiment;

import de.hysky.skyblocker.config.configs.HelperConfig;
import de.hysky.skyblocker.skyblock.experiment.ExperimentSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_476;

public final class ChronomatronSolver
extends ExperimentSolver
implements class_1712 {
    public static final Object2ObjectMap<class_1792, class_1792> TERRACOTTA_TO_GLASS = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectArrayMap((Object[])new class_1792[]{class_1802.field_8353, class_1802.field_8043, class_1802.field_8385, class_1802.field_8672, class_1802.field_8798, class_1802.field_8821, class_1802.field_8717, class_1802.field_8455, class_1802.field_8715, class_1802.field_8853}, (Object[])new class_1792[]{class_1802.field_8636, class_1802.field_8393, class_1802.field_8095, class_1802.field_8340, class_1802.field_8734, class_1802.field_8685, class_1802.field_8869, class_1802.field_8126, class_1802.field_8838, class_1802.field_8770}));
    private class_476 screen;
    private final List<class_1792> chronomatronSlots = new ArrayList<class_1792>();
    private int chronomatronChainLengthCount;
    private int chronomatronCurrentSlot;
    private int chronomatronCurrentOrdinal;
    private boolean isSingleRow;

    public ChronomatronSolver() {
        super("^Chronomatron \\(\\w+\\)$");
    }

    @Override
    protected boolean isEnabled(HelperConfig.Experiments experimentsConfig) {
        return experimentsConfig.enableChronomatronSolver;
    }

    @Override
    protected void tick(class_476 screen) {
    }

    public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
        if (slotId < 17 || slotId > (this.isSingleRow ? 25 : 34) && slotId != 49) {
            return;
        }
        switch (this.getState()) {
            case REMEMBER: {
                if (slotId == 49) break;
                if (this.chronomatronCurrentSlot == 0) {
                    if (!stack.method_7958()) break;
                    if (this.chronomatronSlots.size() <= this.chronomatronChainLengthCount) {
                        this.chronomatronSlots.add((class_1792)TERRACOTTA_TO_GLASS.get((Object)stack.method_7909()));
                        this.setState(ExperimentSolver.State.WAIT);
                    } else {
                        ++this.chronomatronChainLengthCount;
                    }
                    this.chronomatronCurrentSlot = slotId;
                    break;
                }
                if (this.chronomatronCurrentSlot != slotId || stack.method_7958()) break;
                this.chronomatronCurrentSlot = 0;
                break;
            }
            case WAIT: {
                if (slotId != 49 || !stack.method_7964().getString().startsWith("Timer: ")) break;
                this.setState(ExperimentSolver.State.SHOW);
                break;
            }
            case END: {
                String name = stack.method_7964().getString();
                if (slotId != 49 || name.startsWith("Timer: ")) break;
                if (name.equals("Remember the pattern!")) {
                    this.chronomatronChainLengthCount = 0;
                    this.chronomatronCurrentOrdinal = 0;
                    this.setState(ExperimentSolver.State.REMEMBER);
                    break;
                }
                this.reset();
            }
        }
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        if (this.getState() == ExperimentSolver.State.SHOW && this.chronomatronSlots.size() > this.chronomatronCurrentOrdinal) {
            for (Int2ObjectMap.Entry indexStack : slots.int2ObjectEntrySet()) {
                class_1792 item;
                int index = indexStack.getIntKey();
                class_1799 stack = (class_1799)indexStack.getValue();
                if (!stack.method_31574(item = this.chronomatronSlots.get(this.chronomatronCurrentOrdinal)) && TERRACOTTA_TO_GLASS.get((Object)stack.method_7909()) != item) continue;
                highlights.add(ColorHighlight.green(index));
            }
        }
        return highlights;
    }

    @Override
    public boolean onClickSlot(int slot, class_1799 stack, int screenId, int button) {
        if (this.getState() == ExperimentSolver.State.SHOW) {
            class_1792 item = this.chronomatronSlots.get(this.chronomatronCurrentOrdinal);
            if (stack.method_31574(item) || TERRACOTTA_TO_GLASS.get((Object)stack.method_7909()) == item) {
                if (++this.chronomatronCurrentOrdinal >= this.chronomatronSlots.size()) {
                    this.setState(ExperimentSolver.State.END);
                }
            } else {
                return this.shouldBlockIncorrectClicks();
            }
        }
        return super.onClickSlot(slot, stack, screenId, button);
    }

    @Override
    public void start(class_476 screen) {
        super.start(screen);
        this.screen = screen;
        ((class_1707)screen.method_17577()).method_7596((class_1712)this);
        String title = screen.method_25440().getString();
        this.isSingleRow = title.endsWith("(High)") || title.endsWith("(Grand)") || title.endsWith("(Supreme)");
    }

    @Override
    public void reset() {
        this.chronomatronSlots.clear();
        this.chronomatronChainLengthCount = 0;
        this.chronomatronCurrentSlot = 0;
        this.chronomatronCurrentOrdinal = 0;
        if (this.screen != null) {
            ((class_1707)this.screen.method_17577()).method_7603((class_1712)this);
        }
        super.reset();
    }

    public void method_7633(class_1703 handler, int property, int value) {
    }
}

