/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.fancybars;

import de.hysky.skyblocker.skyblock.fancybars.FancyStatusBars;
import de.hysky.skyblocker.skyblock.fancybars.StatusBar;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BarPositioner {
    private final Map<BarAnchor, LinkedList<LinkedList<StatusBar>>> map = new EnumMap<BarAnchor, LinkedList<LinkedList<StatusBar>>>(BarAnchor.class);

    public BarPositioner() {
        for (BarAnchor value : BarAnchor.values()) {
            this.map.put(value, new LinkedList());
        }
    }

    public int getRowCount(@NotNull BarAnchor barAnchor) {
        return this.map.get((Object)barAnchor).size();
    }

    public void addRow(@NotNull BarAnchor barAnchor) {
        this.map.get((Object)barAnchor).add(new LinkedList());
    }

    public void addRow(@NotNull BarAnchor barAnchor, int row) {
        LinkedList<LinkedList<StatusBar>> rows = this.map.get((Object)barAnchor);
        for (int i = row; i < rows.size(); ++i) {
            for (StatusBar bar : rows.get(i)) {
                ++bar.gridY;
            }
        }
        rows.add(row, new LinkedList());
    }

    public void addBar(@NotNull BarAnchor barAnchor, int row, StatusBar bar) {
        LinkedList<StatusBar> statusBars = this.map.get((Object)barAnchor).get(row);
        statusBars.add(bar);
        bar.gridY = row;
        bar.gridX = statusBars.lastIndexOf(bar);
        bar.anchor = barAnchor;
    }

    public void addBar(@NotNull BarAnchor barAnchor, int row, int x, StatusBar bar) {
        LinkedList<StatusBar> statusBars = this.map.get((Object)barAnchor).get(row);
        for (int i = x; i < statusBars.size(); ++i) {
            ++statusBars.get((int)i).gridX;
        }
        statusBars.add(x, bar);
        bar.gridY = row;
        bar.gridX = statusBars.indexOf(bar);
        bar.anchor = barAnchor;
    }

    public void removeBar(@NotNull BarAnchor barAnchor, int row, int x) {
        LinkedList<StatusBar> statusBars = this.map.get((Object)barAnchor).get(row);
        StatusBar remove = statusBars.remove(x);
        remove.anchor = null;
        for (int i = x; i < statusBars.size(); ++i) {
            --statusBars.get((int)i).gridX;
        }
        if (statusBars.isEmpty()) {
            this.removeRow(barAnchor, row);
        }
    }

    public void removeBar(@NotNull BarAnchor barAnchor, int row, StatusBar bar) {
        LinkedList<StatusBar> barRow = this.map.get((Object)barAnchor).get(row);
        int x = barRow.indexOf(bar);
        if (x < 0) {
            return;
        }
        barRow.remove(bar);
        bar.anchor = null;
        for (int i = x; i < barRow.size(); ++i) {
            --barRow.get((int)i).gridX;
        }
        if (barRow.isEmpty()) {
            this.removeRow(barAnchor, row);
        }
    }

    public void removeRow(@NotNull BarAnchor barAnchor, int row) {
        LinkedList<StatusBar> barRow = this.map.get((Object)barAnchor).get(row);
        if (!barRow.isEmpty()) {
            throw new IllegalStateException("Can't remove a non-empty row (" + String.valueOf((Object)barAnchor) + "," + row + ")");
        }
        this.map.get((Object)barAnchor).remove(row);
        for (int i = row; i < this.map.get((Object)barAnchor).size(); ++i) {
            for (StatusBar statusBar : this.map.get((Object)barAnchor).get(i)) {
                --statusBar.gridY;
            }
        }
    }

    public LinkedList<StatusBar> getRow(@NotNull BarAnchor barAnchor, int row) {
        return this.map.get((Object)barAnchor).get(row);
    }

    public StatusBar getBar(@NotNull BarAnchor barAnchor, int row, int x) {
        return this.map.get((Object)barAnchor).get(row).get(x);
    }

    public boolean hasNeighbor(@NotNull BarAnchor barAnchor, int row, int x, boolean right) {
        LinkedList<StatusBar> statusBars = this.map.get((Object)barAnchor).get(row);
        if (barAnchor.isRight()) {
            return right && x < statusBars.size() - 1 || !right && x > 0;
        }
        return right && x > 0 || !right && x < statusBars.size() - 1;
    }

    public void clear() {
        this.map.replaceAll((barAnchor, rows) -> new LinkedList());
    }

    public static enum BarAnchor {
        HOTBAR_LEFT(true, false, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth / 2 - 91 - 2, scaledHeight - 5), SizeRule.freeSize(25, 2, 6)),
        HOTBAR_RIGHT(true, true, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth / 2 + 91 + 2, scaledHeight - 5), SizeRule.freeSize(25, 2, 6)),
        HOTBAR_TOP(true, true, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth / 2 - 91, scaledHeight - (FancyStatusBars.isExperienceFancyBarEnabled() ? 23 : 35)), SizeRule.targetSize(12, 182, 2), anchorPosition -> new class_8030(anchorPosition.comp_1193(), anchorPosition.comp_1194() - 20, 182, 20)),
        SCREEN_TOP_LEFT(false, true, (scaledWidth, scaledHeight) -> new class_8029(5, 5), SizeRule.freeSize(25, 2, 6)),
        SCREEN_TOP_RIGHT(false, false, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth - 5, 5), SizeRule.freeSize(25, 2, 6)),
        SCREEN_BOTTOM_LEFT(true, true, (scaledWidth, scaledHeight) -> new class_8029(5, scaledHeight - 5), SizeRule.freeSize(25, 2, 6)),
        SCREEN_BOTTOM_RIGHT(true, false, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth - 5, scaledHeight - 5), SizeRule.freeSize(25, 2, 6)),
        SCREEN_CENTER_LEFT(false, false, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth / 2 - 8, scaledHeight / 2 - 4), SizeRule.freeSize(15, 3, 8)),
        SCREEN_CENTER_RIGHT(false, true, (scaledWidth, scaledHeight) -> new class_8029(scaledWidth / 2 + 8, scaledHeight / 2 - 4), SizeRule.freeSize(15, 3, 8));

        private final AnchorPositionProvider positionProvider;
        private final AnchorHitboxProvider hitboxProvider;
        private final boolean up;
        private final boolean right;
        private final SizeRule sizeRule;
        private static final List<BarAnchor> cached;

        private BarAnchor(boolean up, boolean right, AnchorPositionProvider positionProvider, SizeRule sizeRule, AnchorHitboxProvider hitboxProvider) {
            this.positionProvider = positionProvider;
            this.up = up;
            this.right = right;
            this.hitboxProvider = hitboxProvider;
            this.sizeRule = sizeRule;
        }

        private BarAnchor(boolean up, boolean right, AnchorPositionProvider positionProvider, SizeRule sizeRule) {
            this(up, right, positionProvider, sizeRule, anchorPosition -> new class_8030(anchorPosition.comp_1193() - (right ? 0 : 20), anchorPosition.comp_1194() - (up ? 20 : 0), 20, 20));
        }

        public class_8029 getAnchorPosition(int scaledWidth, int scaledHeight) {
            return this.positionProvider.getPosition(scaledWidth, scaledHeight);
        }

        public class_8030 getAnchorHitbox(class_8029 anchorPosition) {
            return this.hitboxProvider.getHitbox(anchorPosition);
        }

        public boolean isUp() {
            return this.up;
        }

        public boolean isRight() {
            return this.right;
        }

        public SizeRule getSizeRule() {
            return this.sizeRule;
        }

        public static List<BarAnchor> allAnchors() {
            return cached;
        }

        static {
            cached = List.of(BarAnchor.values());
        }
    }

    @FunctionalInterface
    static interface AnchorHitboxProvider {
        public class_8030 getHitbox(class_8029 var1);
    }

    @FunctionalInterface
    static interface AnchorPositionProvider {
        public class_8029 getPosition(int var1, int var2);
    }

    public record BarLocation(@Nullable BarAnchor barAnchor, int x, int y) {
        public static final BarLocation NULL = new BarLocation(null, -1, -1);

        public static BarLocation of(StatusBar bar) {
            return new BarLocation(bar.anchor, bar.gridX, bar.gridY);
        }

        public boolean equals(BarAnchor barAnchor, int x, int y) {
            return x == this.x && y == this.y && barAnchor == this.barAnchor;
        }
    }

    public record SizeRule(boolean isTargetSize, int targetSize, int totalWidth, int widthPerSize, int minSize, int maxSize) {
        public static SizeRule freeSize(int widthPerSize, int minSize, int maxSize) {
            return new SizeRule(false, -1, -1, widthPerSize, minSize, maxSize);
        }

        public static SizeRule targetSize(int targetSize, int totalWidth, int minSize) {
            return new SizeRule(true, targetSize, totalWidth, -1, minSize, targetSize);
        }
    }
}

