/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.background;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.item.background.ColoredItemBackground;
import de.hysky.skyblocker.skyblock.item.background.adders.ItemRarityBackground;
import de.hysky.skyblocker.skyblock.item.background.adders.JacobMedalBackground;
import de.hysky.skyblocker.skyblock.item.background.adders.LegacyAttributeBackground;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1799;
import net.minecraft.class_332;

public class ItemBackgroundManager {
    private static final List<ColoredItemBackground<?>> BACKGROUNDS = List.of(new ItemRarityBackground(), new JacobMedalBackground(), new LegacyAttributeBackground());

    @Init
    public static void init() {
        for (ColoredItemBackground<?> background : BACKGROUNDS) {
            Scheduler.INSTANCE.scheduleCyclic(background::clearCache, 6000);
        }
        ScreenEvents.BEFORE_INIT.register((client, screen, width, height) -> {
            String title = screen.method_25440().getString();
            for (ColoredItemBackground<?> background : BACKGROUNDS) {
                background.onScreenChange(title, screen);
            }
        });
    }

    public static void drawBackgrounds(class_1799 stack, class_332 context, int x, int y) {
        for (ColoredItemBackground<?> background : BACKGROUNDS) {
            if (!background.isEnabled()) continue;
            background.tryDraw(stack, context, x, y);
        }
    }
}

