/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.custom.screen.name;

import com.google.common.collect.ImmutableList;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.ConfigUtils;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.ColorPopup;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.visitor.GetClickedPositionVisitor;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.visitor.GetRenderWidthVisitor;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.visitor.GetStyleVisitor;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.visitor.InsertTextVisitor;
import de.hysky.skyblocker.skyblock.item.custom.screen.name.visitor.SetStyleVisitor;
import de.hysky.skyblocker.utils.OkLabColor;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_10799;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_9017;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class CustomizeNameWidget
extends class_9017 {
    private static final class_2960 INNER_SPACE_TEXTURE = SkyblockerMod.id("menu_inner_space");
    private static final int PADDING = 3;
    private final class_310 client = class_310.method_1551();
    private final class_327 textRenderer;
    private String uuid;
    private class_2561 text;
    private String textString;
    private final TextField textField;
    private final class_7842 previewWidget;
    private final FormattingButton[] formattingButtons;
    private final List<class_339> widgets;
    private final class_7845 grid;
    private int selectionStart;
    private int selectionEnd;
    @Nullable
    private class_2583 insertAs;

    public CustomizeNameWidget(class_437 parent) {
        super(0, 0, 0, 0, (class_2561)class_2561.method_43470((String)"Customize Item Name"));
        int i;
        this.textRenderer = this.client.field_1772;
        this.uuid = "";
        this.text = class_2561.method_43473();
        this.textString = "";
        this.grid = new class_7845();
        ImmutableList.Builder builder = ImmutableList.builder();
        this.textField = (TextField)this.grid.method_46453((class_8021)new TextField(), 1, 0, 1, 20);
        builder.add((Object)this.textField);
        this.formattingButtons = new FormattingButton[]{new FormattingButton("B", class_124.field_1067, class_2583::method_10984), new FormattingButton("I", class_124.field_1056, class_2583::method_10966), new FormattingButton("U", class_124.field_1073, class_2583::method_10965), new FormattingButton("S", class_124.field_1055, class_2583::method_10986), new FormattingButton("|||", class_124.field_1051, class_2583::method_10987)};
        for (i = 0; i < this.formattingButtons.length; ++i) {
            FormattingButton button = this.formattingButtons[i];
            builder.add((Object)((class_339)this.grid.method_46452((class_8021)button, 0, i)));
        }
        i = 0;
        for (class_124 formatting : class_124.values()) {
            if (!formatting.method_543()) continue;
            builder.add((Object)((class_339)this.grid.method_46452((class_8021)new ColorButton(formatting), 2, i++)));
        }
        builder.add((Object)((class_339)this.grid.method_46453((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.screen.customColor"), b -> this.client.method_1507((class_437)ColorPopup.create(parent, color -> this.setStyle(class_2583.field_24360.method_36139(color))))).method_46437(48, 16).method_46431(), 2, 17, 1, 3)));
        builder.add((Object)((class_339)this.grid.method_46453((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.screen.gradientColor"), b -> this.client.method_1507((class_437)ColorPopup.createGradient(parent, this::createGradient))).method_46437(48, 16).method_46431(), 3, 17, 1, 3)));
        Objects.requireNonNull(this.textRenderer);
        builder.add((Object)((class_339)this.grid.method_46454((class_8021)new class_7842(320, 9, (class_2561)class_2561.method_43471((String)"skyblocker.customItemNames.screen.howToRemove").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), this.textRenderer).method_48596(), 4, 0, 1, 20, class_7847.method_46481().method_46471(2))));
        Objects.requireNonNull(this.textRenderer);
        this.previewWidget = (class_7842)this.grid.method_46454((class_8021)new class_7842(320, 9, (class_2561)class_2561.method_43473(), this.textRenderer).method_48597(), 5, 0, 1, 20, class_7847.method_46481().method_46479(2));
        builder.add((Object)this.previewWidget);
        this.widgets = builder.build();
        this.grid.method_48222();
        this.grid.method_48229(this.method_46426() + 3, this.method_46427() + 3);
        this.method_55445(this.grid.method_25368() + 6, this.grid.method_25364() + 6);
        this.selectionStart = this.selectionEnd = this.textString.length();
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.grid.method_46421(this.method_46426() + 3);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.grid.method_46419(this.method_46427() + 3);
    }

    public void setItem(class_1799 stack) {
        this.uuid = stack.getUuid();
        this.setText((class_2561)stack.method_7964().method_27661());
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        context.method_52706(class_10799.field_56883, INNER_SPACE_TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        if (Debug.debugEnabled()) {
            context.method_27535(this.textRenderer, (class_2561)class_2561.method_43470((String)("Selection Start: " + this.selectionStart + ", Selection End: " + this.selectionEnd)), this.method_46426(), this.method_55443(), -1);
            context.method_27535(this.textRenderer, (class_2561)class_2561.method_43470((String)("Insert Style: " + (this.insertAs == null ? "null" : this.insertAs.toString()))), this.method_46426(), this.method_55443() + 10, -1);
        }
        for (class_339 widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, deltaTicks);
        }
    }

    private void createGradient(int startColor, int endColor) {
        int previousSelectionStart = this.selectionStart;
        int previousSelectionEnd = this.selectionEnd;
        int selStart = Math.min(this.selectionStart, this.selectionEnd);
        int selSize = Math.abs(this.selectionEnd - this.selectionStart);
        if (selSize == 0) {
            return;
        }
        if (selSize == 1) {
            this.setStyle(class_2583.field_24360.method_36139(startColor));
        } else {
            for (int i = 0; i < selSize; ++i) {
                this.selectionStart = selStart + i;
                this.selectionEnd = selStart + i + 1;
                int color = OkLabColor.interpolate(startColor, endColor, (float)i / (float)(selSize - 1));
                this.setStyle(class_2583.field_24360.method_36139(color));
            }
        }
        this.selectionStart = previousSelectionStart;
        this.selectionEnd = previousSelectionEnd;
    }

    private void setStyle(class_2583 style) {
        if (this.selectionStart == this.selectionEnd) {
            this.insertAs = style.method_27702(this.insertAs == null ? class_2583.field_24360 : this.insertAs);
            return;
        }
        SetStyleVisitor setStyleVisitor = new SetStyleVisitor(style, this.selectionStart, this.selectionEnd);
        this.text.method_27658((class_5348.class_5246)setStyleVisitor, class_2583.field_24360);
        this.setText((class_2561)setStyleVisitor.getNewText());
    }

    private void updateStyleButtons() {
        GetStyleVisitor styleVisitor = new GetStyleVisitor(this.selectionStart, this.selectionEnd);
        this.text.method_27658((class_5348.class_5246)styleVisitor, class_2583.field_24360);
        class_2583 style = styleVisitor.getStyle();
        for (FormattingButton button : this.formattingButtons) {
            button.update(style);
        }
    }

    public void setText(class_2561 text) {
        this.text = text;
        this.textString = text.getString();
        if (!this.uuid.isEmpty()) {
            SkyblockerConfig config = SkyblockerConfigManager.get();
            if (this.textString.isBlank()) {
                config.general.customItemNames.remove((Object)this.uuid);
            } else {
                config.general.customItemNames.put((Object)this.uuid, (Object)text.method_27661().method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068)));
            }
        }
        this.previewWidget.method_25355(text);
        if (this.textField != null) {
            this.textField.updateMePrettyPlease = true;
        }
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (super.method_25400(chr, modifiers) || this.textField.method_25370()) {
            return true;
        }
        this.method_25395((class_364)this.textField);
        return this.textField.method_25400(chr, modifiers);
    }

    public void insertText(String str) {
        str = class_3544.method_57180((String)str);
        if (this.textString.isEmpty()) {
            this.setText((class_2561)class_2561.method_43470((String)str).method_10862(this.insertAs != null ? this.insertAs : class_2583.field_24360));
        } else {
            InsertTextVisitor visitor = new InsertTextVisitor(str, this.insertAs, this.selectionStart, this.selectionEnd);
            this.text.method_27658((class_5348.class_5246)visitor, class_2583.field_24360);
            this.setText((class_2561)visitor.getNewText());
            this.insertAs = null;
        }
        this.selectionEnd = this.selectionStart = Math.min(this.selectionStart, this.selectionEnd) + str.length();
        this.updateStyleButtons();
    }

    private void moveCursor(boolean left, boolean shiftHeld, boolean ctrlHeld) {
        if (left && this.selectionStart == 0 || !left && this.selectionStart == this.textString.length()) {
            return;
        }
        this.selectionStart = ctrlHeld ? this.getWordSkipPosition(left) : class_156.method_27761((String)this.textString, (int)this.selectionStart, (int)(left ? -1 : 1));
        if (!shiftHeld) {
            this.selectionEnd = this.selectionStart;
        }
        this.insertAs = null;
        this.updateStyleButtons();
    }

    private void erase(boolean left, boolean ctrlHeld) {
        if (this.selectionStart != this.selectionEnd) {
            this.insertText("");
            return;
        }
        this.moveCursor(left, true, ctrlHeld);
        this.insertText("");
    }

    private int getWordSkipPosition(boolean left) {
        int i;
        if (!left) {
            int l = this.textString.length();
            if ((i = this.textString.indexOf(32, i)) == -1) {
                i = l;
            } else {
                while (i < l && this.textString.charAt(i) == ' ') {
                    ++i;
                }
            }
        } else {
            for (i = this.selectionStart; i > 0 && this.textString.charAt(i - 1) == ' '; --i) {
            }
            while (i > 0 && this.textString.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void method_25365(boolean focused) {
        if (!focused) {
            this.method_25395(null);
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    protected int method_44395() {
        return 0;
    }

    protected double method_44393() {
        return 0.0;
    }

    private class TextField
    extends class_339 {
        private int renderedSelectionStart;
        private int renderedSelectionEnd;
        private boolean updateMePrettyPlease;
        private int renderStart;
        private int renderEnd;

        private TextField() {
            super(0, 0, 320, 20, (class_2561)class_2561.method_43470((String)"TextField"));
            this.updateMePrettyPlease = false;
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            if (this.renderedSelectionStart != CustomizeNameWidget.this.selectionStart || this.renderedSelectionEnd != CustomizeNameWidget.this.selectionEnd || this.updateMePrettyPlease) {
                this.renderedSelectionStart = CustomizeNameWidget.this.selectionStart;
                this.renderedSelectionEnd = CustomizeNameWidget.this.selectionEnd;
                this.updateMePrettyPlease = false;
                GetRenderWidthVisitor getRenderWidthVisitor = new GetRenderWidthVisitor(CustomizeNameWidget.this.selectionStart, CustomizeNameWidget.this.selectionEnd);
                CustomizeNameWidget.this.text.method_27658((class_5348.class_5246)getRenderWidthVisitor, class_2583.field_24360);
                this.renderStart = getRenderWidthVisitor.getWidths().firstInt();
                this.renderEnd = getRenderWidthVisitor.getWidths().secondInt();
            }
            context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -16777216);
            context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.method_25370() ? -1 : -8355712);
            int textX = this.getTextX();
            int n = this.method_46427();
            int n2 = this.method_25364();
            Objects.requireNonNull(CustomizeNameWidget.this.textRenderer);
            int textY = n + (n2 - 9) / 2;
            if (this.renderStart != this.renderEnd) {
                Objects.requireNonNull(CustomizeNameWidget.this.textRenderer);
                context.method_25294(textX + this.renderStart, textY, textX + this.renderEnd, textY + 9, -16776961);
            }
            if (this.method_25370()) {
                int n3 = textX + (CustomizeNameWidget.this.selectionStart < CustomizeNameWidget.this.selectionEnd ? this.renderStart : this.renderEnd) - 1;
                Objects.requireNonNull(CustomizeNameWidget.this.textRenderer);
                context.method_51742(n3, textY - 1, textY + 9, -1);
            }
            context.method_51439(CustomizeNameWidget.this.textRenderer, CustomizeNameWidget.this.text, textX, textY, -1, false);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            boolean captured = true;
            switch (keyCode) {
                case 263: {
                    CustomizeNameWidget.this.moveCursor(true, class_437.method_25442(), class_437.method_25441());
                    break;
                }
                case 262: {
                    CustomizeNameWidget.this.moveCursor(false, class_437.method_25442(), class_437.method_25441());
                    break;
                }
                case 259: {
                    CustomizeNameWidget.this.erase(true, class_437.method_25441());
                    break;
                }
                case 261: {
                    CustomizeNameWidget.this.erase(false, class_437.method_25441());
                    break;
                }
                default: {
                    captured = false;
                }
            }
            if (captured) {
                return true;
            }
            assert (CustomizeNameWidget.this.client != null);
            if (class_437.method_25439((int)keyCode)) {
                CustomizeNameWidget.this.selectionStart = 0;
                CustomizeNameWidget.this.selectionEnd = CustomizeNameWidget.this.textString.length();
                CustomizeNameWidget.this.updateStyleButtons();
                captured = true;
            } else if (class_437.method_25438((int)keyCode)) {
                CustomizeNameWidget.this.client.field_1774.method_1455(CustomizeNameWidget.this.text.getString().substring(CustomizeNameWidget.this.selectionStart, CustomizeNameWidget.this.selectionEnd));
                captured = true;
            } else if (class_437.method_25437((int)keyCode)) {
                String clipboard = CustomizeNameWidget.this.client.field_1774.method_1460();
                if (!clipboard.isEmpty()) {
                    CustomizeNameWidget.this.insertText(clipboard);
                }
                captured = true;
            } else if (class_437.method_25436((int)keyCode)) {
                CustomizeNameWidget.this.client.field_1774.method_1455(CustomizeNameWidget.this.text.getString().substring(CustomizeNameWidget.this.selectionStart, CustomizeNameWidget.this.selectionEnd));
                CustomizeNameWidget.this.insertText("");
                captured = true;
            }
            return captured;
        }

        public boolean method_25400(char chr, int modifiers) {
            if (!this.field_22763) {
                return false;
            }
            if (class_3544.method_57175((char)chr)) {
                CustomizeNameWidget.this.insertText(Character.toString(chr));
                return true;
            }
            return false;
        }

        public void method_25348(double mouseX, double mouseY) {
            GetClickedPositionVisitor getClickedPositionVisitor = new GetClickedPositionVisitor((int)mouseX - this.getTextX());
            CustomizeNameWidget.this.text.method_27658((class_5348.class_5246)getClickedPositionVisitor, class_2583.field_24360);
            CustomizeNameWidget.this.selectionEnd = getClickedPositionVisitor.getPosition() < 0 ? CustomizeNameWidget.this.textString.length() : getClickedPositionVisitor.getPosition();
            CustomizeNameWidget.this.selectionStart = CustomizeNameWidget.this.selectionEnd;
            CustomizeNameWidget.this.updateStyleButtons();
        }

        protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
            GetClickedPositionVisitor getClickedPositionVisitor = new GetClickedPositionVisitor((int)mouseX - this.getTextX());
            CustomizeNameWidget.this.text.method_27658((class_5348.class_5246)getClickedPositionVisitor, class_2583.field_24360);
            CustomizeNameWidget.this.selectionStart = getClickedPositionVisitor.getPosition() < 0 ? CustomizeNameWidget.this.textString.length() : getClickedPositionVisitor.getPosition();
            CustomizeNameWidget.this.updateStyleButtons();
        }

        private int getTextX() {
            return this.method_46426() + 2;
        }

        public void method_25354(class_1144 soundManager) {
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private class FormattingButton
    extends class_4264 {
        private boolean enabled;
        private final class_124 format;
        private final Predicate<class_2583> isEnabled;

        protected FormattingButton(class_2561 message, class_124 format, Predicate<class_2583> isEnabled) {
            super(0, 0, 16, 16, message);
            this.format = format;
            this.isEnabled = isEnabled;
            this.method_47400(class_7919.method_47407((class_2561)ConfigUtils.FORMATTING_FORMATTER.apply(format)));
        }

        protected FormattingButton(String str, class_124 format, Predicate<class_2583> isEnabled) {
            this((class_2561)class_2561.method_43470((String)str).method_27692(format), format, isEnabled);
        }

        private void update(class_2583 style) {
            this.setEnabled(this.isEnabled.test(style));
        }

        public void method_25306() {
            this.setEnabled(!this.enabled);
            switch (this.format) {
                case field_1067: {
                    CustomizeNameWidget.this.setStyle(class_2583.field_24360.method_10982(Boolean.valueOf(this.enabled)));
                    break;
                }
                case field_1056: {
                    CustomizeNameWidget.this.setStyle(class_2583.field_24360.method_10978(Boolean.valueOf(this.enabled)));
                    break;
                }
                case field_1073: {
                    CustomizeNameWidget.this.setStyle(class_2583.field_24360.method_30938(Boolean.valueOf(this.enabled)));
                    break;
                }
                case field_1055: {
                    CustomizeNameWidget.this.setStyle(class_2583.field_24360.method_36140(Boolean.valueOf(this.enabled)));
                    break;
                }
                case field_1051: {
                    CustomizeNameWidget.this.setStyle(class_2583.field_24360.method_36141(Boolean.valueOf(this.enabled)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(this.format));
                }
            }
        }

        private void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.method_25355((class_2561)this.method_25369().method_27661().method_54663(enabled ? -256 : -1));
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private class ColorButton
    extends class_4264 {
        private final class_124 color;
        private final int intColor;

        private ColorButton(class_124 format) {
            super(0, 0, 16, 16, ConfigUtils.FORMATTING_FORMATTER.apply(format));
            this.method_47400(class_7919.method_47407((class_2561)this.method_25369()));
            this.color = format;
            this.intColor = class_9848.method_61334((int)this.color.method_532());
        }

        public void method_25306() {
            CustomizeNameWidget.this.setStyle(class_2583.field_24360.method_10977(this.color));
        }

        public void method_48589(class_332 context, class_327 textRenderer, int color) {
            context.method_25294(this.method_46426() + 2, this.method_46427() + 2, this.method_55442() - 2, this.method_55443() - 2, this.intColor);
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

