/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.item.slottext.adders;

import de.hysky.skyblocker.skyblock.item.slottext.SimpleSlotTextAdder;
import de.hysky.skyblocker.skyblock.item.slottext.SlotText;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.container.SlotTextAdder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HeartOfTheXAdder
extends SimpleSlotTextAdder {
    private static final Pattern LEVEL = Pattern.compile("Level (?<level>\\d+)/?(?<max>\\d+)?");

    protected HeartOfTheXAdder(@NotNull @Language(value="RegExp") String titlePattern, @Nullable SlotTextAdder.ConfigInformation configInformation) {
        super(titlePattern, configInformation);
    }

    protected abstract class_1792 getNonLeveledItem();

    @Override
    @NotNull
    public List<SlotText> getText(@Nullable class_1735 slot, @NotNull class_1799 stack, int slotId) {
        if (slotId < 0 || slotId > 44 || stack.method_31574(this.getNonLeveledItem())) {
            return List.of();
        }
        List<class_2561> lore = ItemUtils.getLore(stack);
        if (lore.isEmpty()) {
            return List.of();
        }
        String levelLine = lore.getFirst().getString();
        Matcher matcher = LEVEL.matcher(levelLine);
        if (!matcher.matches()) {
            return List.of();
        }
        String level = matcher.group("level");
        boolean isMaxed = matcher.group("max") == null;
        return SlotText.bottomRightList((class_2561)class_2561.method_43470((String)level).method_54663(isMaxed ? 15054859 : 16768449));
    }
}

