/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.itemlist;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.injected.SkyblockerStack;
import de.hysky.skyblocker.skyblock.itemlist.ItemStackBuilder;
import de.hysky.skyblocker.skyblock.itemlist.StackOverlays;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockCraftingRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockForgeRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockNpcShopRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockRecipe;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.NEURepoManager;
import io.github.moulberry.repo.data.NEUCraftingRecipe;
import io.github.moulberry.repo.data.NEUForgeRecipe;
import io.github.moulberry.repo.data.NEUItem;
import io.github.moulberry.repo.data.NEUNpcShopRecipe;
import io.github.moulberry.repo.data.NEURecipe;
import io.github.moulberry.repo.util.NEUId;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_10291;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2788;
import net.minecraft.class_310;
import net.minecraft.class_9322;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemRepository {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ItemRepository.class);
    private static final List<class_1799> items = new ArrayList<class_1799>();
    private static final Map<String, class_1799> itemsMap = new HashMap<String, class_1799>();
    private static final List<SkyblockRecipe> recipes = new ArrayList<SkyblockRecipe>();
    private static final HashMap<String, @NEUId String> bazaarStocks = new HashMap();
    private static final List<AfterImportTask> afterImportTasks = new CopyOnWriteArrayList<AfterImportTask>();
    private static boolean itemsImported = false;
    private static boolean filesImported = false;

    @Init
    public static void init() {
        NEURepoManager.runAsyncAfterLoad(ItemStackBuilder::loadPetNums);
        NEURepoManager.runAsyncAfterLoad(ItemRepository::importItemFiles);
        NEURepoManager.runAsyncAfterLoad(ItemRepository::loadBazaarStocks);
        ItemRepository.runAsyncAfterImport(ItemRepository::handleRecipeSynchronization);
        SkyblockEvents.JOIN.register(ItemRepository::handleRecipeSynchronization);
    }

    private static void handleRecipeSynchronization() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.method_1562() == null) {
            return;
        }
        class_2788 packet = new class_2788(Map.of(), class_10291.class_10293.method_64710());
        try {
            client.execute(() -> client.method_1562().method_11106(packet));
        }
        catch (Exception e) {
            LOGGER.info("[Skyblocker Item Repo] recipe sync error", (Throwable)e);
        }
    }

    private static void importItemFiles() {
        itemsImported = false;
        filesImported = false;
        items.clear();
        itemsMap.clear();
        recipes.clear();
        NEURepoManager.forEachItem(ItemRepository::loadItem);
        items.sort(Comparator.comparing(stack -> stack.getSkyblockId().replaceAll(".\\d+$", "")).thenComparingInt(stack -> stack.getSkyblockId().length()).thenComparing(SkyblockerStack::getSkyblockId));
        itemsImported = true;
        NEURepoManager.forEachItem(ItemRepository::loadRecipes);
        filesImported = true;
        afterImportTasks.forEach(task -> {
            if (task.async) {
                CompletableFuture.runAsync(task.runnable).exceptionally(e -> {
                    LOGGER.error("[Skyblocker Item Repo Loader] Encountered unknown exception while running after import tasks", e);
                    return null;
                });
            } else {
                try {
                    task.runnable.run();
                }
                catch (Exception e2) {
                    LOGGER.error("[Skyblocker Item Repo Loader] Encountered unknown exception while running after import tasks", (Throwable)e2);
                }
            }
        });
    }

    private static void loadItem(NEUItem item) {
        try {
            class_1799 stack = ItemStackBuilder.fromNEUItem(item);
            StackOverlays.applyOverlay(item, stack);
            if (stack.method_31574(class_1802.field_8598) && stack.getSkyblockId().contains(";")) {
                ItemUtils.getCustomData((class_9322)stack).method_10582("id", "ENCHANTED_BOOK");
            }
            items.add(stack);
            itemsMap.put(item.getSkyblockItemId(), stack);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Item Repo Loader] Failed to load item, please report this! Skyblock Id: {}", (Object)item.getSkyblockItemId(), (Object)e);
        }
    }

    private static void loadRecipes(NEUItem item) {
        item.getRecipes().stream().map(ItemRepository::toSkyblockRecipe).filter(Objects::nonNull).forEach(recipes::add);
    }

    private static void loadBazaarStocks() {
        bazaarStocks.clear();
        NEURepoManager.getConstants().getBazaarStocks().getStocks().forEach((neuId, skyblockId) -> bazaarStocks.put((String)skyblockId, (String)neuId));
    }

    public static String getWikiLink(String neuId, boolean useOfficial) {
        NEUItem item = NEURepoManager.getItemByNeuId(neuId);
        if (item == null || item.getInfo() == null || item.getInfo().isEmpty()) {
            return null;
        }
        List info = item.getInfo();
        String wikiLink0 = (String)info.getFirst();
        String wikiLink1 = info.size() > 1 ? (String)info.get(1) : "";
        String wikiDomain = ItemRepository.getWikiLink(useOfficial);
        if (wikiLink0.startsWith(wikiDomain)) {
            return wikiLink0;
        }
        if (wikiLink1.startsWith(wikiDomain)) {
            return wikiLink1;
        }
        return null;
    }

    public static String getWikiLink(boolean useOfficial) {
        return useOfficial ? "https://wiki.hypixel.net" : "https://hypixel-skyblock.fandom.com";
    }

    public static List<SkyblockRecipe> getRecipesAndUsages(class_1799 stack) {
        return Stream.concat(ItemRepository.getRecipes(stack), ItemRepository.getUsages(stack)).toList();
    }

    public static boolean filesImported() {
        return filesImported;
    }

    public static List<class_1799> getItems() {
        return itemsImported ? items : List.of();
    }

    public static Stream<class_1799> getItemsStream() {
        return itemsImported ? items.stream() : Stream.empty();
    }

    public static Map<String, @NEUId String> getBazaarStocks() {
        return bazaarStocks;
    }

    @Nullable
    public static class_1799 getItemStack(String neuId) {
        return itemsImported ? itemsMap.get(neuId) : null;
    }

    @Contract(value="_, !null -> !null")
    public static class_1799 getItemStack(String neuId, class_1799 defaultStack) {
        class_1799 stack = ItemRepository.getItemStack(neuId);
        return stack != null ? stack : defaultStack;
    }

    public static Supplier<class_1799> getItemStackSupplier(String neuId) {
        return () -> itemsMap.get(neuId);
    }

    public static Stream<SkyblockRecipe> getRecipesStream() {
        return filesImported ? recipes.stream() : Stream.empty();
    }

    public static Stream<SkyblockRecipe> getRecipes(class_1799 stack) {
        return NEURepoManager.getRecipes().getOrDefault(stack.getNeuName(), Set.of()).stream().map(ItemRepository::toSkyblockRecipe).filter(Objects::nonNull);
    }

    public static Stream<SkyblockRecipe> getUsages(class_1799 stack) {
        return NEURepoManager.getUsages().getOrDefault(stack.getNeuName(), Set.of()).stream().map(ItemRepository::toSkyblockRecipe).filter(Objects::nonNull);
    }

    private static SkyblockRecipe toSkyblockRecipe(NEURecipe neuRecipe) {
        NEURecipe nEURecipe = neuRecipe;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NEUCraftingRecipe.class, NEUForgeRecipe.class, NEUNpcShopRecipe.class}, (Object)nEURecipe, n)) {
            case 0 -> {
                NEUCraftingRecipe craftingRecipe = (NEUCraftingRecipe)nEURecipe;
                yield new SkyblockCraftingRecipe(craftingRecipe);
            }
            case 1 -> {
                NEUForgeRecipe forgeRecipe = (NEUForgeRecipe)nEURecipe;
                yield new SkyblockForgeRecipe(forgeRecipe);
            }
            case 2 -> {
                NEUNpcShopRecipe shopRecipe = (NEUNpcShopRecipe)nEURecipe;
                yield new SkyblockNpcShopRecipe(shopRecipe);
            }
            default -> null;
        };
    }

    public static void runAsyncAfterImport(Runnable runnable) {
        ItemRepository.runAfterImport(runnable, true);
    }

    public static void runAfterImport(Runnable runnable, boolean async) {
        if (filesImported) {
            if (async) {
                CompletableFuture.runAsync(runnable).exceptionally(e -> {
                    LOGGER.error("[Skyblocker Item Repo Loader] Encountered unknown exception while running after import task", e);
                    return null;
                });
            } else {
                try {
                    runnable.run();
                }
                catch (Exception e2) {
                    LOGGER.error("[Skyblocker Item Repo Loader] Encountered unknown exception while running after import task", (Throwable)e2);
                }
            }
        }
        afterImportTasks.add(new AfterImportTask(runnable, async));
    }

    private record AfterImportTask(Runnable runnable, boolean async) {
    }
}

