/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.museum;

import de.hysky.skyblocker.skyblock.item.ItemPrice;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.museum.Donation;
import de.hysky.skyblocker.skyblock.museum.MuseumItemCache;
import de.hysky.skyblocker.skyblock.museum.MuseumUtils;
import de.hysky.skyblocker.skyblock.museum.PriceData;
import de.hysky.skyblocker.utils.ItemUtils;
import it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_514;
import net.minecraft.class_5250;
import net.minecraft.class_6382;

public class DonationButton
extends class_339 {
    private static final int SIZE = 33;
    private static final int ITEM_OFFSET = 8;
    private static final class_327 TEXT_RENDERER = class_310.method_1551().field_1772;
    private Donation donation = null;
    private class_1799 itemStack = null;
    private String textToRender;
    private List<class_2561> tooltip;

    protected DonationButton(int x, int y) {
        super(x, y, 33, 35, (class_2561)class_2561.method_43473());
    }

    protected class_1799 getDisplayStack() {
        return this.itemStack;
    }

    public void init(Donation donation) {
        this.field_22764 = true;
        this.donation = donation;
        this.textToRender = MuseumUtils.formatPrice(donation.getPriceData().getEffectivePrice());
        this.itemStack = !donation.isSet() ? ItemRepository.getItemStack(donation.getId()) : ItemRepository.getItemStack(MuseumItemCache.ARMOR_TO_ID.get(donation.getId()));
        this.buildTooltip();
    }

    protected void resetButton() {
        this.field_22764 = false;
        this.donation = null;
        this.itemStack = null;
        this.tooltip = null;
        this.textToRender = null;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_52706(class_10799.field_56883, class_514.field_45556, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        boolean hasPrice = this.donation.hasPrice();
        if (this.itemStack != null && !this.itemStack.method_7960()) {
            context.method_51445(this.itemStack, this.method_46426() + 8, this.method_46427() + (hasPrice ? 4 : 8));
        }
        if (hasPrice) {
            context.method_25300(TEXT_RENDERER, this.textToRender, this.method_46426() + this.field_22758 / 2, this.method_46427() + 8 + 13, -16711936);
        }
    }

    private void buildTooltip() {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        boolean soulbound = this.itemStack != null && !this.itemStack.method_7960() && ItemUtils.isSoulbound(this.itemStack);
        ObjectDoublePair<String> discount = this.donation.getDiscount();
        List<ObjectIntPair<String>> countsTowards = this.donation.getCountsTowards();
        tooltip.add(MuseumUtils.getDisplayName(this.donation.getId(), this.donation.isSet()));
        if (this.donation.isSet()) {
            for (ObjectObjectMutablePair<String, PriceData> piece : this.donation.getSet()) {
                class_1799 class_17992 = ItemRepository.getItemStack((String)piece.left());
                if (class_17992 == null) continue;
                class_5250 itemName = class_17992.method_7964().method_27661();
                if (soulbound) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)itemName));
                    continue;
                }
                if (((PriceData)piece.right()).getEffectivePrice() > 0.0) {
                    tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)itemName).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)MuseumUtils.formatPrice(((PriceData)piece.right()).getEffectivePrice())).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)));
                    continue;
                }
                tooltip.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)itemName).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.unknownPrice").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)));
            }
        }
        tooltip.add((class_2561)class_2561.method_43473());
        class_5250 xpText = class_2561.method_43470((String)String.valueOf(this.donation.getTotalXp())).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.skyblockXp")).method_27692(class_124.field_1075);
        tooltip.add((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.xpReward").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)xpText));
        if (!soulbound) {
            class_5250 class_52502;
            PriceData priceData = this.donation.getPriceData();
            class_5250 class_52503 = class_52502 = this.donation.hasLBinPrice() ? class_2561.method_43470((String)MuseumUtils.formatPrice(priceData.getLBinPrice())).method_27693(" Coins").method_27692(class_124.field_1065) : class_2561.method_43471((String)"skyblocker.museum.hud.unknownPrice").method_27692(class_124.field_1061);
            class_5250 craftCostText = this.donation.isCraftable() ? class_2561.method_43470((String)MuseumUtils.formatPrice(this.donation.hasDiscount() ? priceData.getCraftCost() - discount.rightDouble() : priceData.getCraftCost())).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.coin")).method_27692(class_124.field_1065) : class_2561.method_43471((String)"skyblocker.museum.hud.unknownPrice").method_27692(class_124.field_1061);
            class_5250 discountText = this.donation.hasDiscount() && this.donation.isCraftable() ? class_2561.method_43470((String)" (").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)MuseumUtils.formatPrice(priceData.getCraftCost())).method_27692(class_124.field_1065)).method_27693(" - ").method_10852((class_2561)class_2561.method_43470((String)MuseumUtils.formatPrice(discount.rightDouble())).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1063)) : class_2561.method_43473();
            class_5250 xpCoinsRatio = class_2561.method_43470((String)MuseumUtils.formatPrice(this.donation.getXpCoinsRatio())).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.ratioText")).method_27692(class_124.field_1075);
            tooltip.add((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.lBin").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)class_52502));
            tooltip.add((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.craftCost").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)craftCostText).method_10852((class_2561)discountText));
            tooltip.add((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.sorter.ratio").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)xpCoinsRatio));
        }
        if (countsTowards.size() > 1) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.countsFor").method_27693(":").method_27692(class_124.field_1080));
            for (ObjectIntPair objectIntPair : countsTowards) {
                tooltip.add((class_2561)class_2561.method_43470((String)" \u25cf ").method_27692(class_124.field_1080).method_10852(MuseumUtils.getDisplayName((String)objectIntPair.left(), this.donation.isSet())).method_10852((class_2561)class_2561.method_43470((String)(" (" + objectIntPair.rightInt() + " XP)")).method_27692(class_124.field_1075)));
            }
        }
        if (this.donation.isCraftable() && this.donation.hasDiscount()) {
            tooltip.add((class_2561)class_2561.method_43473());
            tooltip.add((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.craftIngredient").method_27693(": ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.museum.hud.alreadyDonatedItem").method_27693(")")).method_27692(class_124.field_1063)));
            tooltip.add((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080).method_10852(MuseumUtils.getDisplayName((String)discount.left(), this.donation.isSet())).method_10852((class_2561)class_2561.method_43470((String)" \u2714").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)MuseumUtils.formatPrice(discount.rightDouble())).method_27692(class_124.field_1065)).method_27693(")").method_27692(class_124.field_1063)));
        }
        String wikiLookupKeyString = WikiLookupManager.getKeysText();
        String string = ItemPrice.ITEM_PRICE_LOOKUP.method_16007().getString();
        if (soulbound || !wikiLookupKeyString.isEmpty() || !string.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43473());
        }
        if (soulbound) {
            tooltip.add((class_2561)class_2561.method_43470((String)"* Soulbound *").method_27692(class_124.field_1063));
        }
        if (!wikiLookupKeyString.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"skyblocker.museum.hud.wikiLookup", (Object[])new Object[]{wikiLookupKeyString}).method_27692(class_124.field_1054));
        }
        if (!soulbound && !string.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"skyblocker.museum.hud.itemPriceLookup", (Object[])new Object[]{string}).method_27692(class_124.field_1054));
        }
        this.tooltip = tooltip;
    }

    protected List<class_2561> getItemTooltip() {
        return this.tooltip;
    }

    protected void method_47399(class_6382 builder) {
    }
}

