/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.speedpreset;

import de.hysky.skyblocker.skyblock.speedpreset.SpeedPresets;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;

public class SpeedPresetListWidget
extends class_4265<AbstractEntry> {
    private static final Pattern NUMBER = Pattern.compile("^-?\\d+(\\.\\d+)?$");
    private static final Pattern TITLE = Pattern.compile("^[a-zA-Z]\\w*$");

    public SpeedPresetListWidget(int width, int height, int y) {
        super(class_310.method_1551(), width, height, y, 25);
        SpeedPresets instance = SpeedPresets.getInstance();
        this.method_25321((class_350.class_351)new TitleEntry());
        if (!instance.getPresets().isEmpty()) {
            instance.getPresets().forEach((title, speed) -> this.method_25321((class_350.class_351)new SpeedPresetEntry((String)title, String.valueOf(speed))));
        } else {
            this.method_25321((class_350.class_351)new SpeedPresetEntry("", ""));
        }
    }

    public int method_25322() {
        return super.method_25322() + 104;
    }

    public boolean hasBeenChanged() {
        SpeedPresets instance = SpeedPresets.getInstance();
        if (this.method_25396().size() < instance.getPresets().size()) {
            return true;
        }
        Map<String, Integer> childrenMap = this.method_25396().stream().filter(SpeedPresetEntry.class::isInstance).map(SpeedPresetEntry.class::cast).map(SpeedPresetEntry::getMapping).filter(Objects::nonNull).collect(Collectors.toMap(Pair::key, ObjectIntPair::valueInt));
        return !instance.arePresetsEqual(childrenMap);
    }

    public void updatePosition() {
        this.method_25396().forEach(AbstractEntry::updatePosition);
    }

    public void newEntry() {
        SpeedPresetEntry entry = new SpeedPresetEntry("", "");
        this.method_25321((class_350.class_351)entry);
        this.method_25324((class_350.class_351)entry);
        this.method_25313((class_350.class_351)entry);
        this.method_25395((class_364)entry);
    }

    public void save() {
        SpeedPresets instance = SpeedPresets.getInstance();
        instance.getPresets().clear();
        this.method_25396().stream().filter(SpeedPresetEntry.class::isInstance).map(SpeedPresetEntry.class::cast).forEach(SpeedPresetEntry::save);
        instance.savePresets();
    }

    public class TitleEntry
    extends AbstractEntry {
        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_27534(((SpeedPresetListWidget)SpeedPresetListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.general.speedPresets.config.title"), SpeedPresetListWidget.this.field_22758 / 2 - 50, y + 8, -1);
            context.method_27534(((SpeedPresetListWidget)SpeedPresetListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.general.speedPresets.config.speed"), SpeedPresetListWidget.this.field_22758 / 2 + 50, y + 8, -1);
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }
    }

    public class SpeedPresetEntry
    extends AbstractEntry {
        protected final class_342 titleInput;
        protected final class_342 speedInput;
        protected final class_4185 removeButton;

        public SpeedPresetEntry(String title, String speed) {
            class_310 client = SpeedPresetListWidget.this.field_22740;
            this.titleInput = new class_342(client.field_1772, 0, 0, 120, 20, (class_2561)class_2561.method_43473());
            this.titleInput.method_1890(str -> str.isEmpty() || TITLE.matcher((CharSequence)str).matches());
            this.titleInput.method_1852(title);
            this.titleInput.method_1880(16);
            this.titleInput.method_47404((class_2561)class_2561.method_43470((String)"newPreset").method_27692(class_124.field_1063));
            this.speedInput = new class_342(client.field_1772, 0, 0, 50, 20, (class_2561)class_2561.method_43473());
            this.speedInput.method_1890(str -> str.isEmpty() || NUMBER.matcher((CharSequence)str).matches());
            this.speedInput.method_1852(speed);
            this.speedInput.method_1880(3);
            this.speedInput.method_47404((class_2561)class_2561.method_43470((String)"0").method_27692(class_124.field_1063));
            this.removeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"-"), btn -> SpeedPresetListWidget.this.method_25330((class_350.class_351)this)).method_46434(0, 0, 20, 20).method_46431();
            this.updatePosition();
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.titleInput, this.speedInput, this.removeButton);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.titleInput, this.speedInput, this.removeButton);
        }

        public void save() {
            ObjectIntPair<String> mapping = this.getMapping();
            if (mapping != null) {
                SpeedPresets.getInstance().setPreset((String)mapping.key(), mapping.valueInt());
            }
        }

        protected boolean isEmpty() {
            return this.titleInput.method_1882().isEmpty() && this.speedInput.method_1882().isEmpty();
        }

        @Override
        protected void updatePosition() {
            class_7845 grid = new class_7845();
            grid.method_48637(2);
            grid.method_46453((class_8021)this.titleInput, 0, 0, 1, 3);
            grid.method_46453((class_8021)this.speedInput, 0, 3, 1, 2);
            grid.method_46453((class_8021)this.removeButton, 0, 5, 1, 1);
            grid.method_48222();
            class_7843.method_46443((class_8021)grid, (int)0, (int)0, (int)SpeedPresetListWidget.this.field_22758, (int)SpeedPresetListWidget.this.field_22741, (float)0.5f, (float)0.5f);
        }

        @Nullable
        protected ObjectIntPair<String> getMapping() {
            if (this.isEmpty()) {
                return null;
            }
            try {
                return ObjectIntPair.of((Object)this.titleInput.method_1882(), (int)Integer.parseInt(this.speedInput.method_1882()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static abstract class AbstractEntry
    extends class_4265.class_4266<AbstractEntry> {
        protected void updatePosition() {
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.method_25396().forEach(child -> {
                if (child instanceof class_8021) {
                    class_8021 widget = (class_8021)child;
                    widget.method_46419(y);
                }
                if (child instanceof class_4068) {
                    class_4068 drawable = (class_4068)child;
                    drawable.method_25394(context, mouseX, mouseY, tickDelta);
                }
            });
        }
    }
}

