/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.tabhud.widget;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.TabHudWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.Components;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

@RegisterWidget
public class FireSaleWidget
extends TabHudWidget {
    private static final class_5250 TITLE = class_2561.method_43470((String)"Fire Sales").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067});
    private static final Pattern FIRE_PATTERN = Pattern.compile("(?<item>.*): (?<avail>\\d*)/(?<total>[0-9.]*)k");

    public FireSaleWidget() {
        super("Fire Sales", TITLE, class_124.field_1062.method_532());
    }

    @Override
    public void updateContent(List<class_2561> lines) {
        for (int i = 1; i < lines.size(); ++i) {
            String s;
            class_2561 text = lines.get(i);
            Matcher m = FIRE_PATTERN.matcher(text.getString());
            if (m.matches()) {
                String avail = m.group("avail");
                class_5250 itemTxt = class_2561.method_43470((String)m.group("item"));
                float total = Float.parseFloat(m.group("total")) * 1000.0f;
                class_5250 prgressTxt = class_2561.method_43470((String)String.format("%s/%.0f", avail, Float.valueOf(total)));
                float pcnt = Float.parseFloat(avail) / total * 100.0f;
                this.addComponent(Components.progressComponent(Ico.GOLD, (class_2561)itemTxt, (class_2561)prgressTxt, pcnt));
                continue;
            }
            String string = text.getString().toLowerCase(Locale.ENGLISH);
            if (string instanceof String && ((s = string).contains("starts") || s.contains("starting"))) {
                this.addComponent(Components.iconTextComponent(Ico.CLOCK, text));
                continue;
            }
            this.addComponent(new PlainTextComponent(text));
        }
    }
}

