/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.teleport;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.teleport.PredictiveSmoothAOTE;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.awt.Color;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_9322;

public class TeleportOverlay {
    private static final class_310 client = class_310.method_1551();
    private static float[] colorComponents;

    @Init
    public static void init() {
        TeleportOverlay.configCallback(SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.teleportOverlayColor);
        WorldRenderExtractionCallback.EVENT.register(TeleportOverlay::extractRendering);
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableTeleportOverlays && TeleportOverlay.client.field_1724 != null && TeleportOverlay.client.field_1687 != null) {
            class_1799 heldItem = TeleportOverlay.client.field_1724.method_6047();
            String itemId = heldItem.getSkyblockId();
            class_2487 customData = ItemUtils.getCustomData((class_9322)heldItem);
            switch (itemId) {
                case "ASPECT_OF_THE_LEECH_1": {
                    if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableWeirdTransmission) break;
                    TeleportOverlay.extractRendering(collector, 3);
                    break;
                }
                case "ASPECT_OF_THE_LEECH_2": {
                    if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableWeirdTransmission) break;
                    TeleportOverlay.extractRendering(collector, 4);
                    break;
                }
                case "ASPECT_OF_THE_END": 
                case "ASPECT_OF_THE_VOID": {
                    if (SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableEtherTransmission && TeleportOverlay.client.field_1690.field_1832.method_1434() && customData.method_68083("ethermerge", 0) == 1) {
                        TeleportOverlay.extractRendering(collector, customData, 57);
                        break;
                    }
                    if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableInstantTransmission) break;
                    TeleportOverlay.extractRendering(collector, customData, 8);
                    break;
                }
                case "ETHERWARP_CONDUIT": {
                    if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableEtherTransmission) break;
                    TeleportOverlay.extractRendering(collector, customData, 57);
                    break;
                }
                case "SINSEEKER_SCYTHE": {
                    if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableSinrecallTransmission) break;
                    TeleportOverlay.extractRendering(collector, customData, 4);
                    break;
                }
                case "NECRON_BLADE": 
                case "ASTRAEA": 
                case "HYPERION": 
                case "SCYLLA": 
                case "VALKYRIE": {
                    if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.enableWitherImpact) break;
                    TeleportOverlay.extractRendering(collector, 10);
                }
            }
        }
    }

    private static void extractRendering(PrimitiveCollector collector, class_2487 customData, int baseRange) {
        TeleportOverlay.extractRendering(collector, customData != null && customData.method_10545("tuned_transmission") ? baseRange + customData.method_68083("tuned_transmission", 0) : baseRange);
    }

    private static void extractRendering(PrimitiveCollector collector, int range) {
        class_243 startPos;
        float yaw;
        if (TeleportOverlay.client.field_1724 == null || TeleportOverlay.client.field_1687 == null) {
            return;
        }
        float pitch = TeleportOverlay.client.field_1724.method_36455();
        class_243 look = TeleportOverlay.client.field_1724.method_5631(pitch, yaw = TeleportOverlay.client.field_1724.method_36454());
        class_243 raycast = PredictiveSmoothAOTE.raycast(range, look, startPos = TeleportOverlay.client.field_1724.method_19538().method_1031(0.0, (double)PredictiveSmoothAOTE.getEyeHeight(), 0.0));
        if (raycast != null) {
            class_2338 target = class_2338.method_49638((class_2374)startPos.method_1019(raycast)).method_10074();
            if (!SkyblockerConfigManager.get().uiAndVisuals.teleportOverlay.showWhenInAir && TeleportOverlay.client.field_1687.method_8320(target).method_26215()) {
                return;
            }
            collector.submitFilledBox(target, colorComponents, colorComponents[3], false);
        }
    }

    public static void configCallback(Color color) {
        colorComponents = color.getRGBComponents(null);
    }
}

