/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.waypoint;

import de.hysky.skyblocker.mixins.accessors.CheckboxWidgetAccessor;
import de.hysky.skyblocker.skyblock.waypoint.AbstractWaypointsScreen;
import de.hysky.skyblocker.skyblock.waypoint.Waypoints;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.render.gui.ARGBTextInput;
import de.hysky.skyblocker.utils.waypoint.NamedWaypoint;
import de.hysky.skyblocker.utils.waypoint.WaypointGroup;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_3965;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4286;
import net.minecraft.class_6379;
import net.minecraft.class_9848;

public class WaypointsListWidget
extends class_4265<AbstractWaypointEntry> {
    private final AbstractWaypointsScreen<?> screen;
    private Location island;
    private List<WaypointGroup> waypoints;
    private final Set<WaypointGroup> collapsedGroups = new HashSet<WaypointGroup>();

    public WaypointsListWidget(class_310 client, AbstractWaypointsScreen<?> screen, int width, int height, int y, int itemHeight) {
        super(client, width, height, y, itemHeight);
        this.screen = screen;
        this.setIsland(screen.island);
    }

    public int method_25322() {
        return super.method_25322() + 116;
    }

    protected int method_65507() {
        return super.method_65507();
    }

    Optional<WaypointGroupEntry> getGroup() {
        class_350.class_351 class_3512 = this.method_25334();
        if (class_3512 instanceof WaypointGroupEntry) {
            WaypointGroupEntry groupEntry = (WaypointGroupEntry)class_3512;
            return Optional.of(groupEntry);
        }
        class_3512 = this.method_25334();
        if (class_3512 instanceof WaypointEntry) {
            WaypointEntry waypointEntry = (WaypointEntry)class_3512;
            return Optional.of(waypointEntry.groupEntry);
        }
        return Optional.empty();
    }

    void setIsland(Location island) {
        this.island = island;
        this.waypoints = (List)this.screen.waypoints.get((Object)island);
        this.collapsedGroups.clear();
        this.collapsedGroups.addAll(this.waypoints);
        this.updateEntries();
    }

    void addWaypointGroupAfterSelected() {
        WaypointGroupEntry groupEntry = new WaypointGroupEntry();
        Optional<WaypointGroupEntry> selectedGroupEntryOptional = this.getGroup();
        int index = this.waypoints.size();
        int entryIndex = this.method_25396().size();
        if (selectedGroupEntryOptional.isPresent()) {
            WaypointGroupEntry selectedGroupEntry = selectedGroupEntryOptional.get();
            index = this.waypoints.indexOf(selectedGroupEntry.group) + 1;
            for (entryIndex = this.method_25396().indexOf((Object)selectedGroupEntry) + 1; entryIndex < this.method_25396().size() && !(this.method_25396().get(entryIndex) instanceof WaypointGroupEntry); ++entryIndex) {
            }
        }
        this.waypoints.add(index, groupEntry.group);
        this.method_25396().add(entryIndex, groupEntry);
    }

    void updateEntries() {
        this.method_25339();
        for (WaypointGroup group : this.waypoints) {
            boolean collapsed = this.collapsedGroups.contains(group);
            WaypointGroupEntry groupEntry = new WaypointGroupEntry(group, collapsed);
            this.method_25321((class_350.class_351)groupEntry);
            if (collapsed) continue;
            for (NamedWaypoint waypoint : group.waypoints()) {
                this.method_25321((class_350.class_351)new WaypointEntry(groupEntry, waypoint));
            }
        }
    }

    void updateButtons() {
        for (class_4265.class_4266 entry : this.method_25396()) {
            if (entry instanceof WaypointGroupEntry) {
                WaypointGroupEntry groupEntry = (WaypointGroupEntry)entry;
                if (groupEntry.enabled.method_20372() != groupEntry.shouldBeChecked()) {
                    ((CheckboxWidgetAccessor)groupEntry.enabled).setChecked(!groupEntry.enabled.method_20372());
                    continue;
                }
            }
            if (!(entry instanceof WaypointEntry)) continue;
            WaypointEntry waypointEntry = (WaypointEntry)entry;
            if (waypointEntry.enabled.method_20372() == this.screen.isEnabled(waypointEntry.waypoint)) continue;
            waypointEntry.enabled.method_25306();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private class_2338 getDefaultPos() {
        class_2338 class_23382;
        class_239 class_2392 = this.field_22740.field_1765;
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            if (this.field_22740.field_1765.method_17783() == class_239.class_240.field_1332) {
                class_23382 = blockHitResult.method_17777();
                return class_23382;
            }
        }
        if (this.field_22740.field_1724 != null) {
            class_23382 = this.field_22740.field_1724.method_24515();
            return class_23382;
        }
        class_23382 = class_2338.field_10980;
        return class_23382;
    }

    protected class WaypointGroupEntry
    extends AbstractWaypointEntry {
        private WaypointGroup group;
        private final List<class_339> children;
        private final class_4286 enabled;
        private final class_342 nameField;
        private final class_4286 ordered;
        private final class_4185 buttonNewWaypoint;
        private final class_4185 buttonDelete;
        private final class_4185 collapseWaypoint;

        public WaypointGroupEntry() {
            this(new WaypointGroup("New Group", this$0.island, new ArrayList<NamedWaypoint>()), false);
        }

        public WaypointGroupEntry(WaypointGroup initialGroup, boolean collapsed) {
            this.group = initialGroup;
            this.enabled = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772).method_54794(this.shouldBeChecked()).method_54791((checkbox, checked) -> this.group.waypoints().forEach(waypoint -> WaypointsListWidget.this.screen.enabledChanged((NamedWaypoint)waypoint, checked))).method_54788();
            this.nameField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 70, 20, (class_2561)class_2561.method_43470((String)"Name"));
            this.nameField.method_1852(this.group.name());
            this.nameField.method_1863(this::updateName);
            this.ordered = class_4286.method_54787((class_2561)class_2561.method_43470((String)"Ordered"), (class_327)((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772).method_54794(this.group.ordered()).method_54791((checkbox, checked) -> this.updateOrdered(checked)).method_54788();
            this.buttonNewWaypoint = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.waypoints.new"), arg_0 -> this.lambda$new$3(collapsed, arg_0)).method_46432(72).method_46431();
            this.buttonDelete = class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.deleteButton"), buttonDelete -> {
                int entryIndex = WaypointsListWidget.this.method_25396().indexOf((Object)this) + 1;
                while (entryIndex < WaypointsListWidget.this.method_25396().size() && !(WaypointsListWidget.this.method_25396().get(entryIndex) instanceof WaypointGroupEntry)) {
                    WaypointsListWidget.this.method_25396().remove(entryIndex);
                }
                WaypointsListWidget.this.method_25396().remove((Object)this);
                WaypointsListWidget.this.waypoints.remove(this.group);
            }).method_46432(38).method_46431();
            class_2561 arrow = class_2561.method_30163((String)(collapsed ? "\u25b2" : "\u25bc"));
            this.collapseWaypoint = class_4185.method_46430((class_2561)arrow, button -> {
                if (collapsed) {
                    WaypointsListWidget.this.collapsedGroups.remove(this.group);
                } else {
                    WaypointsListWidget.this.collapsedGroups.add(this.group);
                }
                WaypointsListWidget.this.updateEntries();
            }).method_46437(11, 11).method_46431();
            this.children = List.of(this.enabled, this.nameField, this.ordered, this.buttonNewWaypoint, this.buttonDelete, this.collapseWaypoint);
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean shouldBeChecked() {
            if (this.group.waypoints().isEmpty()) return false;
            if (!this.group.waypoints().stream().allMatch(WaypointsListWidget.this.screen::isEnabled)) return false;
            return true;
        }

        private void updateName(String name) {
            int index = WaypointsListWidget.this.waypoints.indexOf(this.group);
            this.group = this.group.withName(name);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.group);
            }
        }

        private void updateOrdered(boolean ordered) {
            int index = WaypointsListWidget.this.waypoints.indexOf(this.group);
            this.group = this.group.withOrdered(ordered);
            if (index >= 0) {
                WaypointsListWidget.this.waypoints.set(index, this.group);
            }
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.collapseWaypoint.method_48229(x, y + (entryHeight - this.collapseWaypoint.method_25364()) / 2);
            this.enabled.method_48229(x + 16, y + 1);
            this.nameField.method_48229(this.enabled.method_55442() + 5, y);
            this.ordered.method_48229(x + entryWidth - 190, y + 1);
            this.buttonNewWaypoint.method_48229(x + entryWidth - 115, y);
            this.buttonDelete.method_48229(x + entryWidth - 38, y);
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }

        /*
         * Unable to fully structure code
         */
        private /* synthetic */ void lambda$new$3(boolean collapsed, class_4185 buttonNewWaypoint) {
            waypointEntry = new WaypointEntry(this);
            patt0$temp = WaypointsListWidget.this.method_25334();
            if (!(patt0$temp instanceof WaypointEntry)) ** GOTO lbl-1000
            selectedWaypointEntry = (WaypointEntry)patt0$temp;
            if (selectedWaypointEntry.groupEntry == this) {
                entryIndex = WaypointsListWidget.this.method_25396().indexOf((Object)selectedWaypointEntry) + 1;
            } else lbl-1000:
            // 3 sources

            {
                for (entryIndex = WaypointsListWidget.this.method_25396().indexOf((Object)this) + 1; entryIndex < WaypointsListWidget.this.method_25396().size() && !(WaypointsListWidget.this.method_25396().get(entryIndex) instanceof WaypointGroupEntry); ++entryIndex) {
                }
            }
            this.group.waypoints().add(waypointEntry.waypoint);
            WaypointsListWidget.this.method_25396().add(entryIndex, waypointEntry);
            if (collapsed) {
                WaypointsListWidget.this.collapsedGroups.remove(this.group);
                WaypointsListWidget.this.updateEntries();
            }
        }
    }

    protected class WaypointEntry
    extends AbstractWaypointEntry {
        private final WaypointGroupEntry groupEntry;
        private NamedWaypoint waypoint;
        private final List<class_339> children;
        private final class_4185 buttonUp;
        private final class_4185 buttonDown;
        private final class_4286 enabled;
        private final class_342 nameField;
        private final class_342 xField;
        private final class_342 yField;
        private final class_342 zField;
        private final ARGBTextInput colorField;
        private final class_4185 buttonDelete;

        public WaypointEntry(WaypointGroupEntry groupEntry) {
            this(groupEntry, groupEntry.group.createWaypoint(this$0.getDefaultPos()));
        }

        public WaypointEntry(WaypointGroupEntry groupEntry, NamedWaypoint initialWaypoint) {
            this.groupEntry = groupEntry;
            this.waypoint = initialWaypoint;
            this.buttonUp = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2191"), button -> this.shiftWaypointIndex(-1)).method_46437(11, 11).method_46431();
            this.buttonDown = class_4185.method_46430((class_2561)class_2561.method_30163((String)"\u2193"), button -> this.shiftWaypointIndex(1)).method_46437(11, 11).method_46431();
            this.enabled = class_4286.method_54787((class_2561)class_2561.method_43470((String)""), (class_327)((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772).method_54794(WaypointsListWidget.this.screen.isEnabled(this.waypoint)).method_54791((checkbox, checked) -> WaypointsListWidget.this.screen.enabledChanged(this.waypoint, checked)).method_54788();
            this.nameField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 65, 20, (class_2561)class_2561.method_43470((String)"Name"));
            this.nameField.method_1852(this.waypoint.getName().getString());
            this.nameField.method_1863(this::updateName);
            this.xField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 26, 20, (class_2561)class_2561.method_43470((String)"X"));
            this.xField.method_1852(Integer.toString(this.waypoint.pos.method_10263()));
            this.xField.method_1890(this::checkInt);
            this.xField.method_1863(this::updateX);
            this.yField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 26, 20, (class_2561)class_2561.method_43470((String)"Y"));
            this.yField.method_1852(Integer.toString(this.waypoint.pos.method_10264()));
            this.yField.method_1890(this::checkInt);
            this.yField.method_1863(this::updateY);
            this.zField = new class_342(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, 26, 20, (class_2561)class_2561.method_43470((String)"Z"));
            this.zField.method_1852(Integer.toString(this.waypoint.pos.method_10260()));
            this.zField.method_1890(this::checkInt);
            this.zField.method_1863(this::updateZ);
            this.colorField = new ARGBTextInput(0, 0, ((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, true, true);
            int color = class_9848.method_61318((float)this.waypoint.alpha, (float)this.waypoint.colorComponents[0], (float)this.waypoint.colorComponents[1], (float)this.waypoint.colorComponents[2]);
            this.colorField.setARGBColor(color);
            this.colorField.method_53533(20);
            this.colorField.setOnChange(this::updateColor);
            this.buttonDelete = class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.deleteButton"), button -> {
                groupEntry.group.waypoints().remove(this.waypoint);
                WaypointsListWidget.this.method_25396().remove((Object)this);
            }).method_46432(38).method_46431();
            this.children = List.of(this.buttonUp, this.buttonDown, this.enabled, this.nameField, this.xField, this.yField, this.zField, this.colorField, this.buttonDelete);
        }

        public List<? extends class_6379> method_37025() {
            return this.children;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        private void shiftWaypointIndex(int shift) {
            int currentIndex = this.groupEntry.group.waypoints().indexOf(this.waypoint);
            int newIndex = Math.clamp((long)(currentIndex + shift), 0, this.groupEntry.group.waypoints().size() - 1);
            this.groupEntry.group.waypoints().remove(currentIndex);
            this.groupEntry.group.waypoints().add(newIndex, this.waypoint);
            WaypointsListWidget.this.updateEntries();
        }

        private void updateName(String name) {
            if (this.waypoint.name.getString().equals(name)) {
                return;
            }
            int index = this.groupEntry.group.waypoints().indexOf(this.waypoint);
            this.waypoint = this.waypoint.withName(name);
            if (index >= 0) {
                this.groupEntry.group.waypoints().set(index, this.waypoint);
            }
        }

        private boolean checkInt(String string) {
            try {
                this.parseEmptiableInt(string);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        private void updateX(String xString) {
            this.updateInt(xString, this.waypoint.pos.method_10263(), (Int2ObjectFunction<NamedWaypoint>)((Int2ObjectFunction)this.waypoint::withX));
        }

        private void updateY(String yString) {
            this.updateInt(yString, this.waypoint.pos.method_10264(), (Int2ObjectFunction<NamedWaypoint>)((Int2ObjectFunction)this.waypoint::withY));
        }

        private void updateZ(String zString) {
            this.updateInt(zString, this.waypoint.pos.method_10260(), (Int2ObjectFunction<NamedWaypoint>)((Int2ObjectFunction)this.waypoint::withZ));
        }

        private void updateInt(String newValueString, int currentValue, Int2ObjectFunction<NamedWaypoint> wither) {
            try {
                int index = this.groupEntry.group.waypoints().indexOf(this.waypoint);
                int newValue = this.parseEmptiableInt(newValueString);
                if (newValue == currentValue) {
                    return;
                }
                this.waypoint = (NamedWaypoint)wither.apply(newValue);
                if (index >= 0) {
                    this.groupEntry.group.waypoints().set(index, this.waypoint);
                }
            }
            catch (NumberFormatException e) {
                Waypoints.LOGGER.warn("[Skyblocker Waypoints] Failed to parse integer: {}", (Object)newValueString, (Object)e);
            }
        }

        private void updateColor(int colorInt) {
            int index = this.groupEntry.group.waypoints().indexOf(this.waypoint);
            float[] colorComponents = new float[]{(float)((colorInt & 0xFF0000) >> 16) / 255.0f, (float)((colorInt & 0xFF00) >> 8) / 255.0f, (float)(colorInt & 0xFF) / 255.0f};
            float alpha = (float)((colorInt & 0xFF000000) >>> 24) / 255.0f;
            if (Arrays.equals(this.waypoint.colorComponents, colorComponents) && this.waypoint.alpha == alpha) {
                return;
            }
            this.waypoint = this.waypoint.withColor(colorComponents, alpha);
            if (index >= 0) {
                this.groupEntry.group.waypoints().set(index, this.waypoint);
            }
        }

        private int parseEmptiableInt(String value) throws NumberFormatException {
            return value.isEmpty() || value.equals("-") ? 0 : Integer.parseInt(value);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "X:", WaypointsListWidget.this.field_22758 / 2 - 48, y + 6, -1);
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "Y:", WaypointsListWidget.this.field_22758 / 2 - 11, y + 6, -1);
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "Z:", WaypointsListWidget.this.field_22758 / 2 + 26, y + 6, -1);
            context.method_25303(((WaypointsListWidget)WaypointsListWidget.this).field_22740.field_1772, "#", x + entryWidth - 105, y + 6, -1);
            this.buttonUp.method_48229(x + 3, y + (entryHeight - this.buttonUp.method_25364()) / 2);
            this.buttonDown.method_48229(x + 14, y + (entryHeight - this.buttonDown.method_25364()) / 2);
            this.enabled.method_48229(x + 26, y + 1);
            this.nameField.method_48229(this.enabled.method_55442() + 5, y);
            this.xField.method_48229(WaypointsListWidget.this.field_22758 / 2 - 40, y);
            this.yField.method_48229(WaypointsListWidget.this.field_22758 / 2 - 3, y);
            this.zField.method_48229(WaypointsListWidget.this.field_22758 / 2 + 34, y);
            this.colorField.method_48229(x + entryWidth - 99, y);
            this.buttonDelete.method_48229(x + entryWidth - 38, y);
            for (class_339 child : this.children) {
                child.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }
    }

    protected static abstract class AbstractWaypointEntry
    extends class_4265.class_4266<AbstractWaypointEntry> {
        protected AbstractWaypointEntry() {
        }
    }
}

