/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils;

import de.hysky.skyblocker.utils.RomanNumerals;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class RegexUtils {
    public static OptionalLong findLongFromMatcher(Matcher matcher) {
        return RegexUtils.findLongFromMatcher(matcher, matcher.hasMatch() ? matcher.end() : 0);
    }

    public static OptionalLong findLongFromMatcher(Matcher matcher, int startingIndex) {
        if (!matcher.find(startingIndex)) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(Long.parseLong(matcher.group(1).replace(",", "")));
    }

    public static OptionalInt findIntFromMatcher(Matcher matcher) {
        return RegexUtils.findIntFromMatcher(matcher, matcher.hasMatch() ? matcher.end() : 0);
    }

    public static OptionalInt findIntFromMatcher(Matcher matcher, int startingIndex) {
        if (!matcher.find(startingIndex)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(RegexUtils.parseIntFromMatcher(matcher, 1));
    }

    public static OptionalInt findRomanNumeralFromMatcher(Matcher matcher) {
        return RegexUtils.findRomanNumeralFromMatcher(matcher, matcher.hasMatch() ? matcher.end() : 0);
    }

    public static OptionalInt findRomanNumeralFromMatcher(Matcher matcher, int startingIndex) {
        if (!matcher.find(startingIndex)) {
            return OptionalInt.empty();
        }
        String result = matcher.group(1);
        if (StringUtils.isEmpty((CharSequence)result)) {
            return OptionalInt.of(0);
        }
        if (!RomanNumerals.isValidRomanNumeral(result)) {
            return OptionalInt.empty();
        }
        int resultInt = RomanNumerals.romanToDecimal(result);
        if (resultInt <= 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(resultInt);
    }

    public static OptionalInt parseOptionalIntFromMatcher(Matcher matcher, int group) {
        String s = matcher.group(group);
        if (s == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Integer.parseInt(s.replace(",", "")));
    }

    public static OptionalInt parseOptionalIntFromMatcher(MatchResult matcher, String group) {
        String s = matcher.group(group);
        if (s == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(Integer.parseInt(s.replace(",", "")));
    }

    public static int parseIntFromMatcher(Matcher matcher, int group) {
        return Integer.parseInt(matcher.group(group).replace(",", ""));
    }

    public static int parseIntFromMatcher(Matcher matcher, String group) {
        return Integer.parseInt(matcher.group(group).replace(",", ""));
    }

    public static OptionalDouble findDoubleFromMatcher(Matcher matcher) {
        return RegexUtils.findDoubleFromMatcher(matcher, matcher.hasMatch() ? matcher.end() : 0);
    }

    public static OptionalDouble findDoubleFromMatcher(Matcher matcher, int startingIndex) {
        if (!matcher.find(startingIndex)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Double.parseDouble(matcher.group(1).replace(",", "")));
    }
}

