/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.tictactoe;

import de.hysky.skyblocker.utils.tictactoe.BoardIndex;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.stream.Stream;

public class TicTacToeUtils {
    public static BoardIndex getBestMove(char[][] board) {
        Object2IntOpenHashMap moves = new Object2IntOpenHashMap();
        for (int row = 0; row < board.length; ++row) {
            for (int column = 0; column < board[row].length; ++column) {
                if (board[row][column] != '\u0000') continue;
                board[row][column] = 79;
                int score = TicTacToeUtils.alphabeta(board, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, false);
                board[row][column] = '\u0000';
                moves.put((Object)new BoardIndex(row, column), score);
            }
        }
        return (BoardIndex)Collections.max(moves.object2IntEntrySet(), Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).getKey();
    }

    private static boolean hasMovesAvailable(char[][] board) {
        return Arrays.stream(board).flatMap(row -> Stream.of(Character.valueOf(row[0]), Character.valueOf(row[1]), Character.valueOf(row[2]))).anyMatch(c -> c.charValue() == '\u0000');
    }

    private static int getScore(char[][] board) {
        for (int row = 0; row < 3; ++row) {
            if (board[row][0] != board[row][1] || board[row][0] != board[row][2]) continue;
            switch (board[row][0]) {
                case 'X': {
                    return -10;
                }
                case 'O': {
                    return 10;
                }
            }
        }
        for (int column = 0; column < 3; ++column) {
            if (board[0][column] != board[1][column] || board[0][column] != board[2][column]) continue;
            switch (board[0][column]) {
                case 'X': {
                    return -10;
                }
                case 'O': {
                    return 10;
                }
            }
        }
        if (board[0][0] == board[1][1] && board[0][0] == board[2][2]) {
            switch (board[0][0]) {
                case 'X': {
                    return -10;
                }
                case 'O': {
                    return 10;
                }
            }
        }
        if (board[0][2] == board[1][1] && board[0][2] == board[2][0]) {
            switch (board[0][2]) {
                case 'X': {
                    return -10;
                }
                case 'O': {
                    return 10;
                }
            }
        }
        return 0;
    }

    private static int alphabeta(char[][] board, int alpha, int beta, int depth, boolean maximizePlayer) {
        int score = TicTacToeUtils.getScore(board);
        if (score == 10 || score == -10) {
            return score;
        }
        if (!TicTacToeUtils.hasMovesAvailable(board)) {
            return 0;
        }
        if (maximizePlayer) {
            int bestScore = Integer.MIN_VALUE;
            block0: for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 3; ++column) {
                    if (board[row][column] != '\u0000') continue;
                    board[row][column] = 79;
                    bestScore = Math.max(bestScore, TicTacToeUtils.alphabeta(board, alpha, beta, depth + 1, false));
                    board[row][column] = '\u0000';
                    if (beta <= (alpha = Math.max(alpha, bestScore))) continue block0;
                }
            }
            return bestScore - depth;
        }
        int bestScore = Integer.MAX_VALUE;
        block2: for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                if (board[row][column] != '\u0000') continue;
                board[row][column] = 88;
                bestScore = Math.min(bestScore, TicTacToeUtils.alphabeta(board, alpha, beta, depth + 1, true));
                board[row][column] = '\u0000';
                if ((beta = Math.min(beta, bestScore)) <= alpha) continue block2;
            }
        }
        return bestScore + depth;
    }
}

