/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.waypoint;

import de.hysky.skyblocker.utils.render.Renderable;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_2338;
import net.minecraft.class_3542;

public class Waypoint
implements Renderable {
    protected static final float DEFAULT_HIGHLIGHT_ALPHA = 0.5f;
    protected static final float DEFAULT_LINE_WIDTH = 5.0f;
    public final class_2338 pos;
    final Supplier<Type> typeSupplier;
    public final float[] colorComponents;
    public final float alpha;
    public final float lineWidth;
    public final boolean throughWalls;
    private boolean enabled;

    public Waypoint(class_2338 pos, Type type, float[] colorComponents) {
        this(pos, type, colorComponents, 0.5f);
    }

    public Waypoint(class_2338 pos, Supplier<Type> typeSupplier, float[] colorComponents) {
        this(pos, typeSupplier, colorComponents, 0.5f, 5.0f);
    }

    public Waypoint(class_2338 pos, Type type, float[] colorComponents, float alpha) {
        this(pos, () -> type, colorComponents, alpha, 5.0f);
    }

    public Waypoint(class_2338 pos, Supplier<Type> typeSupplier, float[] colorComponents, float alpha, float lineWidth) {
        this(pos, typeSupplier, colorComponents, alpha, lineWidth, true);
    }

    public Waypoint(class_2338 pos, Type type, float[] colorComponents, boolean throughWalls) {
        this(pos, () -> type, colorComponents, throughWalls);
    }

    public Waypoint(class_2338 pos, Supplier<Type> typeSupplier, float[] colorComponents, boolean throughWalls) {
        this(pos, typeSupplier, colorComponents, 0.5f, 5.0f, throughWalls);
    }

    public Waypoint(class_2338 pos, Supplier<Type> typeSupplier, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls) {
        this(pos, typeSupplier, colorComponents, alpha, lineWidth, throughWalls, true);
    }

    public Waypoint(class_2338 pos, Supplier<Type> typeSupplier, float[] colorComponents, float alpha, float lineWidth, boolean throughWalls, boolean enabled) {
        this.pos = pos;
        this.typeSupplier = typeSupplier;
        this.colorComponents = colorComponents;
        this.alpha = alpha;
        this.lineWidth = lineWidth;
        this.throughWalls = throughWalls;
        this.enabled = enabled;
    }

    public Waypoint withX(int x) {
        return new Waypoint(new class_2338(x, this.pos.method_10264(), this.pos.method_10260()), this.typeSupplier, this.colorComponents, this.alpha, this.lineWidth, this.throughWalls, this.enabled);
    }

    public Waypoint withY(int y) {
        return new Waypoint(this.pos.method_33096(y), this.typeSupplier, this.colorComponents, this.alpha, this.lineWidth, this.throughWalls, this.enabled);
    }

    public Waypoint withZ(int z) {
        return new Waypoint(new class_2338(this.pos.method_10263(), this.pos.method_10264(), z), this.typeSupplier, this.colorComponents, this.alpha, this.lineWidth, this.throughWalls, this.enabled);
    }

    public Waypoint withColor(float[] colorComponents, float alpha) {
        return new Waypoint(this.pos, this.typeSupplier, colorComponents, alpha, this.lineWidth, this.throughWalls, this.enabled);
    }

    public boolean shouldRender() {
        return this.enabled;
    }

    public void setFound() {
        this.enabled = false;
    }

    public void setMissing() {
        this.enabled = true;
    }

    public void toggle() {
        if (this.enabled) {
            this.setFound();
        } else {
            this.setMissing();
        }
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Type getRenderType() {
        return this.typeSupplier.get();
    }

    public float[] getRenderColorComponents() {
        return this.colorComponents;
    }

    public boolean shouldRenderThroughWalls() {
        return this.throughWalls;
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!this.shouldRender()) {
            return;
        }
        float[] colorComponents = this.getRenderColorComponents();
        boolean throughWalls = this.shouldRenderThroughWalls();
        switch (this.getRenderType().ordinal()) {
            case 0: {
                collector.submitFilledBoxWithBeaconBeam(this.pos, colorComponents, this.alpha, throughWalls);
                break;
            }
            case 1: {
                collector.submitFilledBoxWithBeaconBeam(this.pos, colorComponents, this.alpha, throughWalls);
                collector.submitOutlinedBox(this.pos, colorComponents, this.lineWidth, throughWalls);
                break;
            }
            case 2: {
                collector.submitFilledBox(this.pos, colorComponents, this.alpha, throughWalls);
                break;
            }
            case 3: {
                collector.submitFilledBox(this.pos, colorComponents, this.alpha, throughWalls);
                collector.submitOutlinedBox(this.pos, colorComponents, this.lineWidth, throughWalls);
                break;
            }
            case 4: {
                collector.submitOutlinedBox(this.pos, colorComponents, this.lineWidth, throughWalls);
            }
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pos, this.typeSupplier.get(), Arrays.hashCode(this.colorComponents), Float.valueOf(this.alpha), Float.valueOf(this.lineWidth), this.throughWalls, this.enabled});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (super.equals(obj)) return true;
        if (!(obj instanceof Waypoint)) return false;
        Waypoint other = (Waypoint)obj;
        if (!this.pos.equals((Object)other.pos)) return false;
        if (this.typeSupplier.get() != other.typeSupplier.get()) return false;
        if (!Arrays.equals(this.colorComponents, other.colorComponents)) return false;
        if (this.alpha != other.alpha) return false;
        if (this.lineWidth != other.lineWidth) return false;
        if (this.throughWalls != other.throughWalls) return false;
        if (this.enabled != other.enabled) return false;
        return true;
    }

    public static enum Type implements class_3542
    {
        WAYPOINT,
        OUTLINED_WAYPOINT,
        HIGHLIGHT,
        OUTLINED_HIGHLIGHT,
        OUTLINE;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public String toString() {
            return class_1074.method_4662((String)("skyblocker.waypoints.type." + this.name()), (Object[])new Object[0]);
        }

        public Type withoutBeacon() {
            return switch (this.ordinal()) {
                case 0 -> HIGHLIGHT;
                case 1 -> OUTLINED_HIGHLIGHT;
                default -> this;
            };
        }
    }
}

