/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.ws;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.ws.Service;
import de.hysky.skyblocker.utils.ws.Type;
import de.hysky.skyblocker.utils.ws.WsMessageHandler;
import de.hysky.skyblocker.utils.ws.message.Message;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Optional;
import net.azureaaron.hmapi.data.server.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;

public class WsStateManager {
    private static final ReferenceSet<Service> SUBSCRIBED_SERVICES = new ReferenceOpenHashSet();
    private static String lastServerId = "";

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> WsStateManager.reset());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> WsStateManager.reset());
    }

    private static void reset() {
        if (!lastServerId.isEmpty()) {
            for (Service service : SUBSCRIBED_SERVICES) {
                WsMessageHandler.sendSimple(Type.UNSUBSCRIBE, service, lastServerId, Optional.empty());
            }
            lastServerId = "";
        }
    }

    public static void subscribe(Service service, Optional<Message<? extends Message<?>>> message) {
        if (Utils.getEnvironment() != Environment.PRODUCTION) {
            return;
        }
        SUBSCRIBED_SERVICES.add((Object)service);
        WsMessageHandler.sendSimple(Type.SUBSCRIBE, service, Utils.getServer(), message);
        lastServerId = Utils.getServer();
    }
}

