/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.data.JsonData;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5250;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;

public class UpdateNotifications {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final String BASE_URL = "https://api.modrinth.com/v2/project/y6DuFGwJ/version?loaders=[%22fabric%22]";
    private static final Version MOD_VERSION = SkyblockerMod.SKYBLOCKER_MOD.getMetadata().getVersion();
    private static final Path CONFIG_PATH = SkyblockerMod.CONFIG_DIR.resolve("update_notifications.json");
    @VisibleForTesting
    protected static final Comparator<Version> COMPARATOR = Comparable::compareTo;
    @VisibleForTesting
    protected static final Codec<SemanticVersion> SEM_VER_CODEC = Codec.STRING.comapFlatMap(UpdateNotifications::parseVersion, SemanticVersion::toString);
    private static final class_370.class_9037 TOAST_TYPE = new class_370.class_9037(10000L);
    public static final JsonData<Config> config = new JsonData<Config>(CONFIG_PATH, Config.CODEC, Config.DEFAULT);
    private static boolean sentUpdateNotification;
    private static CompletableFuture<Void> loaded;

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            loaded = config.init();
        });
        SkyblockEvents.JOIN.register(() -> {
            if (!loaded.isDone()) {
                loaded.thenRun(UpdateNotifications::tryCheckForNewVersion);
            } else {
                UpdateNotifications.tryCheckForNewVersion();
            }
        });
    }

    private static void tryCheckForNewVersion() {
        if (config.getData().enabled() && !sentUpdateNotification) {
            Scheduler.INSTANCE.schedule(UpdateNotifications::checkForNewVersion, 1200);
        }
    }

    private static void checkForNewVersion() {
        CompletableFuture.runAsync(() -> {
            try {
                SemanticVersion version = (SemanticVersion)MOD_VERSION;
                String response = Http.sendGetRequest(BASE_URL);
                List mrVersions = (List)MrVersion.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)response)).getOrThrow();
                sentUpdateNotification = true;
                Optional<MrVersion> newestVersion = mrVersions.stream().filter(ver -> Arrays.stream(config.getData().includedChannels()).anyMatch(channel -> channel == ver.channel())).filter(mrv -> COMPARATOR.compare((Version)mrv.version(), (Version)version) > 0).max(Comparator.comparing(MrVersion::version, COMPARATOR));
                if (newestVersion.isPresent() && UpdateNotifications.CLIENT.field_1724 != null && !UpdateNotifications.shouldDiscard(version, newestVersion.get().version())) {
                    MrVersion newVersion = newestVersion.get();
                    String downloadLink = "https://modrinth.com/mod/skyblocker-liap/version/" + newVersion.id();
                    class_5250 versionText = class_2561.method_43470((String)newVersion.name()).method_27694(style -> style.method_27706(class_124.field_1080).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(URI.create(downloadLink))));
                    UpdateNotifications.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.updateNotifications.newUpdateMessage", (Object[])new Object[]{versionText})), false);
                    class_370.method_27024((class_374)CLIENT.method_1566(), (class_370.class_9037)TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.updateNotifications.newUpdateToast.title"), (class_2561)class_2561.method_54159((String)"skyblocker.updateNotifications.newUpdateToast.description", (Object[])new Object[]{newVersion.version()}));
                }
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Update Notifications] Failed to determine if an update is available or not!", (Throwable)e);
            }
        });
    }

    private static DataResult<SemanticVersion> parseVersion(String version) {
        String string;
        String string2 = version;
        Objects.requireNonNull(string2);
        String string3 = string2;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)string3, n)) {
                case 0: {
                    String s = string3;
                    if (s.charAt(0) != 'v') {
                        n = 1;
                        continue block5;
                    }
                    string = s.substring(1);
                    break block5;
                }
                default: {
                    string = version;
                    break block5;
                }
            }
            break;
        }
        String formattedVersion = string;
        try {
            return DataResult.success((Object)SemanticVersion.parse((String)formattedVersion));
        }
        catch (VersionParsingException e) {
            return DataResult.error(() -> "Failed to parse semantic version from string: " + formattedVersion);
        }
    }

    private static boolean isUnofficialAlphaOrBeta(SemanticVersion version) {
        boolean bl;
        String string = version.getPrereleaseKey().orElse("");
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String s = string2;
                    if (!s.startsWith("alpha")) {
                        n = 1;
                        continue block4;
                    }
                    if (s.substring(5).charAt(0) == '-') {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                case 1: {
                    String s = string2;
                    if (!s.startsWith("beta")) {
                        n = 2;
                        continue block4;
                    }
                    if (s.substring(4).charAt(0) == '-') {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                default: {
                    bl = false;
                    break block4;
                }
            }
            break;
        }
        return bl;
    }

    @VisibleForTesting
    protected static boolean shouldDiscard(SemanticVersion currentVersion, SemanticVersion latestVersion) {
        if (UpdateNotifications.isUnofficialAlphaOrBeta(currentVersion)) {
            int currentMajor = currentVersion.getVersionComponent(0);
            int currentMinor = currentVersion.getVersionComponent(1);
            int currentPatch = currentVersion.getVersionComponent(2);
            int latestMajor = latestVersion.getVersionComponent(0);
            int latestMinor = latestVersion.getVersionComponent(1);
            int latestPatch = latestVersion.getVersionComponent(2);
            return currentMajor == latestMajor && currentMinor == latestMinor && currentPatch == latestPatch;
        }
        return false;
    }

    public record Config(boolean enabled, Channel channel) {
        public static final Config DEFAULT = new Config(true, Channel.ALPHA);
        private static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(Config::enabled), (App)Channel.CODEC.fieldOf("channel").forGetter(Config::channel)).apply((Applicative)instance, Config::new));

        private Channel[] includedChannels() {
            Channel[] channelArray;
            switch (this.channel.ordinal()) {
                case 1: {
                    Channel[] channelArray2 = new Channel[2];
                    channelArray2[0] = Channel.RELEASE;
                    channelArray = channelArray2;
                    channelArray2[1] = Channel.BETA;
                    break;
                }
                case 2: {
                    channelArray = Channel.values();
                    break;
                }
                default: {
                    Channel[] channelArray3 = new Channel[1];
                    channelArray = channelArray3;
                    channelArray3[0] = this.channel;
                }
            }
            return channelArray;
        }

        public Config withEnabled(boolean newEnabled) {
            return new Config(newEnabled, this.channel);
        }

        public Config withChannel(Channel newChannel) {
            return new Config(this.enabled, newChannel);
        }
    }

    private record MrVersion(String id, String name, SemanticVersion version, Channel channel) {
        private static final Codec<MrVersion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(MrVersion::id), (App)Codec.STRING.fieldOf("name").forGetter(MrVersion::name), (App)SEM_VER_CODEC.fieldOf("version_number").forGetter(MrVersion::version), (App)Channel.CODEC.fieldOf("version_type").forGetter(MrVersion::channel)).apply((Applicative)instance, MrVersion::new));
        private static final Codec<List<MrVersion>> LIST_CODEC = CODEC.listOf();
    }

    public static enum Channel implements class_3542
    {
        RELEASE,
        BETA,
        ALPHA;

        private static final Codec<Channel> CODEC;

        public String toString() {
            return class_1074.method_4662((String)("skyblocker.config.general.updateNotifications.updateChannel.channel." + this.name()), (Object[])new Object[0]);
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = class_3542.method_53955(Channel::values);
        }
    }
}

