/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility.emi;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.compatibility.emi.SkyblockEmiRecipe;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockCraftingRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockForgeRecipe;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.Map;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_490;

public class SkyblockerEMIPlugin
implements EmiPlugin {
    public static final class_2960 SIMPLIFIED_TEXTURES = SkyblockerMod.id("textures/gui/emi_icons.png");
    public static final EmiRecipeCategory SKYBLOCK_CRAFTING = new EmiRecipeCategory(SkyblockCraftingRecipe.IDENTIFIER, (EmiRenderable)EmiStack.of((class_1935)class_1802.field_8465), (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURES, 0, 0, 16, 16));
    public static final EmiRecipeCategory SKYBLOCK_FORGE = new EmiRecipeCategory(SkyblockForgeRecipe.IDENTIFIER, (EmiRenderable)EmiStack.of((class_1935)class_1802.field_8187), (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURES, 16, 0, 16, 16));
    protected static final Map<class_2960, EmiRecipeCategory> IDENTIFIER_CATEGORY_MAP = Map.of(SkyblockCraftingRecipe.IDENTIFIER, SKYBLOCK_CRAFTING, SkyblockForgeRecipe.IDENTIFIER, SKYBLOCK_FORGE);

    public void register(EmiRegistry registry) {
        if (!SkyblockerConfigManager.get().general.itemList.enableItemList) {
            return;
        }
        ItemRepository.getItemsStream().map(EmiStack::of).forEach(emiStack -> {
            registry.addEmiStack(emiStack);
            registry.setDefaultComparison(emiStack, Comparison.compareData(emiStack1 -> emiStack1.getItemStack().getSkyblockId()));
        });
        registry.addCategory(SKYBLOCK_CRAFTING);
        registry.addCategory(SKYBLOCK_FORGE);
        registry.addWorkstation(SKYBLOCK_CRAFTING, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8465));
        registry.addWorkstation(SKYBLOCK_CRAFTING, (EmiIngredient)EmiStack.of((class_1935)class_1802.field_8187));
        ItemRepository.getRecipesStream().map(SkyblockEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        registry.addExclusionArea(class_490.class, (screen, consumer) -> {
            if (!SkyblockerConfigManager.get().farming.garden.gardenPlotsWidget || !Utils.getLocation().equals((Object)Location.GARDEN)) {
                return;
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
            consumer.accept(new Bounds(accessor.getX() + accessor.getBackgroundWidth() + 4, accessor.getY(), 104, 127));
        });
    }
}

