/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility.rei;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.compatibility.rei.SkyblockTransferHandler;
import de.hysky.skyblocker.compatibility.rei.info.SkyblockInfoCategory;
import de.hysky.skyblocker.compatibility.rei.info.SkyblockInfoDisplayGenerator;
import de.hysky.skyblocker.compatibility.rei.recipe.SkyblockRecipeCategory;
import de.hysky.skyblocker.compatibility.rei.recipe.SkyblockRecipeDisplayGenerator;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.GeneralConfig;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.skyblock.garden.visitor.VisitorHelper;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockCraftingRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockForgeRecipe;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockNpcShopRecipe;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.Utils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_490;

public class SkyblockerREIClientPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry categoryRegistry) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!SkyblockerConfigManager.get().general.itemList.enableItemList) {
            return;
        }
        categoryRegistry.addWorkstations(CategoryIdentifier.of((class_2960)SkyblockCraftingRecipe.IDENTIFIER), new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8465)});
        categoryRegistry.addWorkstations(CategoryIdentifier.of((class_2960)SkyblockForgeRecipe.IDENTIFIER), new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8782)});
        categoryRegistry.addWorkstations(CategoryIdentifier.of((class_2960)SkyblockNpcShopRecipe.IDENTIFIER), new EntryStack[]{EntryStacks.of((class_1935)class_1802.field_8397)});
        categoryRegistry.add((DisplayCategory)new SkyblockRecipeCategory(SkyblockCraftingRecipe.IDENTIFIER, (class_2561)class_2561.method_43471((String)"emi.category.skyblocker.skyblock_crafting"), ItemUtils.getSkyblockerStack(), 73));
        categoryRegistry.add((DisplayCategory)new SkyblockRecipeCategory(SkyblockForgeRecipe.IDENTIFIER, (class_2561)class_2561.method_43471((String)"emi.category.skyblocker.skyblock_forge"), ItemUtils.getSkyblockerForgeStack(), 84));
        categoryRegistry.add((DisplayCategory)new SkyblockRecipeCategory(SkyblockNpcShopRecipe.IDENTIFIER, (class_2561)class_2561.method_43471((String)"emi.category.skyblocker.skyblock_npc_shop"), class_1802.field_8397.method_7854(), 73));
        categoryRegistry.add((DisplayCategory)new SkyblockInfoCategory());
    }

    public void registerDisplays(DisplayRegistry displayRegistry) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!SkyblockerConfigManager.get().general.itemList.enableItemList) {
            return;
        }
        if (displayRegistry.getGlobalDisplayGenerators().stream().noneMatch(generator -> generator instanceof SkyblockRecipeDisplayGenerator)) {
            displayRegistry.registerGlobalDisplayGenerator((DynamicDisplayGenerator)new SkyblockRecipeDisplayGenerator());
        }
        if (displayRegistry.getGlobalDisplayGenerators().stream().noneMatch(generator -> generator instanceof SkyblockInfoDisplayGenerator)) {
            displayRegistry.registerGlobalDisplayGenerator((DynamicDisplayGenerator)new SkyblockInfoDisplayGenerator());
        }
    }

    public void registerEntries(EntryRegistry entryRegistry) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!SkyblockerConfigManager.get().general.itemList.enableItemList) {
            return;
        }
        entryRegistry.removeEntryIf(entryStack -> true);
        entryRegistry.addEntries(ItemRepository.getItemsStream().map(EntryStacks::of).toList());
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        GeneralConfig.ItemList config = SkyblockerConfigManager.get().general.itemList;
        if (!config.enableItemList || !config.enableCollapsibleEntries) {
            return;
        }
        if (!ItemRepository.filesImported() || NEURepoManager.isLoading()) {
            return;
        }
        NEURepoManager.getConstants().getParents().getParents().forEach((parentId, childrenList) -> {
            class_2561 name;
            Optional<class_1799> parentItem = ItemRepository.getItemsStream().filter(itemStack -> itemStack.getNeuName().equals(parentId)).findFirst();
            if (parentItem.isEmpty()) {
                return;
            }
            List<EntryStack> allItems = Stream.concat(parentItem.stream(), ItemRepository.getItemsStream().filter(itemStack -> childrenList.contains(itemStack.getNeuName()))).map(EntryStacks::of).toList();
            String categoryPath = parentId.toLowerCase(Locale.ENGLISH).replace(";", "_");
            if (parentId.contains(";")) {
                categoryPath = categoryPath.substring(0, categoryPath.lastIndexOf("_"));
            }
            if (parentItem.get().method_31574(class_1802.field_8598)) {
                String enchantName = ItemUtils.getLore(parentItem.get()).getFirst().getString();
                enchantName = enchantName.substring(0, enchantName.lastIndexOf(32));
                name = class_2561.method_43470((String)enchantName).method_27692(parentId.startsWith("ULTIMATE") ? class_124.field_1076 : class_124.field_1078);
            } else {
                name = parentItem.get().method_7964();
            }
            registry.group(SkyblockerMod.id("rei_category/" + categoryPath), name, allItems);
        });
    }

    public void registerExclusionZones(ExclusionZones zones) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        zones.register(class_476.class, containerScreen -> {
            if (!SkyblockerConfigManager.get().uiAndVisuals.museumOverlay || !containerScreen.method_25440().getString().contains("Museum")) {
                return List.of();
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)containerScreen;
            return List.of(new Rectangle(accessor.getX() + accessor.getBackgroundWidth() + 4, accessor.getY(), 147, 160));
        });
        zones.register(class_490.class, screen -> {
            if (!SkyblockerConfigManager.get().farming.garden.gardenPlotsWidget || !Utils.getLocation().equals((Object)Location.GARDEN)) {
                return List.of();
            }
            HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
            return List.of(new Rectangle(accessor.getX() + accessor.getBackgroundWidth() + 4, accessor.getY(), 104, 127));
        });
        zones.register(class_437.class, screen -> {
            if (!VisitorHelper.shouldRender()) {
                return List.of();
            }
            return VisitorHelper.getExclusionZones();
        });
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (!SkyblockerConfigManager.get().general.itemList.enableItemList) {
            return;
        }
        registry.register((TransferHandler)new SkyblockTransferHandler());
    }

    public double getPriority() {
        return -50.0;
    }
}

