/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.backup.ConfigBackupManager;
import de.hysky.skyblocker.config.categories.ChatCategory;
import de.hysky.skyblocker.config.categories.CrimsonIsleCategory;
import de.hysky.skyblocker.config.categories.DebugCategory;
import de.hysky.skyblocker.config.categories.DungeonsCategory;
import de.hysky.skyblocker.config.categories.EventNotificationsCategory;
import de.hysky.skyblocker.config.categories.FarmingCategory;
import de.hysky.skyblocker.config.categories.ForagingCategory;
import de.hysky.skyblocker.config.categories.GeneralCategory;
import de.hysky.skyblocker.config.categories.HelperCategory;
import de.hysky.skyblocker.config.categories.HuntingCategory;
import de.hysky.skyblocker.config.categories.MiningCategory;
import de.hysky.skyblocker.config.categories.MiscCategory;
import de.hysky.skyblocker.config.categories.OtherLocationsCategory;
import de.hysky.skyblocker.config.categories.QuickNavigationCategory;
import de.hysky.skyblocker.config.categories.SlayersCategory;
import de.hysky.skyblocker.config.categories.UIAndVisualsCategory;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.azureaaron.dandelion.systems.ConfigManager;
import net.azureaaron.dandelion.systems.DandelionConfigScreen;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_7919;
import org.apache.commons.lang3.function.Consumers;

public class SkyblockerConfigManager {
    public static final int CONFIG_VERSION = 4;
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("skyblocker.json");
    private static final ConfigManager<SkyblockerConfig> CONFIG_MANAGER = ConfigManager.create(SkyblockerConfig.class, (Path)CONFIG_FILE, UnaryOperator.identity());

    public static SkyblockerConfig get() {
        return (SkyblockerConfig)CONFIG_MANAGER.instance();
    }

    public static void init() {
        if (StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass() != SkyblockerMod.class) {
            throw new RuntimeException("Skyblocker: Called config init from an illegal place!");
        }
        CONFIG_MANAGER.load();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(SkyblockerConfigManager.optionsLiteral("config"))).then(SkyblockerConfigManager.optionsLiteral("options"))));
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (SkyblockerConfigManager.get().uiAndVisuals.showConfigButton && screen instanceof class_476) {
                class_476 genericContainerScreen = (class_476)screen;
                if (screen.method_25440().getString().equals("SkyBlock Menu")) {
                    Screens.getButtons((class_437)screen).add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd27"), buttonWidget -> client.method_1507(SkyblockerConfigManager.createGUI(screen))).method_46434(((HandledScreenAccessor)genericContainerScreen).getX() + ((HandledScreenAccessor)genericContainerScreen).getBackgroundWidth() - 16, ((HandledScreenAccessor)genericContainerScreen).getY() + 4, 12, 12).method_46436(class_7919.method_47407((class_2561)class_2561.method_43469((String)"skyblocker.config.title", (Object[])new Object[]{class_2561.method_43471((String)"skyblocker.config.title.settings")}))).method_46431());
                }
            }
        });
    }

    @Deprecated(since="1.21.5", forRemoval=true)
    public static void save() {
        SkyblockerConfigManager.update(Consumers.nop());
    }

    public static void update(Consumer<SkyblockerConfig> action) {
        action.accept(SkyblockerConfigManager.get());
        ConfigBackupManager.backupConfig();
        CONFIG_MANAGER.save();
    }

    public static class_437 createGUI(class_437 parent) {
        return DandelionConfigScreen.create(CONFIG_MANAGER, (defaults, config, builder) -> builder.title((class_2561)class_2561.method_43469((String)"skyblocker.config.title", (Object[])new Object[]{SkyblockerMod.VERSION})).category(GeneralCategory.create(defaults, config)).category(UIAndVisualsCategory.create(defaults, config)).category(HelperCategory.create(defaults, config)).category(DungeonsCategory.create(defaults, config)).category(ForagingCategory.create(defaults, config)).category(CrimsonIsleCategory.create(defaults, config)).category(MiningCategory.create(defaults, config)).category(FarmingCategory.create(defaults, config)).category(HuntingCategory.create(defaults, config)).category(OtherLocationsCategory.create(defaults, config)).category(SlayersCategory.create(defaults, config)).category(ChatCategory.create(defaults, config)).category(QuickNavigationCategory.create(defaults, config)).category(EventNotificationsCategory.create(defaults, config)).category(MiscCategory.create(defaults, config)).categoryIf(Debug.debugEnabled(), DebugCategory.create(defaults, config))).generateScreen(parent, SkyblockerConfigManager.get().misc.configBackend);
    }

    public static Path getConfigPath() {
        return CONFIG_FILE;
    }

    public static void reload() {
        CONFIG_MANAGER.load();
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> optionsLiteral(String name) {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(Scheduler.queueOpenScreenCommand(() -> SkyblockerConfigManager.createGUI(null)));
    }
}

