/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.configs;

import de.hysky.skyblocker.skyblock.GyroOverlay;
import de.hysky.skyblocker.skyblock.item.slottext.SlotTextMode;
import de.hysky.skyblocker.skyblock.tabhud.screenbuilder.ScreenBuilder;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_640;

public class UIAndVisualsConfig {
    public boolean swingOnAbilities = false;
    public int nightVisionStrength = 100;
    public boolean compactorDeletorPreview = true;
    public boolean dontStripSkinAlphaValues = true;
    public boolean backpackPreviewWithoutShift = false;
    public boolean hideEmptyTooltips = true;
    public boolean fancyCraftingTable = true;
    public boolean hideStatusEffectOverlay = true;
    public boolean showEquipmentInInventory = true;
    public boolean cancelComponentUpdateAnimation = true;
    public boolean showCustomizeButton = true;
    public boolean showConfigButton = false;
    public boolean trueQuiverCount = true;
    public ChestValue chestValue = new ChestValue();
    public ItemCooldown itemCooldown = new ItemCooldown();
    public boolean museumOverlay = true;
    public SlotText slotText = new SlotText();
    public InventorySearchConfig inventorySearch = new InventorySearchConfig();
    public TitleContainer titleContainer = new TitleContainer();
    public TabHudConf tabHud = new TabHudConf();
    public FancyAuctionHouse fancyAuctionHouse = new FancyAuctionHouse();
    public Bars bars = new Bars();
    public Waypoints waypoints = new Waypoints();
    public TeleportOverlay teleportOverlay = new TeleportOverlay();
    public SmoothAOTE smoothAOTE = new SmoothAOTE();
    public SearchOverlay searchOverlay = new SearchOverlay();
    public BazaarQuickQuantities bazaarQuickQuantities = new BazaarQuickQuantities();
    public InputCalculator inputCalculator = new InputCalculator();
    public FlameOverlay flameOverlay = new FlameOverlay();
    public CompactDamage compactDamage = new CompactDamage();
    public HealthBars healthBars = new HealthBars();
    public GyrokineticWandOverlay gyroOverlay = new GyrokineticWandOverlay();
    public ItemPickup itemPickup = new ItemPickup();

    public static class ChestValue {
        public boolean enableChestValue = true;
        public class_124 color = class_124.field_1077;
        public class_124 incompleteColor = class_124.field_1078;
    }

    public static class ItemCooldown {
        public boolean enableItemCooldowns = true;
    }

    public static class SlotText {
        public SlotTextMode slotTextMode = SlotTextMode.ENABLED;
        public Object2BooleanOpenHashMap<String> textEnabled = new Object2BooleanOpenHashMap();
        public boolean slotTextToggled = true;
    }

    public static class InventorySearchConfig {
        public EnableState enabled = EnableState.SKYBLOCK;
        public boolean ctrlK = false;
        public boolean clickableText = false;

        public static enum EnableState {
            OFF,
            SKYBLOCK,
            EVERYWHERE;


            public String toString() {
                return class_1074.method_4662((String)("skyblocker.config.uiAndVisuals.inventorySearch.state." + this.name()), (Object[])new Object[0]);
            }

            public boolean isEnabled() {
                return switch (this.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> false;
                    case 1 -> Utils.isOnSkyblock();
                    case 2 -> true;
                };
            }
        }
    }

    public static class TitleContainer {
        public float titleContainerScale = 100.0f;
        public int x = -1;
        public int y = -1;
        public Direction direction = Direction.VERTICAL;
        public Alignment alignment = Alignment.MIDDLE;

        public float getRenderScale() {
            return this.titleContainerScale * 0.03f;
        }
    }

    public static class TabHudConf {
        public boolean tabHudEnabled = true;
        public int tabHudScale = 100;
        public boolean showVanillaTabByDefault = false;
        public TabHudStyle style = TabHudStyle.FANCY;
        public boolean displayIcons = true;
        public boolean compactWidgets = false;
        public boolean enableHudBackground = true;
        public boolean effectsFromFooter = false;
        public ScreenBuilder.DefaultPositioner defaultPositioning = ScreenBuilder.DefaultPositioner.CENTERED;
        @Deprecated
        public transient boolean plainPlayerNames = false;
        public NameSorting nameSorting = NameSorting.DEFAULT;
    }

    public static class FancyAuctionHouse {
        public boolean enabled = false;
        public boolean highlightCheapBIN = true;
    }

    public static class Bars {
        public boolean enableBars = true;
        public IntelligenceDisplay intelligenceDisplay = IntelligenceDisplay.ORIGINAL;
        @Deprecated
        public LegacyBarPositions barPositions = new LegacyBarPositions();
    }

    public static class Waypoints {
        public boolean enableWaypoints = true;
        public Waypoint.Type waypointType = Waypoint.Type.WAYPOINT;
        public boolean enableChatWaypoints = true;
    }

    public static class TeleportOverlay {
        public boolean enableTeleportOverlays = true;
        public boolean showWhenInAir = false;
        public Color teleportOverlayColor = new Color(2138445204, true);
        public boolean enableWeirdTransmission = false;
        public boolean enableInstantTransmission = false;
        public boolean enableEtherTransmission = true;
        public boolean enableSinrecallTransmission = false;
        public boolean enableWitherImpact = false;
    }

    public static class SmoothAOTE {
        public boolean predictive = false;
        public boolean enableWeirdTransmission = false;
        public boolean enableInstantTransmission = false;
        public boolean enableEtherTransmission = false;
        public boolean enableSinrecallTransmission = false;
        public boolean enableWitherImpact = false;
        public int maximumAddedLag = 100;
    }

    public static class SearchOverlay {
        public boolean enableBazaar = true;
        public boolean enableAuctionHouse = true;
        public boolean enableMuseum = true;
        public boolean keepPreviousSearches = false;
        public int maxSuggestions = 3;
        public int historyLength = 3;
        public boolean enableCommands = false;
        public List<String> bazaarHistory = new ArrayList<String>();
        public List<String> auctionHistory = new ArrayList<String>();
        public List<String> museumHistory = new ArrayList<String>();
    }

    public static class BazaarQuickQuantities {
        public boolean enabled = false;
        public boolean closeSignOnUse = false;
        public int slot1Quantity = 28;
        public int slot2Quantity = 2240;
        public int slot3Quantity = 256;
    }

    public static class InputCalculator {
        public boolean enabled = true;
        public boolean requiresEquals = false;
        public boolean closeSignsWithEnter = true;
    }

    public static class FlameOverlay {
        public int flameHeight = 100;
        public int flameOpacity = 100;
    }

    public static class CompactDamage {
        public boolean enabled = true;
        public int precision = 1;
        public Color normalDamageColor = new Color(0xFFFFFF);
        public Color critDamageGradientStart = new Color(0xFFFF55);
        public Color critDamageGradientEnd = new Color(0xFF5555);
    }

    public static class HealthBars {
        public boolean enabled = false;
        public float scale = 1.5f;
        public boolean removeHealthFromName = true;
        public boolean removeMaxHealthFromName = true;
        public boolean applyToHealthOnlyMobs = true;
        public boolean hideFullHealth = false;
        public Color fullBarColor = new Color(65280);
        public Color halfBarColor = new Color(0xFFFF00);
        public Color emptyBarColor = new Color(0xFF0000);
    }

    public static class GyrokineticWandOverlay {
        public GyroOverlay.Mode gyroOverlayMode = GyroOverlay.Mode.OFF;
        public Color gyroOverlayColor = new Color(2138445204, true);
    }

    public static class ItemPickup {
        public boolean enabled = false;
        public boolean sackNotifications = false;
        public boolean showItemName = true;
        public int lifeTime = 3;
        public boolean splitNotifications = false;
    }

    public static enum LegacyBarPosition {
        LAYER1,
        LAYER2,
        RIGHT,
        NONE;

    }

    @Deprecated
    public static class LegacyBarPositions {
        public LegacyBarPosition healthBarPosition = LegacyBarPosition.LAYER1;
        public LegacyBarPosition manaBarPosition = LegacyBarPosition.LAYER1;
        public LegacyBarPosition defenceBarPosition = LegacyBarPosition.RIGHT;
        public LegacyBarPosition experienceBarPosition = LegacyBarPosition.LAYER2;
    }

    public static enum IntelligenceDisplay {
        ORIGINAL,
        ACCURATE,
        IN_FRONT;

    }

    public static enum NameSorting {
        DEFAULT,
        ALPHABETICAL(Comparator.comparing(ple -> NameSorting.matchPlayerName(ple.method_2971().getString(), "name").orElse(""), String.CASE_INSENSITIVE_ORDER)),
        SKYBLOCK_LEVEL(Comparator.comparingInt(ple -> NameSorting.matchPlayerName(ple.method_2971().getString(), "level").map(Integer::parseInt).orElse(0)).reversed());

        public final Comparator<class_640> comparator;

        private NameSorting() {
            this(null);
        }

        private NameSorting(Comparator<class_640> comparator) {
            this.comparator = comparator;
        }

        private static Optional<String> matchPlayerName(String name, String group) {
            Matcher matcher = PlayerListManager.PLAYER_NAME_PATTERN.matcher(name);
            return matcher.matches() ? Optional.of(matcher.group(group)) : Optional.empty();
        }

        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Default";
                case 1 -> "Alphabetical";
                case 2 -> "Skyblock Level";
            };
        }
    }

    public static enum TabHudStyle {
        MINIMAL,
        SIMPLE,
        CLASSIC,
        FANCY;


        public boolean isMinimal() {
            return this == MINIMAL;
        }

        public String toString() {
            return class_1074.method_4662((String)("skyblocker.config.uiAndVisuals.tabHud.style." + this.name()), (Object[])new Object[0]);
        }
    }

    public static enum Alignment {
        LEFT,
        MIDDLE,
        RIGHT;


        public String toString() {
            return class_1074.method_4662((String)("skyblocker.config.uiAndVisuals.titleContainer.alignment." + this.name()), (Object[])new Object[0]);
        }
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;


        public String toString() {
            return class_1074.method_4662((String)("skyblocker.config.uiAndVisuals.titleContainer.direction." + this.name()), (Object[])new Object[0]);
        }
    }
}

