/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.injected.SkyblockerStack;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_9299;
import net.minecraft.class_9304;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements class_9322,
SkyblockerStack {
    @Unique
    private int maxDamage;
    @Unique
    private String skyblockId;
    @Unique
    private String skyblockApiId;
    @Unique
    private String neuName;
    @Unique
    private String uuid;
    @Unique
    private PetInfo petInfo;
    @Unique
    private SkyblockItemRarity skyblockRarity;

    @Shadow
    public abstract int method_7919();

    @Shadow
    public abstract void method_7974(int var1);

    @ModifyReturnValue(method={"method_7964()Lnet/minecraft/class_2561;"}, at={@At(value="RETURN")})
    private class_2561 skyblocker$customItemNames(class_2561 original) {
        if (Utils.isOnSkyblock()) {
            return (class_2561)SkyblockerConfigManager.get().general.customItemNames.getOrDefault((Object)this.getUuid(), (Object)original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"method_57369(Lnet/minecraft/class_9331;Lnet/minecraft/class_1792$class_9635;Lnet/minecraft/class_10712;Ljava/util/function/Consumer;Lnet/minecraft/class_1836;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_10712;method_67214(Lnet/minecraft/class_9331;)Z")})
    private boolean skyblocker$hideVanillaEnchants(boolean shouldDisplay, @Local class_9299 component) {
        return shouldDisplay && (!Utils.isOnSkyblock() || !(component instanceof class_9304));
    }

    @Inject(method={"method_67194(Lnet/minecraft/class_1792$class_9635;Lnet/minecraft/class_10712;Lnet/minecraft/class_1657;Lnet/minecraft/class_1836;Ljava/util/function/Consumer;)V"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/class_7922;method_10221(Ljava/lang/Object;)Lnet/minecraft/class_2960;"))}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", shift=At.Shift.AFTER, ordinal=0)})
    private void skyblocker$skyblockIdTooltip(CallbackInfo ci, @Local(argsOnly=true) Consumer<class_2561> textConsumer) {
        String skyblockId;
        if (Utils.isOnSkyblock() && !(skyblockId = this.getSkyblockId()).isEmpty()) {
            textConsumer.accept((class_2561)class_2561.method_43470((String)("skyblock:" + skyblockId)).method_27692(class_124.field_1063));
        }
    }

    @Inject(method={"method_7917(Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;Lnet/minecraft/class_1304;)V"}, at={@At(value="TAIL")})
    private void skyblocker$updateDamage(CallbackInfo ci) {
        if (!this.skyblocker$shouldProcess()) {
            return;
        }
        this.skyblocker$getAndCacheDurability();
    }

    @ModifyReturnValue(method={"method_7919()I"}, at={@At(value="RETURN")})
    private int skyblocker$handleDamage(int original) {
        if (!this.skyblocker$shouldProcess() || this.maxDamage != 0) {
            return original;
        }
        return this.skyblocker$getAndCacheDurability() ? this.method_7919() : original;
    }

    @ModifyReturnValue(method={"method_7936()I"}, at={@At(value="RETURN")})
    private int skyblocker$handleMaxDamage(int original) {
        if (!this.skyblocker$shouldProcess()) {
            return original;
        }
        if (this.maxDamage != 0) {
            return this.maxDamage;
        }
        return this.skyblocker$getAndCacheDurability() ? this.maxDamage : original;
    }

    @Inject(method={"method_57379(Lnet/minecraft/class_9331;Ljava/lang/Object;)Ljava/lang/Object;"}, at={@At(value="TAIL")})
    private <T> void skyblocker$resetUuid(class_9331<T> type, @Nullable T value, CallbackInfoReturnable<T> cir) {
        if (type == class_9334.field_49628) {
            this.uuid = null;
        }
    }

    @ModifyReturnValue(method={"method_7963()Z"}, at={@At(value="RETURN")})
    private boolean skyblocker$handleDamageable(boolean original) {
        return this.skyblocker$shouldProcess() || original;
    }

    @ModifyReturnValue(method={"method_7986()Z"}, at={@At(value="RETURN")})
    private boolean skyblocker$handleDamaged(boolean original) {
        return this.skyblocker$shouldProcess() || original;
    }

    @Unique
    private boolean skyblocker$shouldProcess() {
        return (class_310.method_1551() == null || !(class_310.method_1551().field_1755 instanceof ProfileViewerScreen)) && Utils.isOnSkyblock() && SkyblockerConfigManager.get().mining.enableDrillFuel && ItemUtils.hasCustomDurability((class_1799)this);
    }

    @Unique
    private boolean skyblocker$getAndCacheDurability() {
        IntIntPair durability = ItemUtils.getDurability((class_1799)this);
        if (durability == null) {
            return false;
        }
        this.maxDamage = durability.rightInt();
        this.method_7974(durability.rightInt() - durability.leftInt());
        return true;
    }

    @Override
    @NotNull
    public String getSkyblockId() {
        if (this.skyblockId != null && !this.skyblockId.isEmpty()) {
            return this.skyblockId;
        }
        this.skyblockId = ItemUtils.getItemId(this);
        return this.skyblockId;
    }

    @Override
    @NotNull
    public String getSkyblockApiId() {
        if (this.skyblockApiId != null && !this.skyblockApiId.isEmpty()) {
            return this.skyblockApiId;
        }
        this.skyblockApiId = ItemUtils.getSkyblockApiId(this);
        return this.skyblockApiId;
    }

    @Override
    @NotNull
    public String getNeuName() {
        if (this.neuName != null && !this.neuName.isEmpty()) {
            return this.neuName;
        }
        this.neuName = ItemUtils.getNeuId((class_1799)this);
        return this.neuName;
    }

    @Override
    @NotNull
    public String getUuid() {
        if (this.uuid != null) {
            return this.uuid;
        }
        this.uuid = ItemUtils.getItemUuid(this);
        return this.uuid;
    }

    @Override
    @NotNull
    public PetInfo getPetInfo() {
        if (this.petInfo != null) {
            return this.petInfo;
        }
        this.petInfo = ItemUtils.getPetInfo((class_1799)this);
        return this.petInfo;
    }

    @Override
    @NotNull
    public SkyblockItemRarity getSkyblockRarity() {
        if (this.skyblockRarity != null) {
            return this.skyblockRarity;
        }
        this.skyblockRarity = ItemUtils.getItemRarity((class_1799)this);
        return this.skyblockRarity;
    }
}

