/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.mixins.accessors.HandledScreenAccessor;
import de.hysky.skyblocker.mixins.accessors.ScreenAccessor;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.hunting.Attributes;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_9322;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChestValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChestValue.class);
    private static final Set<String> DUNGEON_CHESTS = Set.of("Wood Chest", "Gold Chest", "Diamond Chest", "Emerald Chest", "Obsidian Chest", "Bedrock Chest");
    private static final Pattern ESSENCE_PATTERN = Pattern.compile("(?<type>[A-Za-z]+) Essence x(?<amount>\\d+)");
    private static final Pattern SHARD_PATTERN = Pattern.compile("[A-Za-z ]+ Shard x(?<amount>\\d+)");
    private static final Pattern MINION_PATTERN = Pattern.compile("Minion (I|II|III|IV|V|VI|VII|VIII|IX|X|XI|XII)$");
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###");

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (Utils.isOnSkyblock() && screen instanceof class_476) {
                class_476 genericContainerScreen = (class_476)screen;
                class_2561 title = screen.method_25440();
                String titleString = title.getString();
                if (DUNGEON_CHESTS.contains(titleString)) {
                    if (SkyblockerConfigManager.get().dungeons.dungeonChestProfit.enableProfitCalculator) {
                        ScreenEvents.afterTick((class_437)screen).register(ignored -> {
                            class_2561 dungeonChestProfit = ChestValue.getDungeonChestProfit((class_1707)genericContainerScreen.method_17577());
                            if (dungeonChestProfit != null) {
                                ChestValue.addValueToContainer(genericContainerScreen, dungeonChestProfit, title);
                            }
                        });
                    }
                } else if (SkyblockerConfigManager.get().uiAndVisuals.chestValue.enableChestValue && !titleString.equals("SkyBlock Menu")) {
                    ScreenType screenType = ChestValue.determineScreenType(titleString);
                    Screens.getButtons((class_437)screen).add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"$"), buttonWidget -> {
                        Screens.getButtons((class_437)screen).remove(buttonWidget);
                        ScreenEvents.afterTick((class_437)screen).register(ignored -> {
                            class_2561 chestValue = ChestValue.getChestValue((class_1707)genericContainerScreen.method_17577(), screenType);
                            if (chestValue != null) {
                                ChestValue.addValueToContainer(genericContainerScreen, chestValue, title);
                            }
                        });
                    }).method_46434(((HandledScreenAccessor)genericContainerScreen).getX() + ((HandledScreenAccessor)genericContainerScreen).getBackgroundWidth() - 16, ((HandledScreenAccessor)genericContainerScreen).getY() + 4, 12, 12).method_46436(class_7919.method_47407((class_2561)ChestValue.getButtonTooltipText(screenType))).method_46431());
                }
            }
        });
    }

    @Nullable
    private static class_2561 getDungeonChestProfit(class_1707 handler) {
        try {
            double profit = 0.0;
            boolean hasIncompleteData = false;
            boolean usedKismet = false;
            List slots = handler.field_7761.subList(0, handler.method_17388() * 9);
            if (((class_1735)slots.get(31)).method_7677().method_7960() || ((class_1735)slots.get(50)).method_7677().method_7960()) {
                return null;
            }
            for (class_1735 slot : slots) {
                Matcher matcher;
                class_1799 stack = slot.method_7677();
                if (stack.method_7960()) continue;
                String name = stack.method_7964().getString();
                String skyblockApiId = stack.getSkyblockApiId();
                if (!(skyblockApiId.isEmpty() || name.contains("Essence") || name.contains("Shard"))) {
                    DoubleBooleanPair priceData = ItemUtils.getItemPrice(skyblockApiId);
                    if (!priceData.rightBoolean()) {
                        hasIncompleteData = true;
                    }
                    profit += priceData.leftDouble() * (double)stack.method_7947();
                    continue;
                }
                if (name.contains("Essence") && SkyblockerConfigManager.get().dungeons.dungeonChestProfit.includeEssence && (matcher = ESSENCE_PATTERN.matcher(name)).matches()) {
                    String type = matcher.group("type");
                    int amount = Integer.parseInt(matcher.group("amount"));
                    DoubleBooleanPair priceData = ItemUtils.getItemPrice(("ESSENCE_" + type).toUpperCase(Locale.ENGLISH));
                    if (!priceData.rightBoolean()) {
                        hasIncompleteData = true;
                    }
                    profit += priceData.leftDouble() * (double)amount;
                    continue;
                }
                if (name.contains("Shard") && (matcher = SHARD_PATTERN.matcher(name)).matches()) {
                    int shards = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                    Attribute attribute = Attributes.getAttributeFromItemName((class_9322)stack);
                    if (attribute == null) {
                        LOGGER.warn("[Skyblocker Profit Calculator] Encountered unknown shard {}", (Object)name);
                        continue;
                    }
                    String shardApiId = attribute.apiId();
                    DoubleBooleanPair priceData = ItemUtils.getItemPrice(shardApiId);
                    if (!priceData.rightBoolean()) {
                        hasIncompleteData = true;
                    }
                    profit += priceData.leftDouble() * (double)shards;
                    continue;
                }
                if (name.contains("Open Reward Chest")) {
                    String foundString = ChestValue.searchLoreFor(stack, "Coins");
                    if (StringUtils.isBlank((CharSequence)foundString)) continue;
                    profit -= (double)Integer.parseInt(foundString.replaceAll("\\D", ""));
                    continue;
                }
                if (!name.contains("Reroll Chest")) continue;
                usedKismet = !StringUtils.isBlank((CharSequence)ChestValue.searchLoreFor(stack, "You already rerolled a chest!"));
            }
            if (SkyblockerConfigManager.get().dungeons.dungeonChestProfit.includeKismet && usedKismet) {
                DoubleBooleanPair kismetPriceData = ItemUtils.getItemPrice("KISMET_FEATHER");
                if (!kismetPriceData.rightBoolean()) {
                    hasIncompleteData = true;
                }
                profit -= kismetPriceData.leftDouble();
            }
            return ChestValue.getProfitText((long)profit, hasIncompleteData);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Profit Calculator] Failed to calculate dungeon chest profit! ", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static class_2561 getChestValue(class_1707 handler, @NotNull ScreenType screenType) {
        try {
            double value = 0.0;
            boolean hasIncompleteData = false;
            List slots = switch (screenType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ChestValue.getMinionSlots(handler);
                case 1 -> handler.field_7761.subList(10, handler.method_17388() * 9 - 10);
                case 2 -> handler.field_7761.subList(0, (handler.method_17388() - 1) * 9);
                case 3 -> handler.field_7761.subList(0, handler.method_17388() * 9);
            };
            for (class_1735 slot : slots) {
                int count;
                String coinsLine;
                class_1799 stack = slot.method_7677();
                if (stack.method_7960()) continue;
                if (screenType == ScreenType.MINION && slot.field_7874 == 28 && stack.method_31574(class_1802.field_8239) && (coinsLine = ItemUtils.getLoreLineIf(stack, s -> s.contains("Held Coins:"))) != null) {
                    String source = coinsLine.split(":")[1];
                    try {
                        value += NumberFormat.getNumberInstance(Locale.US).parse(source.trim()).doubleValue();
                    }
                    catch (ParseException e) {
                        LOGGER.warn("[Skyblocker] Failed to parse `{}`", (Object)source);
                    }
                    continue;
                }
                String id = stack.getSkyblockApiId();
                if ((count = (switch (screenType.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1 -> {
                        List<class_2561> lines = ItemUtils.getLore(stack);
                        yield ItemUtils.getItemCountInSack(stack, lines, true).orElse(0);
                    }
                    case 2 -> ItemUtils.getItemCountInStash(stack).orElse(0);
                    case 0, 3 -> stack.method_7947();
                })) == 0 || id.isEmpty()) continue;
                DoubleBooleanPair priceData = ItemUtils.getItemPrice(id);
                if (!priceData.rightBoolean()) {
                    hasIncompleteData = true;
                }
                value += NetworthCalculator.getItemNetworth(stack, count).price();
            }
            return ChestValue.getValueText((long)value, hasIncompleteData);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Value Calculator] Failed to calculate dungeon chest value! ", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<class_1735> getMinionSlots(class_1707 handler) {
        return handler.field_7761.subList(0, handler.method_17388() * 9).stream().filter(slot -> {
            int x = slot.field_7874 % 9;
            int y = slot.field_7874 / 9;
            return x > 2 && x < 8 && y > 1 && y < 5 || slot.field_7874 == 28;
        }).toList();
    }

    private static String searchLoreFor(class_1799 stack, String searchString) {
        return ItemUtils.getLoreLineIf(stack, line -> line.contains(searchString));
    }

    static class_2561 getProfitText(long profit, boolean hasIncompleteData) {
        return class_2561.method_43470((String)(String.valueOf(profit > 0L ? " +" : Character.valueOf(' ')) + FORMATTER.format(profit) + " Coins")).method_27692(ChestValue.getProfitColor(hasIncompleteData, profit));
    }

    @NotNull
    static class_124 getProfitColor(boolean hasIncompleteData, long profit) {
        DungeonsConfig.DungeonChestProfit config = SkyblockerConfigManager.get().dungeons.dungeonChestProfit;
        if (hasIncompleteData) {
            return config.incompleteColor;
        }
        if (Math.abs(profit) < (long)config.neutralThreshold) {
            return config.neutralColor;
        }
        if (profit > 0L) {
            return config.profitColor;
        }
        return config.lossColor;
    }

    @NotNull
    static class_2561 getValueText(long value, boolean hasIncompleteData) {
        UIAndVisualsConfig.ChestValue config = SkyblockerConfigManager.get().uiAndVisuals.chestValue;
        return class_2561.method_43470((String)(" " + FORMATTER.format(value) + " Coins")).method_27692(hasIncompleteData ? config.incompleteColor : config.color);
    }

    private static void addValueToContainer(class_476 genericContainerScreen, class_2561 chestValue, class_2561 title) {
        Screens.getButtons((class_437)genericContainerScreen).removeIf(ChestValueTextWidget.class::isInstance);
        int backgroundWidth = ((HandledScreenAccessor)genericContainerScreen).getBackgroundWidth();
        int y = ((HandledScreenAccessor)genericContainerScreen).getY();
        int x = ((HandledScreenAccessor)genericContainerScreen).getX();
        ((ScreenAccessor)genericContainerScreen).setTitle((class_2561)class_2561.method_43473());
        class_327 textRenderer = class_310.method_1551().field_1772;
        int chestValueWidth = Math.min(textRenderer.method_27525((class_5348)chestValue), Math.max((backgroundWidth - 8) / 2 - 2, backgroundWidth - 8 - textRenderer.method_27525((class_5348)title)));
        Objects.requireNonNull(textRenderer);
        ChestValueTextWidget chestValueWidget = new ChestValueTextWidget(chestValueWidth, 9, chestValue, textRenderer);
        chestValueWidget.method_48229(x + backgroundWidth - chestValueWidget.method_25368() - 4, y + 6);
        Screens.getButtons((class_437)genericContainerScreen).add(chestValueWidget);
        Objects.requireNonNull(textRenderer);
        ChestValueTextWidget chestTitleWidget = new ChestValueTextWidget(backgroundWidth - 8 - chestValueWidth - 2, 9, (class_2561)title.method_27661().method_27696(class_2583.field_24360.method_36139(0x404040)), textRenderer);
        chestTitleWidget.method_48229(x + 8, y + 6);
        Screens.getButtons((class_437)genericContainerScreen).add(chestTitleWidget);
    }

    @NotNull
    private static ScreenType determineScreenType(String rawTitleString) {
        if (StringUtils.containsIgnoreCase((CharSequence)rawTitleString, (CharSequence)"sack")) {
            return ScreenType.SACK;
        }
        if (MINION_PATTERN.matcher(rawTitleString.trim()).find()) {
            return ScreenType.MINION;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)rawTitleString, (CharSequence)"View Stash")) {
            return ScreenType.STASH;
        }
        return ScreenType.OTHER;
    }

    @NotNull
    private static class_2561 getButtonTooltipText(ScreenType screenType) {
        return switch (screenType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2561.method_43471((String)"skyblocker.containerValue.minionValue.@Tooltip");
            case 3 -> class_2561.method_43471((String)"skyblocker.containerValue.chestValue.@Tooltip");
            case 2 -> class_2561.method_43471((String)"skyblocker.containerValue.stashValue.@Tooltip");
            case 1 -> class_2561.method_43471((String)"skyblocker.containerValue.sackValue.@Tooltip");
        };
    }

    private static enum ScreenType {
        MINION,
        SACK,
        STASH,
        OTHER;

    }

    private static class ChestValueTextWidget
    extends class_7842 {
        private static final boolean shadow = false;

        private ChestValueTextWidget(int width, int height, class_2561 message, class_327 textRenderer) {
            super(width, height, message, textRenderer);
            this.method_48596();
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            this.draw(context, this.method_48977(), this.method_25369(), this.method_46426(), this.method_55442());
        }

        protected void draw(class_332 context, class_327 textRenderer, class_2561 text, int startX, int endX) {
            int k;
            int i = textRenderer.method_27525((class_5348)text);
            if (i > (k = endX - startX)) {
                int l = i - k;
                double d = (double)class_156.method_658() / 600.0;
                double e = Math.max((double)l * 0.5, 3.0);
                double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
                int n = this.method_46427();
                int n2 = this.method_46427();
                Objects.requireNonNull(textRenderer);
                context.method_44379(startX, n, endX, n2 + 9);
                context.method_51439(textRenderer, text, startX - (int)g, this.method_46427(), -1, false);
                context.method_44380();
            } else {
                context.method_51439(textRenderer, text, startX, this.method_46427(), -1, false);
            }
        }
    }
}

