/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.OkLabColor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.apache.commons.lang3.math.NumberUtils;

public class CompactDamage {
    private static final Pattern DAMAGE_PATTERN = Pattern.compile("([\u2727\u272f]?)[\\d,]+[\u2727\u272f]?([\u2764+\u2694]?)");

    private CompactDamage() {
    }

    public static void compactDamage(class_1531 entity) {
        class_5251 textColor;
        String dmg;
        boolean isCrit;
        if (!SkyblockerConfigManager.get().uiAndVisuals.compactDamage.enabled) {
            return;
        }
        if (!(entity.method_5767() && entity.method_16914() && entity.method_5807())) {
            return;
        }
        class_2561 customName = entity.method_5797();
        if (customName == null) {
            return;
        }
        Matcher matcher = DAMAGE_PATTERN.matcher(customName.getString());
        if (!matcher.matches()) {
            return;
        }
        List siblings = customName.method_10855();
        if (siblings.isEmpty()) {
            return;
        }
        boolean bl = isCrit = !matcher.group(1).isEmpty();
        if (siblings.size() == 1) {
            class_2561 text = (class_2561)siblings.getFirst();
            dmg = text.getString().replace(",", "");
            textColor = text.method_10866().method_10973();
        } else {
            int symbolsToRemoveFront = isCrit ? 1 : 0;
            int symbolsToRemoveEnd = matcher.group(2).isEmpty() ? symbolsToRemoveFront : symbolsToRemoveFront + 1;
            textColor = ((class_2561)siblings.get(symbolsToRemoveFront)).method_10866().method_10973();
            dmg = siblings.subList(symbolsToRemoveFront, siblings.size() - symbolsToRemoveEnd).stream().map(class_2561::getString).reduce("", String::concat).replace(",", "");
        }
        if (!NumberUtils.isParsable((String)dmg)) {
            return;
        }
        class_5250 prettierCustomName = class_2561.method_43473();
        if (!isCrit) {
            String prettifiedDmg = CompactDamage.prettifyDamageNumber(Long.parseLong(dmg));
            int color = textColor != null ? (textColor == class_5251.method_27718((class_124)class_124.field_1080) ? SkyblockerConfigManager.get().uiAndVisuals.compactDamage.normalDamageColor.getRGB() & 0xFFFFFF : textColor.method_27716()) : SkyblockerConfigManager.get().uiAndVisuals.compactDamage.normalDamageColor.getRGB() & 0xFFFFFF;
            prettierCustomName = class_2561.method_43470((String)prettifiedDmg).method_10862(customName.method_10866()).method_54663(color);
        } else {
            String dmgSymbol = matcher.group(1);
            String prettifiedDmg = dmgSymbol + CompactDamage.prettifyDamageNumber(Long.parseLong(dmg)) + dmgSymbol;
            int length = prettifiedDmg.length();
            for (int i = 0; i < length; ++i) {
                prettierCustomName.method_10852((class_2561)class_2561.method_43470((String)prettifiedDmg.substring(i, i + 1)).method_54663(OkLabColor.interpolate(SkyblockerConfigManager.get().uiAndVisuals.compactDamage.critDamageGradientStart.getRGB() & 0xFFFFFF, SkyblockerConfigManager.get().uiAndVisuals.compactDamage.critDamageGradientEnd.getRGB() & 0xFFFFFF, (float)i / ((float)length - 1.0f))));
            }
            prettierCustomName.method_10862(customName.method_10866());
        }
        if (!matcher.group(2).isEmpty()) {
            prettierCustomName.method_10852((class_2561)class_2561.method_43470((String)matcher.group(2)).method_10862(((class_2561)siblings.getLast()).method_10866()));
        }
        entity.method_5665((class_2561)prettierCustomName);
    }

    private static String prettifyDamageNumber(long damage) {
        if (damage < 1000L) {
            return String.valueOf(damage);
        }
        if (damage < 1000000L) {
            return CompactDamage.format((double)damage / 1000.0) + "k";
        }
        if (damage < 1000000000L) {
            return CompactDamage.format((double)damage / 1000000.0) + "M";
        }
        if (damage < 1000000000000L) {
            return CompactDamage.format((double)damage / 1.0E9) + "B";
        }
        return CompactDamage.format((double)damage / 1.0E12) + "T";
    }

    private static String format(double number) {
        return ("%." + SkyblockerConfigManager.get().uiAndVisuals.compactDamage.precision + "f").formatted(number);
    }
}

