/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.class_1074;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_9848;

public class GyroOverlay {
    private static final class_310 CLIENT = class_310.method_1551();
    private static float[] colorComponents;
    private static final int GYRO_RADIUS = 10;
    private static final int SEGMENTS = 32;
    private static final int MAX_REACH = 24;

    @Init
    public static void init() {
        GyroOverlay.configCallback(SkyblockerConfigManager.get().uiAndVisuals.gyroOverlay.gyroOverlayColor);
        WorldRenderExtractionCallback.EVENT.register(GyroOverlay::extractRendering);
    }

    public static void extractRendering(PrimitiveCollector collector) {
        if (GyroOverlay.CLIENT.field_1724 == null || GyroOverlay.CLIENT.field_1687 == null) {
            return;
        }
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (SkyblockerConfigManager.get().uiAndVisuals.gyroOverlay.gyroOverlayMode == Mode.OFF) {
            return;
        }
        String heldItem = GyroOverlay.CLIENT.field_1724.method_6047().getSkyblockId();
        if (!heldItem.equals("GYROKINETIC_WAND")) {
            return;
        }
        class_239 hit = GyroOverlay.CLIENT.field_1719.method_5745(24.0, class_310.method_1551().method_61966().method_60637(false), false);
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        int color = class_9848.method_61318((float)colorComponents[3], (float)colorComponents[0], (float)colorComponents[1], (float)colorComponents[2]);
        switch (SkyblockerConfigManager.get().uiAndVisuals.gyroOverlay.gyroOverlayMode.ordinal()) {
            case 0: {
                break;
            }
            case 2: {
                collector.submitOutlinedCircle(hit.method_17784().method_1019(new class_243(0.0, 0.1, 0.0)), 10.0f, 0.25f, 32, color);
                break;
            }
            case 1: {
                collector.submitFilledCircle(hit.method_17784().method_1019(new class_243(0.0, 0.1, 0.0)), 10.0f, 32, color);
                break;
            }
            case 3: {
                collector.submitSphere(hit.method_17784(), 10.0f, 32, 32, color);
            }
        }
    }

    public static void configCallback(Color color) {
        colorComponents = color.getRGBComponents(null);
    }

    public static enum Mode implements class_3542
    {
        OFF("OFF"),
        CIRCLE("CIRCLE"),
        CIRCLE_OUTLINE("CIRCLE_OUTLINE"),
        SPHERE("SPHERE");

        private final String key;

        private Mode(String key) {
            this.key = "skyblocker.config.uiAndVisuals.gyroOverlay.mode." + key;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public String toString() {
            return class_1074.method_4662((String)this.key, (Object[])new Object[0]);
        }
    }
}

