/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.util.Ico;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.SeparatorComponent;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import io.github.moulberry.repo.data.NEUItem;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;

@RegisterWidget
public class ItemPickupWidget
extends ComponentBasedWidget {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final int LOBBY_CHANGE_DELAY = 60;
    private static final String SACKS_MESSAGE_START = "[Sacks]";
    private static final Pattern CHANGE_REGEX = Pattern.compile("([+-])([\\d,]+) (.+) \\((.+)\\)");
    private static ItemPickupWidget instance;
    private boolean changingLobby;
    private final Object2ObjectOpenHashMap<String, ChangeData> addedCount = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, ChangeData> removedCount = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, ChangeData> addedSackCount = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, ChangeData> removedSackCount = new Object2ObjectOpenHashMap();

    public ItemPickupWidget() {
        super(class_2561.method_43470((String)"Items"), class_124.field_1075.method_532(), "Item Pickup");
        instance = this;
        ClientReceiveMessageEvents.ALLOW_GAME.register(instance::onChatMessage);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> {
            this.changingLobby = true;
        });
        SkyblockEvents.LOCATION_CHANGE.register(location -> Scheduler.INSTANCE.schedule(() -> {
            this.changingLobby = false;
        }, 60));
    }

    public static ItemPickupWidget getInstance() {
        return instance;
    }

    private static class_1799 getItem(String itemName) {
        if (NEURepoManager.isLoading() || !ItemRepository.filesImported()) {
            return new class_1799((class_1935)class_1802.field_8077);
        }
        return NEURepoManager.getItemByName(itemName).stream().findFirst().map(NEUItem::getSkyblockItemId).map(ItemRepository::getItemStack).orElseGet(() -> new class_1799((class_1935)class_1802.field_8077));
    }

    private boolean onChatMessage(class_2561 message, boolean overlay) {
        if (!class_124.method_539((String)message.getString()).startsWith(SACKS_MESSAGE_START)) {
            return true;
        }
        if (!SkyblockerConfigManager.get().uiAndVisuals.itemPickup.sackNotifications) {
            return true;
        }
        class_2568 hoverEvent = ((class_2561)message.method_10855().getFirst()).method_10866().method_10969();
        if (hoverEvent == null || hoverEvent.method_10892() != class_2568.class_5247.field_24342) {
            return true;
        }
        String hoverMessage = ((class_2568.class_10613)hoverEvent).comp_3510().getString();
        Matcher matcher = CHANGE_REGEX.matcher(hoverMessage);
        while (matcher.find()) {
            class_1799 item = ItemPickupWidget.getItem(matcher.group(3));
            int existingCount = 0;
            if (matcher.group(1).equals("+")) {
                if (this.addedSackCount.containsKey((Object)item.getNeuName())) {
                    existingCount = ((ChangeData)this.addedSackCount.get((Object)item.getNeuName())).amount;
                }
                this.addedSackCount.put((Object)item.getNeuName(), (Object)new ChangeData(item, existingCount + Formatters.parseNumber(matcher.group(2)).intValue(), System.currentTimeMillis()));
                continue;
            }
            if (!matcher.group(1).equals("-")) continue;
            if (this.removedSackCount.containsKey((Object)item.getNeuName())) {
                existingCount = ((ChangeData)this.removedSackCount.get((Object)item.getNeuName())).amount;
            }
            this.removedSackCount.put((Object)item.getNeuName(), (Object)new ChangeData(item, existingCount - Formatters.parseNumber(matcher.group(2)).intValue(), System.currentTimeMillis()));
        }
        return true;
    }

    @Override
    public boolean shouldUpdateBeforeRendering() {
        return true;
    }

    @Override
    public void updateContent() {
        String itemName;
        ChangeData entry;
        if (class_310.method_1551().field_1755 instanceof WidgetsConfigurationScreen) {
            this.addSimpleIcoText(Ico.BONE, "Bone ", class_124.field_1060, "+64");
            return;
        }
        boolean split = SkyblockerConfigManager.get().uiAndVisuals.itemPickup.splitNotifications;
        if (!split) {
            ChangeData generalEntry;
            ChangeData sackEntry;
            for (String item : this.addedSackCount.keySet()) {
                sackEntry = (ChangeData)this.addedSackCount.get((Object)item);
                if (this.addedCount.containsKey((Object)item)) {
                    generalEntry = (ChangeData)this.addedCount.get((Object)item);
                    this.addedCount.put((Object)item, (Object)new ChangeData(generalEntry.item, generalEntry.amount + sackEntry.amount, System.currentTimeMillis()));
                    continue;
                }
                this.addedCount.put((Object)item, (Object)new ChangeData(sackEntry.item, sackEntry.amount, System.currentTimeMillis()));
            }
            for (String item : this.removedSackCount.keySet()) {
                sackEntry = (ChangeData)this.removedSackCount.get((Object)item);
                if (this.removedCount.containsKey((Object)item)) {
                    generalEntry = (ChangeData)this.removedCount.get((Object)item);
                    this.removedCount.put((Object)item, (Object)new ChangeData(generalEntry.item, generalEntry.amount + sackEntry.amount, System.currentTimeMillis()));
                    continue;
                }
                this.removedCount.put((Object)item, (Object)new ChangeData(sackEntry.item, sackEntry.amount, System.currentTimeMillis()));
            }
            this.addedSackCount.clear();
            this.removedSackCount.clear();
        }
        for (String item : this.addedCount.keySet()) {
            entry = (ChangeData)this.addedCount.get((Object)item);
            itemName = this.checkNextItem(entry);
            if (itemName == null) {
                this.addedCount.remove((Object)item);
                continue;
            }
            this.addSimpleIcoText(entry.item, itemName, class_124.field_1060, Formatters.DIFF_NUMBERS.format(entry.amount));
        }
        for (String item : this.removedCount.keySet()) {
            entry = (ChangeData)this.removedCount.get((Object)item);
            itemName = this.checkNextItem(entry);
            if (itemName == null) {
                this.removedCount.remove((Object)item);
                continue;
            }
            this.addSimpleIcoText(entry.item, itemName, class_124.field_1061, Formatters.DIFF_NUMBERS.format(entry.amount));
        }
        if (!(!split || this.addedSackCount.isEmpty() && this.removedSackCount.isEmpty())) {
            this.addComponent(new SeparatorComponent(class_2561.method_30163((String)"Sacks")));
            for (String item : this.addedSackCount.keySet()) {
                entry = (ChangeData)this.addedSackCount.get((Object)item);
                itemName = this.checkNextItem(entry);
                if (itemName == null) {
                    this.addedSackCount.remove((Object)item);
                    continue;
                }
                this.addSimpleIcoText(entry.item, itemName, class_124.field_1060, Formatters.DIFF_NUMBERS.format(entry.amount));
            }
            for (String item : this.removedSackCount.keySet()) {
                entry = (ChangeData)this.removedSackCount.get((Object)item);
                itemName = this.checkNextItem(entry);
                if (itemName == null) {
                    this.removedSackCount.remove((Object)item);
                    continue;
                }
                this.addSimpleIcoText(entry.item, itemName, class_124.field_1061, Formatters.DIFF_NUMBERS.format(entry.amount));
            }
        }
    }

    private String checkNextItem(ChangeData entry) {
        if (entry.lastChange + (long)SkyblockerConfigManager.get().uiAndVisuals.itemPickup.lifeTime * 1000L < System.currentTimeMillis()) {
            return null;
        }
        return SkyblockerConfigManager.get().uiAndVisuals.itemPickup.showItemName ? entry.item.method_7964().getString() + " " : " ";
    }

    @Override
    public boolean shouldRender(Location location) {
        if (super.shouldRender(location) && SkyblockerConfigManager.get().uiAndVisuals.itemPickup.enabled) {
            return !this.addedCount.isEmpty() || !this.removedCount.isEmpty() || !this.addedSackCount.isEmpty() || !this.removedSackCount.isEmpty();
        }
        return false;
    }

    @Override
    public Set<Location> availableLocations() {
        return ALL_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        SkyblockerConfigManager.get().uiAndVisuals.itemPickup.enabled = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        return SkyblockerConfigManager.get().uiAndVisuals.itemPickup.enabled;
    }

    public void onItemPickup(int slot, class_1799 newStack) {
        if (this.changingLobby || ItemPickupWidget.CLIENT.field_1724 == null) {
            return;
        }
        if (ItemPickupWidget.CLIENT.field_1755 != null) {
            return;
        }
        if (slot < 9 || slot >= 45) {
            return;
        }
        if (slot >= 36) {
            slot -= 36;
        }
        if (slot == 8) {
            return;
        }
        class_1799 oldStack = (class_1799)ItemPickupWidget.CLIENT.field_1724.method_31548().method_67533().get(slot);
        int existingCount = 0;
        int countDiff = newStack.method_7947() - oldStack.method_7947();
        if (newStack.method_7909() == class_1802.field_8162) {
            if (oldStack.method_7909() == class_1802.field_8162) {
                return;
            }
            if (this.removedCount.containsKey((Object)oldStack.getNeuName())) {
                existingCount = ((ChangeData)this.removedCount.get((Object)oldStack.getNeuName())).amount;
            }
            this.removedCount.put((Object)oldStack.getNeuName(), (Object)new ChangeData(oldStack, existingCount - oldStack.method_7947(), System.currentTimeMillis()));
            return;
        }
        if (countDiff > 0) {
            if (this.addedCount.containsKey((Object)newStack.getNeuName())) {
                existingCount = ((ChangeData)this.addedCount.get((Object)newStack.getNeuName())).amount;
            }
            this.addedCount.put((Object)newStack.getNeuName(), (Object)new ChangeData(newStack, existingCount + countDiff, System.currentTimeMillis()));
        } else if (countDiff < 0) {
            if (this.removedCount.containsKey((Object)newStack.getNeuName())) {
                existingCount = ((ChangeData)this.removedCount.get((Object)newStack.getNeuName())).amount;
            }
            this.removedCount.put((Object)newStack.getNeuName(), (Object)new ChangeData(newStack, existingCount + countDiff, System.currentTimeMillis()));
        }
    }

    private record ChangeData(class_1799 item, int amount, long lastChange) {
    }
}

